#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


**********************************************************
*                                                        *
*         Main_Program                                   *
*                                                        *
*         Provided By:                                   *
*                       Prof. D.M. Etter                 *
*                                                        *
*         Developed By:                                  *
*                       Mark Young                       *
*                       Matt Harmsen                     *
*                       Pat Barnes                       *
*                       Brad Lohrding                    *
*                       Duke McMullan                    *
*                                                        *
**********************************************************
*
*  Copyright 1988, by D.M. Etter, All rights reserved;
*          EECE Dept, University of New Mexico
*         Albuquereque, New Mexico,  87131  USA
*
**********************************************************
*
*
*     PROGRAM DESCRIPTION:
*
*       This program is an interactive, independent 
*       XY plotting package. The program allows the user 
*       to interactively plot curves, according to a series 
*       of options. The package supports several types of
*       graphic terminals, and is modular in fashion, allowing
*       for easy addition of graphics modules.
*
*
*
*       PROGRAM STRUCTURE:
*
*
*
*                           Program  Structure  Chart
*                   --------------------------------------------
*
*                               ----------
*                               | XYplot |
*                               ----------
*                                   | 
*        -----------------------------------------------------------
*        |                          |             |                |
*   ----------                      |         ----------      ----------
*   |  Logo  |                      |         |  Menu  |      | Datain |
*   ----------                      |         ----------      ----------
*                                   |             |                |
*                      -------------+-------------|       ----------------
*                      |            |             |       |              |
*                  ----------       |             |   ----------     ----------
*                  | Online |       |             |   |  File  |     |  User  |
*                  ----------       |             |   ----------     ----------
*                      |            |             |       |              |
*                      -----------  |             |       |   -----------|
*                                |  |             |       |   |          |
*                  ----------   ----------        |   ----------     ----------
*                  | Gethlp |   | Termcp |        |   | MaxMin |     |  Save  |
*                  ----------   ----------        |   ----------     ----------
*                                                 |
*       ------------------------------------------+------------------------
*       |               |             |           |         |             |
*   ----------     ----------    ----------            ----------    ----------
*   | WinVew |     | Curve  |    | Ticks  |       |    | Label  |    | Debug  |
*   ----------     ----------    ----------       |    ----------    ----------
*       |                                         |
*       |               --------------------------+------------------------
*       |               |                         |         |             |
*   ----------     ----------                     |    ----------    ----------
*   | Window |     | Crvpl  |                     |    | Color  |    | Shade  |
*   ----------     ----------                     |    ----------    ----------
*                       |                         |
*       ----------------------------    -----------------------------------
*       |               |          |    |                   |             |
*   ----------     ----------    ----------            ----------    ----------
*   | Spcoef |     | Svalue |    |  Plot  |            | LineTp |    | Interp |
*   ----------     ----------    ----------            ----------    ----------
*                                    |
*       -----------------------------+-------------------------------------
*       |               |            |                      |             |     
*   ----------     ----------        |                 ----------    ----------
*   |  Clip  |     | Points |        |                 | DisBar |    | Interp |
*   ----------     ----------        |                 ----------    ----------
*                                    |
*       -----------------------------+-------------------------------------
*       |               |            |                      |             |
*   ----------     ----------    ----------            ----------    ----------
*   | VTRegD |     | GigiD  |    | VTTekD |            |  TekD  |    |  SunD  |
*   ----------     ----------    ----------            ----------    ----------
*       |               |            |                      |             |
*       -----------------            -----------------------|--------------
*               |                                           |
*           ----------                                 ----------
*           | GigiBx |                                 | TekBox |
*           ----------                                 ----------
*
*
*
*                             Tools  and  External Files
*                         ---------------------------------
*
*               Tools -
*
*   ----------    ----------    ----------    ----------    ----------
*   |  ands  |    | andzro |    | clear  |    | compte |    |  init  |
*   ----------    ----------    ----------    ----------    ----------
*
*   ----------    ----------    ----------    ----------    ----------
*   | inital |    |  ors   |    | shiftL |    | shiftR |    | tekcrd |
*   ----------    ----------    ----------    ----------    ----------
*
*
*
*               External Files - (help files)
*
*   ----------    ----------    ----------    ----------    ----------
*   | help1  |    | help2  |    | help3  |    | help4  |    | help5  |
*   ----------    ----------    ----------    ----------    ----------
*
*   ----------    ----------    ----------    ----------    ----------
*   | help6  |    | help7  |    | help8  |    | help9  |    | help10 |
*   ----------    ----------    ----------    ----------    ----------
*
*   ----------    ----------    ---------- 
*   | help11 |    | help12 |    | help13 |
*   ----------    ----------    ---------- 
*
*
*
*
***************************************************************************


* 

*               *******************  MAIN PROGRAM  ********************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Program XYplot

        Real       X(10000, 3), Y(10000, 3)
        Integer    NumCrv, Numpt(3), term
        Logical    done
        Character  ans


*       (* Used to prompt the user for their terminal type. *)
        term = 0
        Call Termcp(term)

*       (* Displays the package's logo. *)
        Call Logo (term)

*       (* Calls the online instruction module, if desired. *)
    1   Call clear(term)
        Write (*,10)
   10   Format (///5x,'Do you need instructions? (Y/N)...')
        Read (*,'(a1)',err=1) ans
        IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') Call Online(term)

*       (* Initialize done to false. *)
        done = .FALSE.

  100   IF (.NOT.(done)) THEN
*         (* Get the data points for plotting. *)
          Call DataIn(X, Y, Numpt, NumCrv, term)

*         (* Call the plotting menu. *)
          Call Menu(X, Y, Numpt, NumCrv, term, done)

          GOTO 100
        ENDIF

*       (* clears the terminal. *)
        Call clear(term)

        Write (*,30)
   30   Format (///15x,'Thank you for using XYplotter!'//)

        STOP
        END
