/*                                                                          */
/*                         Copyright (C) 1986 by                            */
/*             Digital Equipment Corporation, Maynard, Mass.                */
/*                                                                          */
/*   This software is furnished under a license and may be used and  copied */
/*   only  in  accordance  with  the  terms  of  such  license and with the */
/*   inclusion of the above copyright notice.  This software or  any  other */
/*   copies  thereof may not be provided or otherwise made available to any */
/*   other person.  No title to and ownership of  the  software  is  hereby */
/*   transferred.                                                           */
/*                                                                          */
/*   The information in this software is subject to change  without  notice */
/*   and  should  not  be  construed  as  a commitment by Digital Equipment */
/*   Corporation.                                                           */
/*                                                                          */
/*   Digital assumes no responsibility for the use or  reliability  of  its */
/*   software on equipment which is not supplied by Digital.                */
/*                                                                          */
/*   Facility:		VAX GKS                                             */
/*                                                                          */
/*   Abstract:		This file contains declarations and for the         */
/*			corresponding VAX language for use by programmers   */
/*			who wish to use GKS.                                */
/*                                                                          */
/*   Environment:	VMS                                                 */
/*                                                                          */
 
/*** MODULE gksdefs ***/
/* Input Mode Types                                                         */
#define GKS$K_INPUT_MODE_REQUEST 0      /* Request mode                     */
#define GKS$K_INPUT_MODE_SAMPLE 1       /* Sample mode                      */
#define GKS$K_INPUT_MODE_EVENT 2        /* Event mode                       */
/* Echo States                                                              */
#define GKS$K_NOECHO 0                  /* Echo disabled                    */
#define GKS$K_ECHO 1                    /* Echo enabled                     */
/* Input Status Types                                                       */
#define GKS$K_STATUS_NONE 0             /* no input obtained                */
#define GKS$K_STATUS_OK 1               /* input obtained                   */
#define GKS$K_STATUS_NOCHOICE 2         /* no choice input                  */
#define GKS$K_STATUS_NOPICK 2
/* GKS Status Types                                                         */
#define GKS$K_GKCL 0                    /* GKS closed                       */
#define GKS$K_GKOP 1                    /* GKS open                         */
#define GKS$K_WSOP 2                    /* at least one workstation open    */
#define GKS$K_WSAC 3                    /* at least one workstation active  */
#define GKS$K_SGOP 4                    /* at least one segment open        */
/* GKS Level Types                                                          */
#define GKS$K_LEVEL_MA -3               /* level ma                         */
#define GKS$K_LEVEL_MB -2               /* level mb                         */
#define GKS$K_LEVEL_MC -1               /* level mc                         */
#define GKS$K_LEVEL_0A 0                /* level 0a                         */
#define GKS$K_LEVEL_0B 1                /* level 0b                         */
#define GKS$K_LEVEL_0C 2                /* level 0c                         */
#define GKS$K_LEVEL_1A 3                /* level 1a                         */
#define GKS$K_LEVEL_1B 4                /* level 1b                         */
#define GKS$K_LEVEL_1C 5                /* level 1c                         */
#define GKS$K_LEVEL_2A 6                /* level 2a                         */
#define GKS$K_LEVEL_2B 7                /* level 2b                         */
#define GKS$K_LEVEL_2C 8                /* level 2c                         */
/* Text Paths Types                                                         */
#define GKS$K_TEXT_PATH_RIGHT 0         /* path right                       */
#define GKS$K_TEXT_PATH_LEFT 1          /* path left                        */
#define GKS$K_TEXT_PATH_UP 2            /* path up                          */
#define GKS$K_TEXT_PATH_DOWN 3          /* path down                        */
/* Text Horizontal Alignment Types                                          */
#define GKS$K_TEXT_HALIGN_NORMAL 0      /* horizontal align normal          */
#define GKS$K_TEXT_HALIGN_LEFT 1        /* horizontal align left            */
#define GKS$K_TEXT_HALIGN_CENTER 2      /* horizontal align center          */
#define GKS$K_TEXT_HALIGN_RIGHT 3       /* horizontal align right           */
/* Text Vertical Alignments Types                                           */
#define GKS$K_TEXT_VALIGN_NORMAL 0      /* vertical align normal            */
#define GKS$K_TEXT_VALIGN_TOP 1         /* vertical align left              */
#define GKS$K_TEXT_VALIGN_CAP 2         /* vertical align cap               */
#define GKS$K_TEXT_VALIGN_HALF 3        /* vertical align half              */
#define GKS$K_TEXT_VALIGN_BASE 4        /* vertical align base              */
#define GKS$K_TEXT_VALIGN_BOTTOM 5      /* vertical align bottom            */
/* Standard Line Types                                                      */
#define GKS$K_LINETYPE_SOLID 1          /* linetype solid                   */
#define GKS$K_LINETYPE_DASHED 2         /* linetype dashed                  */
#define GKS$K_LINETYPE_DOTTED 3         /* linetype dotted                  */
#define GKS$K_LINETYPE_DASHED_DOTTED 4  /* linetype dashed-dotted           */
/* Standard Marker Types                                                    */
#define GKS$K_MARKERTYPE_DOT 1          /* markertype dot                   */
#define GKS$K_MARKERTYPE_PLUS 2         /* markertype plus                  */
#define GKS$K_MARKERTYPE_ASTERISK 3     /* markertype asterisk              */
#define GKS$K_MARKERTYPE_CIRCLE 4       /* markertype circle                */
#define GKS$K_MARKERTYPE_DIAGONAL_CROSS 5 /* markertype diagonal cross      */
/* Text Precision Types                                                     */
#define GKS$K_TEXT_PRECISION_STRING 0   /* text precision string            */
#define GKS$K_TEXT_PRECISION_CHAR 1     /* text precision character         */
#define GKS$K_TEXT_PRECISION_STROKE 2   /* text precision stroke            */
/* Fill Area Types                                                          */
#define GKS$K_INTSTYLE_HOLLOW 0         /* interior style hollow            */
#define GKS$K_INTSTYLE_SOLID 1          /* interior style solid             */
#define GKS$K_INTSTYLE_PATTERN 2        /* interior style pattern           */
#define GKS$K_INTSTYLE_HATCH 3          /* interior style hatch             */
/* Attribute Source States                                                  */
#define GKS$K_ASF_BUNDLED 0             /* aspect bundled                   */
#define GKS$K_ASF_INDIVIDUAL 1          /* aspect individual                */
/* Clear Screen States                                                      */
#define GKS$K_CLEAR_CONDITIONALLY 0     /* clear conditionally              */
#define GKS$K_CLEAR_ALWAYS 1            /* clear always                     */
/* Clipping States                                                          */
#define GKS$K_NOCLIP 0                  /* no clipping                      */
#define GKS$K_CLIP 1                    /* clipping                         */
/* Workstation Types                                                        */
#define GKS$K_WSTYPE_DEFAULT 0          /* default workstation              */
#define GKS$K_GKSM_OUTPUT 2             /* GKS output metafile              */
#define GKS$K_GKSM_INPUT 3              /* GKS input metafile               */
#define GKS$K_WSTYPE_WISS 5             /* Work Station Independent Storage */
#define GKS$K_VT_OUTPUT 10              /* DIGITAL VT125 OUTPUT             */
#define GKS$K_VT125 11                  /* DIGITAL VT125 color              */
#define GKS$K_VT125BW 12                /* DIGITAL VT125 b&w                */
#define GKS$K_VT240 13                  /* DIGITAL VT240 color              */
#define GKS$K_VT240BW 14                /* DIGITAL VT240 b&w                */
#define GKS$K_LCP01 15                  /* DIGITAL LCP01 printer            */
#define GKS$K_LA12 33                   /* LA12 printer                     */
#define GKS$K_LA34 31                   /* LA34 printer w/graphics          */
#define GKS$K_LA50 32                   /* LA50 printer                     */
#define GKS$K_LA100 31                  /* LA100 printer                    */
#define GKS$K_LA210 34                  /* LA210 printer                    */
#define GKS$K_LN03_PLUS 38              /* LN03 Plus printer                */
#define GKS$K_VSI 41                    /* DIGITAL uVAX I                   */
#define GKS$K_VSII 41                   /* DIGITAL uVAX II                  */
#define GKS$K_VSII_GPX 41               /* DIGITAL uVAX II/GPX              */
#define GKS$K_LVP16A 51                 /* DIGITAL LVP16                    */
#define GKS$K_LVP16B 52                 /* DIGITAL LVP16                    */
#define GKS$K_HP7550 53                 /* DIGITAL HP7550's                 */
#define GKS$K_HP7580 54                 /* DIGITAL HP7580's                 */
#define GKS$K_LG_MPS2000 55             /* DIGITAL Laser Graphics           */
#define GKS$K_HP7585 56                 /* DIGITAL HP7580's                 */
#define GKS$K_POSTSCRIPT 61             /* DIGITAL PS200                    */
#define GKS$K_TEK4014_OUTPUT 70         /* Tek 4014 Output Only             */
#define GKS$K_TEK4014 72                /* Tektronix 4014                   */
/* Input Device Types                                                       */
#define GKS$K_INPUT_DEV_DEFAULT 0       /* default input device             */
/* Connection Identifier                                                    */
#define GKS$K_CONID_DEFAULT 0           /* default connection id            */
/* Workstation states                                                       */
#define GKS$K_WS_INACTIVE 0             /* work station active              */
#define GKS$K_WS_ACTIVE 1               /* work station inactive            */
/* Deferral State Types                                                     */
#define GKS$K_ASAP 0                    /* as soon as possible              */
#define GKS$K_BNIG 1                    /* before next global interactin    */
#define GKS$K_BNIL 2                    /* before next interaction          */
#define GKS$K_ASTI 3                    /* at some time                     */
/* Implicit Regeneration States                                             */
#define GKS$K_IRG_SUPPRESSED 0          /* implicit regeneration suppressed */
#define GKS$K_IRG_ALLOWED 1             /* implicit regeneration allowed    */
/* Regeneration Flag States                                                 */
#define GKS$K_POSTPONE_FLAG 0           /* regeneration flag suppress       */
#define GKS$K_PERFORM_FLAG 1            /* regeneration flag perform        */
/* New Frame Action States                                                  */
#define GKS$K_NEWFRAME_NOTNECESSARY 0   /* new frame action not necessary on update */
#define GKS$K_NEWFRAME_NECESSARY 1      /* new frame necessary on update    */
/* Action Pending States                                                    */
#define GKS$K_NOTPENDING 0              /* not pending                      */
#define GKS$K_PENDING 1                 /* pending                          */
/* Color Representaion States                                               */
#define GKS$K_VALUE_SET 0               /* returned value is set            */
#define GKS$K_VALUE_REALIZED 1          /* returned value is realized       */
/* Workstation Category Types                                               */
#define GKS$K_WSCAT_OUTPUT 0            /* output workstation               */
#define GKS$K_WSCAT_INPUT 1             /* input workstation                */
#define GKS$K_WSCAT_OUTIN 2             /* output/input workstation         */
#define GKS$K_WSCAT_WISS 3              /* workstation independent segment storage */
#define GKS$K_WSCAT_MO 4                /* metafile output                  */
#define GKS$K_WSCAT_MI 5                /* metafile input                   */
/* Workstation Class Types                                                  */
#define GKS$K_WSCLASS_VECTOR 0          /* vector workstation               */
#define GKS$K_WSCLASS_RASTER 1          /* raster workstation               */
#define GKS$K_WSCLASS_OTHERD 2          /* other device                     */
/* Device Coordinates States                                                */
#define GKS$K_METERS 0                  /* meters                           */
#define GKS$K_OTHER_UNITS 1             /* other units                      */
/* Workstation Color States                                                 */
#define GKS$K_MONOCHROME 0              /* monochrome display               */
#define GKS$K_COLOR 1                   /* color display                    */
/* Valid Value States                                                       */
#define GKS$K_INVALID_ABSENT 0          /* invalid values absent            */
#define GKS$K_INVALID_PRESENT 1         /* invalid values present           */
/* Display Surface States                                                   */
#define GKS$K_NOTEMPTY 0                /* display surface not empty        */
#define GKS$K_EMPTY 1                   /* display surface empty            */
/* Input Priority States                                                    */
#define GKS$K_INPUT_PRIORITY_HIGHER 0   /* relative input priority higher   */
#define GKS$K_INPUT_PRIORITY_LOWER 1    /* relative input priority lower    */
/* Attribute Control Function Types                                         */
#define GKS$K_ACF_CURRENT 0             /* attribute control value          */
#define GKS$K_ACF_SPECIFIED 1           /* attribute control flag current   */
#define GKS$K_ACF_POLYLINE 0            /* attribute control flag fill polyline */
#define GKS$K_ACF_FILL_AREA 1           /* attribute control flag fill area */
/* GDP Bundle Types                                                         */
#define GKS$K_POLYLN_ATTRI 0            /* GDP polyline bundle              */
#define GKS$K_POLYMR_ATTRI 1            /* GDP polymarker bundled           */
#define GKS$K_TEXT_ATTRI 2              /* GDP text bundle                  */
#define GKS$K_FILLAR_ATTRI 3            /* GDP fill area bundle             */
/* Choice Prompt Input Type                                                 */
#define GKS$K_CHOICE_PROMPT_OFF 0       /* choice data record prompt off    */
#define GKS$K_CHOICE_PROMPT_ON 1        /* choice data record prompt on     */
/* ASF masks                                                                */
#define GKS$M_LINETYPE 1                /* Line type                        */
#define GKS$M_LINEWIDTH 2               /* Line width                       */
#define GKS$M_PLINE_COLOR 4             /* Polyline Color                   */
#define GKS$M_MARKERTYPE 8              /* Marker type                      */
#define GKS$M_MARKERSIZE 16             /* Marker size                      */
#define GKS$M_PMARK_COLOR 32            /* Polymarker                       */
#define GKS$M_TEXT_FONT_PREC 64         /* Text precision                   */
#define GKS$M_CHAR_EXPAN_FAC 128        /* Expansion factor                 */
#define GKS$M_CHAR_SPACE 256            /* Character spacing                */
#define GKS$M_TEXT_COLOR 512            /* Text color                       */
#define GKS$M_FILL_INTER_STYLE 1024     /* Interior Style                   */
#define GKS$M_FILL_STYLE 2048           /* Fill style                       */
#define GKS$M_FILL_COLOR 4096           /* Fill color                       */
#define GKS$M_SIMULATION 1073741824     /* Simulation                       */
/* USA paper sizes                                                          */
#define GKS$M_PAPERSIZE_A 0             /* 8.5" x 11"                       */
#define GKS$M_PAPERSIZE_LEGAL 65536     /* 8.5" x 14"                       */
#define GKS$M_PAPERSIZE_B 131072        /* 11" x 17"                        */
#define GKS$M_PAPERSIZE_C 196608        /* 17" x 22"                        */
#define GKS$M_PAPERSIZE_D 262144        /* 22" x 34"                        */
#define GKS$M_PAPERSIZE_E 327680        /* 34" x 44"                        */
/* Metric paper sizes                                                       */
#define GKS$M_PAPERSIZE_A0 1048576      /*                                  */
#define GKS$M_PAPERSIZE_A1 2097152      /*                                  */
#define GKS$M_PAPERSIZE_A2 3145728      /*                                  */
#define GKS$M_PAPERSIZE_A3 4194304      /* 29.7 x 42.0                      */
#define GKS$M_PAPERSIZE_A4 5242880      /* 21.0 x 29.7                      */
#define GKS$M_PAPERSIZE_A5 6291456      /* 14.8 x 21.0                      */
#define GKS$M_PAPERSIZE_B4 7340032      /* 25.7 x 36.4                      */
#define GKS$M_PAPERSIZE_B5 8388608      /* 18.2 x 25.7                      */
/* Page formats                                                             */
#define GKS$M_PORTRAIT 268435456
#define GKS$M_LANDSCAPE 0
/* Color Map                                                                */
#define GKS$M_COLOR_MAP_PHYSICAL 16777216
#define GKS$M_COLOR_MAP_VIRTUAL 0
/* Logical Types	                                                    */
#define GKS$K_FALSE 0                   /* Logical FALSE                    */
#define GKS$K_TRUE 1                    /* Logical TRUE                     */
/* Visibility                                                               */
#define GKS$K_INVISIBLE 0               /* Invisible                        */
#define GKS$K_VISIBLE 1                 /* Visible                          */
/* Detectability                                                            */
#define GKS$K_UNDETECTABLE 0            /* Undetectable                     */
#define GKS$K_DETECTABLE 1              /* Detectable                       */
/* Highlighting                                                             */
#define GKS$K_NORMAL 0                  /* Unhighlighted                    */
#define GKS$K_HIGHLIGHTED 1             /* Highlighted                      */
/* Input Class                                                              */
#define GKS$K_INPUT_CLASS_NONE 0        /* None	                            */
#define GKS$K_INPUT_CLASS_LOCATOR 1     /* Locator                          */
#define GKS$K_INPUT_CLASS_STROKE 2      /* Stroke                           */
#define GKS$K_INPUT_CLASS_VALUATOR 3    /* Valuator                         */
#define GKS$K_INPUT_CLASS_CHOICE 4      /* Choice                           */
#define GKS$K_INPUT_CLASS_PICK 5        /* Pick                             */
#define GKS$K_INPUT_CLASS_STRING 6      /* String                           */
/* Simultaneous Events Flag                                                 */
#define GKS$K_NOMORE_EVENTS 0           /* Nomore                           */
#define GKS$K_MORE_EVENTS 1             /* More                             */
/* Coordinate Switch                                                        */
#define GKS$K_COORDINATES_WC 0          /* World Coordinates                */
#define GKS$K_COORDINATES_NDC 1         /* NDC                              */
/* Dynamic modification                                                     */
#define GKS$K_IRG 0                     /* Implicit Regeneration            */
#define GKS$K_IMM 1                     /* Immediate                        */
/* Input on device handler                                                  */
#define GKS$K_CURSOR_MOVEMENT 1         /*                                  */
#define GKS$K_CHARACTER 2               /*                                  */
#define GKS$K_POINT_TRIGGER 3           /*                                  */
#define GKS$K_TERMINATION_TRIGGER 4     /*                                  */
#define GKS$K_DELETE 5                  /*                                  */
#define GKS$K_BREAK 6                   /*                                  */
/* Input on device handler                                                  */
#define GKS$K_RELATIVE 0                /*                                  */
#define GKS$K_ABSOLUTE 1                /*                                  */
/* Input on device handler                                                  */
#define GKS$K_START_INPUT 1             /*                                  */
#define GKS$K_GET_INPUT 2               /*                                  */
#define GKS$K_STOP_INPUT 3              /*                                  */
