//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 27th September, 2014
//
//
package worker4math.hktex2;

import java.util.HashMap;

public class Header {

	public static final int topsidemargin=30;
	public static final int bottomsidemargin=30;
	public static final int leftsidemargin = 30;
	public static final int rightsidemargin = 30;
	public static final int linegap=5;
	public static final int columngap = 2;
	public static final int characterheadroom = 2;
	public static final int firstpage = 1;
	public static final int defaultfont = 0;
	public static final int minfontsize = 8;
	public static final int maxfontsize = 80;
	public static final int indent = 40;
	public static final int fontsize = 12;  // value between maxfontsize and minfontsize;
	public static final float bigopsize = 2.0f;  // size factor for big operator
	public static final float bigbigopsize=3.0f;  // size factor for big big operator
	public static final float firstypos=20;
	public static final Boolean dohyphenation=false;
	public static final Boolean scrollview=false;
	public static final Boolean showpagenumber=true;
	public static final Boolean phone_orientation_portrait=true;
	public static final Boolean tablet_orientation_landscape=false;
	public static final int twocolumns_criteria=700;  
	public static final String defaultattribute="00120000xff00000000+0.000xFF0000xFF000000"; // char(1) to char(3) is the font size
	
	public static final String defaultcolor="black";
	public static final HashMap<String, Float> sizefactor = new HashMap<String,Float>();
//
// The following will be changed after launched
//	
	public static Boolean phone_twocolumns=false;   // if container width < twocolumns_criteria, this Boolean will be changed to false;
	public static Boolean tablet_twocolumns=false;  // if container width < twocolumns_criteria, this Boolean will be changed to false;
	public static HashMap<Long,Integer> threadid = new HashMap<Long,Integer>();	
	public static int nthread=10;   // min is 1, max is 10
	public static Boolean tablet=true;
	
	public void header(){
    	sizefactor.put("Huge",2.0f);
    	sizefactor.put("huge",1.75f);
    	sizefactor.put("Large",1.5f);
    	sizefactor.put("large",1.25f);
    	sizefactor.put("normalsize",1.0f);
    	sizefactor.put("small",0.75f);
    	sizefactor.put("scriptsize",0.6f);
    	sizefactor.put("tiny",0.5f);
	}
}
