/*---------------------------------------------
                 S I M P A C K
            Simulation Tool Package
        Copyright 1990, Paul A. Fishwick
---------------------------------------------*/


#include <stdlib.h>
#include <stream.h>
#include "../../queuing/queuing.h"
#include "network.h"

Network_Node::Network_Node():Facility(0,1){};

class Message message[MESSAGES ];  
class Network_Node node[NODES + 2 ];
int num_nodes, event,message_id;            //num_nodes means the number of nodes in the network 
int length, transceiver[TRANSCEIVERS][3];   //node_number means the index of the array
                                            // for a specific node 
int trans_count,facility_id, node_number=0;
int messages_routed,message_ptr[MESSAGES];
int token,num_transceivers,num_messages;
float graph[NODES][NODES],node_time;
Token  a_token;
Events events;



Message::Message()
    {
	length =0;
	message_tr =0;
	for( int i=0; i<MAX_MSG_LENGTH; i++)
		message_routing[i] = 0;
    }



Model::Model(){}



void Model::proc_event(int event, int message_id)

{
    int i,j,trans_num,row,col;
    float link_time;


    i = message_id;
      
    switch (event) {

    case LINK: /* message traveling along a link */
     /* determine which transceiver is being requested */
     for (j=0;j<num_transceivers;j++)
      if ((message_ptr[i] < (message[i].length -1)) &&
         (message[i].message_routing[message_ptr[i]] == transceiver[j][0]) &&
         (message[i].message_routing[message_ptr[i]+1] == transceiver[j][1]))
       trans_num = j;
     row = transceiver[trans_num][0];
     col = transceiver[trans_num][1];
     link_time = graph[row][col];
     a_token.attr[0] = (float) i;
     events.schedule(REQUEST,link_time,a_token);
     break; 
  
    case REQUEST: /* message requesting a facility */
     /* determine which transceiver is being requested -
        then obtain facility or queue for it */
     for (j=0;j<num_transceivers;j++)
     if ((message_ptr[i] < (message[i].length -1)) &&
         (message[i].message_routing[message_ptr[i]] == transceiver[j][0]) &&
         (message[i].message_routing[message_ptr[i]+1] == transceiver[j][1]))
       trans_num = j;
     if(message_ptr[i] < (message[i].length -1)) {
       a_token.attr[0] = (float) i;
       if (node[transceiver[trans_num][2]].request(a_token,0) == FREE) {
          /* total_time = graph[transceiver[trans_num][0],
                                transceiver[trans_num][1]] + 1.0; */
           message[i].message_tr = trans_num;
           a_token.attr[0] = (float) i;
           events.schedule(RELEASE,node_time,a_token);
       } /* end if */
     } /* end if */
     break;

    case RELEASE:  /* message releasing a facility */
     /* release a facility. first find out which transceiver
        has this message token  */
       j = message[i].message_tr;
       a_token.attr[0] = (float) i;
       node[transceiver[j][2]].release(a_token);
       /* update the message pointer */
       if(message_ptr[i] < ((message[i].length )-2)) {
          message_ptr[i] += 1;
          a_token.attr[0] = (float) i;
          events.schedule(LINK,0.0,a_token);
       }
       else
          messages_routed++;

       break;
    } /* end switch */
} /* end check_transition() */ 

void Model::report_nodes()
{ 
  int trans_count,i,j,transceivers_in_node;
  float node_busy_time[NODES],utilization,avg_busy_time;
 
  cout << endl;
  cout <<"----------------" << endl;
  cout <<"NODE Utilization" << endl;
  cout <<"----------------" << endl << endl;
  /* loop through all transceivers to obtain node statistics */
  trans_count=0;
  for(i=0;i<num_nodes;i++)
    node_busy_time[i] = 0.0;
  for(i=0;i<num_nodes;i++) {
    transceivers_in_node = 0;
    for (j=0;j<num_nodes;j++)
      if (graph[i][j] != 0.0) {
        node_busy_time[i] += node[transceiver[trans_count][2]].busy_time;
        trans_count++;
        transceivers_in_node++;
      } /* end if */
  } /* end for */
  for(i=0;i<num_nodes;i++) {
    avg_busy_time = node_busy_time[i]/(float) transceivers_in_node;
    utilization = 100.0 * avg_busy_time/time();
    cout << "Node " << i << " Utilization is "<< utilization <<  "%" << endl;
  } /* end for */
} /* end report_nodes() */






int Model::create_facility(int num_servers)
{ int i;

  node[node_number].status = FREE;
  node[node_number].total_servers = num_servers;
  node[node_number].busy_servers = 0;

  /* clear servers */
  for (i=1;i<=num_servers;i++) {
   node[node_number].server_info[i][0] = 0;
   node[node_number].server_info[i][1] = 0;
  } /* end for */

  node[node_number].preemptions = 0;
  node[node_number].busy_time = 0.0;

  node_number++;
  return(node_number-1);
} /* end facility() */



void Model::report_network_stats()
{
  int i;
  float utilization,idle,arrival_rate,throughput,total_sim_time;
  float total_busy_time;
  float total_utilization;
  float mean_service_time,mean_num_tokens,mean_residence_time;

  printf("this sighghjsadjkkk\n");
  cout << endl;
  cout << "+---------------------------+" << endl;
  cout << "| SimPack SIMULATION REPORT |" <<endl;
  cout << "+---------------------------+" <<endl;
  cout << endl;

  if (completions == 0) completions = 1;
  total_sim_time = time();
  total_busy_time = 0.0;
  for(i=0;i<node_number;i++) {
        /* update busy time if simulation ends when there is a busy facility */
    if(node[i].busy_servers > 0) 
      node[i].busy_time  =  node[i].busy_time + time() - 
      node[i].start_busy_time;
    total_busy_time += node[i].busy_time;
  }
  total_busy_time /= node_number;
  total_utilization = total_busy_time/total_sim_time;
  arrival_rate = (float) arrivals/total_sim_time;
  throughput = (float) completions/total_sim_time;
  mean_service_time = total_busy_time/completions;
  mean_num_tokens = total_token_time/total_sim_time;
  mean_residence_time = mean_num_tokens/throughput;

  cout << "Total Simulation Time: " << total_sim_time << endl;
  cout << "Total System Arrivals: " << arrivals << endl;
  cout << "Total System Completions: " << completions;
  cout << endl;
  cout << "System Wide Statistics" << endl;
  cout << "----------------------" << endl;
  cout << "System Utilization: " << 100.0*total_utilization << endl;
  cout << "Arrival Rate: " <<  arrival_rate  << " Throughput: "<< throughput <<endl;;
  cout << "Mean Service Time per Token: " << mean_service_time << endl;
  cout << "Mean # of Tokens in System: " << mean_num_tokens << endl;
  cout << "Mean Residence Time for each Token: " <<mean_residence_time << endl;
  cout << endl;

  cout << "Facility Statistics" << endl;
  cout << "-------------------" << endl;;
  for (i=0;i<node_number;i++) {
    utilization = 100.0 * node[i].busy_time/current_time;
    idle = 100.0 * (current_time - node[i].busy_time)/current_time;
    cout << "F " << i+1 << " (tr) " << ": Idle: "<< idle << "% Util: ";
    cout <<utilization << "% Preemptions: " <<node[i].preemptions<< endl; 
   }
}








void Model::simulate()
{
  int i,j;

  init_simpack(LINKED);
  /* read in the network topology and messages
     to be routed */
  cin >> num_nodes;
  cin >> node_time;
  for (i=0;i<num_nodes;i++) 
    for (j=0;j<num_nodes;j++)
	cin >> graph[i][j];

  cin >> num_messages;
  for (i=0;i<num_messages;i++) {
    cin >> length;
    message[i].length  = length;
    for (j=0;j< message[i].length; j++)
      cin >> message[i].message_routing[j];
  } /* end for */

  /* specify all transceivers as facilities */
  trans_count=0;
  for(i=0;i<num_nodes;i++)
    for (j=0;j<num_nodes;j++)
      if (graph[i][j] != 0.0) {
        transceiver[trans_count][0] = i;
        transceiver[trans_count][1] = j;
        facility_id = create_facility( 1);
        transceiver[trans_count][2] = facility_id;
        trans_count++;
      } /* end if */
  num_transceivers = trans_count;
   
  /* Each message is represented by a token.
     For each message, reset the pointer inside message path */
  for (i=0;i<num_messages;i++) {
    message_ptr[i] = 0;
    a_token.attr[0] = (float) i;
    events.schedule(LINK,0.0,a_token);
  }
  messages_routed = 0;
  while (messages_routed < num_messages) {
    events.next_event(event, a_token);
    message_id = (int) a_token.attr[0];
    proc_event(event,message_id);
  } /* end while */
  report_network_stats();
  report_nodes();
}


main()
{
   class Model M;
   M.simulate();
} /* end main() */







