//---------------------------------------------
//               S I M P A C K + +
//            Simulation Tool Package
//        Copyright 1992, Paul A. Fishwick
//---------------------------------------------

#include "diff.h"

int event;
//int queue_id;
float delta_time;
Token customer;
Differential eqn;
Facility server(1,1);

main()
 { 
  init_simpack(HEAP);
//  queue_id = create_facility("cashier",1);
  customer.id = 1;
  event_list.schedule(ARRIVAL,0.0,customer);
  while (customer.id <= 30.0)   {
      event_list.next_event(event,customer);
      switch(event) {

      //-----------------------------------
      // discrete event models             
      //-----------------------------------
      case ARRIVAL: 
         update_arrivals();
         event_list.schedule(PLACE_ITEMS,0.0,customer);
         customer.id += 1;
         event_list.schedule(ARRIVAL,expntl(90.0),customer);
         break;
      case PLACE_ITEMS:
         event_list.schedule(REQUEST_SERVER,uniform(20.0,30.0),customer);
         break;
      case REQUEST_SERVER: 
         if (server.request(customer,0) == FREE) {
           eqn.init_conditions();
           event_list.schedule(BELT_MOVING,4.0,customer);
         }
         break;
      case PACKING:  // release server 
         server.release(customer);
         update_completions();
         break;

      //--------------------------
      // continuous model         
      //--------------------------
       case BELT_MOVING:
         eqn.state();
         eqn.integrate();
         if (eqn.state_event()) 
           event_list.schedule(PACKING,normal(120.0,15.0),customer);
         else
           event_list.schedule(BELT_MOVING,delta_time,customer);
         break;
       } // end switch 
    } // end while 
  report_stats();
} // end main() 

// *********************************************
// state_event
// *********************************************
int Differential::state_event()
// state event transition 
{
  if (eqn.out[1] >= 3.0)
    return (TRUE);
  else
    return (FALSE);
}

// **********************************************
// initial conditions
// **********************************************
void Differential::init_conditions()
{
  eqn.out[1] = 0.0;
  delta_time = 0.1;
}

// ***********************************************
// state
// ***********************************************
void Differential::state()
{ 
// Calculate state: x' = 2 
 eqn.in[1] = 2.0;
}
 
void Differential::integrate()
{
 int i;
 eqn.out[1] += eqn.in[1]*delta_time;
}
 



