/****************************************\
*                                        *
*	        mktrans.c                *
*				         *
*      cellular automaton simulator      *
*                                        *
*  	generates transition files       *
*                                        *
*                                        *
\****************************************/


/* August 29, 1988 */

#include <stdio.h>

#define UNDEF	'\377'			/* undefined character         */
#define ASCZ    '0'			/* ASCII zero                  */
#define TRUE     1
#define FALSE    0
#define add_index(k)	index <<= L;  index |= k

/***********************************************************************\
*                                                                       *
* To adapt this file for generating your own transition function:       *
*   1.	Change the constants below as appropriate.                      *
*   2.	Insert the desired function inside the for loops.               *
*   3.	Depending on which neighborhood you are using, change the       *
* 	order of for-loops and indices as follows (tl = top-left,       *
* 	ll = left-of-left, etc.):                                       *
* 		VonN:	l, c, r, t, b                                   *
* 		Moore:	tl, l, bl, t, c, b, tr, r, br                   *
* 		linear,	r=1:	l, c, r                                 *
* 			r=2:	ll, l, c, r, rr                         *
* 			r=3:	lll, ll, l, c, r, rr, rrr               *
*                                                                       *
\***********************************************************************/

#define	S	8			/* number of states/cell       */
#define	L	3			/* log S	       	       */
#define	N	5			/* number of neighbors: von N  */
#define TSIZE	32768			/* size of t-table:  S ^ N     */
#define NAME    "temp.v8"		/* output file name            */



main()
{
    int     l, c, r, t, b, next, index;
    char    ta[TSIZE];			/* t-table array       */
    FILE   *fopen(), *fp;


    /* main code begins */

    for (l = 0; l < S; l++)
	for (c = 0; c < S; c++)
	    for (r = 0; r < S; r++)
		for (t = 0; t < S; t++)
		    for (b = 0; b < S; b++) {

			index = 0;
			add_index(l);
			add_index(c);
			add_index(r);
			add_index(t);
			add_index(b);


			/* l, c, r, t, b = left, center, right, top, bottom */
			/* now define next as a function of these, e.g.     */

			next = (c + r + l + t + b) % 8;

			/* gives modulo 8 addition.                         */
			

			ta[index] = next;

		    }


    fp = fopen(NAME, "w");
    fwrite(ta, sizeof(*ta), TSIZE, fp);
    fclose(fp);

} /* main */
