/*
 * File: cycle.M256.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       September 1989
 *
 * A rule based on A.K. Dewdney's "Computer Recreations" article
 * in the August 1989 scientific american
 *
 * "parm1" says how many states to use.
 * Start with a random configuration of cells with values between
 * 0 and parm-1.  For example, with 16 states, start with a random
 * array of values between 0 and 15 inclusive (use the "general"
 * random array generator to do this).
 *
 * Try varying parm1 slightly.  On a 64x64 array, there is a
 * threshold between 16 and 19; above the threshold, the array
 * will generally "freeze", either with most of the randomness left,
 * or with most of the cells in one state.  Below the threshold, the
 * array will usually become periodic, with waves propagating out
 * from one or more sources.
 */



#include "nborhood.h"

byte cycle();

void
init_function()
{
    update_function = cycle;
    parm1 = 16;
}

byte
cycle(nbors)
margolus_nbors *nbors;
{
    int tmp;

    Get_margolus_nbors;
    tmp = (c + 1) % parm1;
    if ((tmp == cw) || (tmp == opp) || (tmp == ccw))
	return tmp;
    else
	return c;
}
