/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "style.h"

#ifdef MPWC
#define MACINTOSH
#endif

#ifdef THINK_C
#define MACINTOSH
#endif

/*
 *  The location of the following two files is installation dependent.
 */

char *helpFile = "Macaulay.help" ;
char *newFile  = "Macaulay.new" ;

extern int timer ;
long startTime ;	

/*------------------------------------------------------
 *
 *	interrupt, timer and fontsize code for Macintosh
 *
 *------------------------------------------------------*/
#ifdef MACINTOSH

#ifdef MPWC
#include <Types.h>
#include <Events.h>
#endif

#ifdef MPW3
#include <OSEvents.h>
#else
pascal long TickCount() ;
#endif

#ifdef THINK_C
/* The following for Lightspeed C is hacked in. You break it, you fix it. */
typedef struct 
	{
	int	v,h;
	} Point ;
typedef int (*ProcPtr)() ;
#define _MacTypes_
#include <EventMgr.h>
#endif

spec_init()
{
}

intr_shell()
{
    struct EventRecord myEvent ;

    if (GetNextEvent(mDownMask, &myEvent) != 0) {
		print("\n") ;
		shell() ;
		rmmouse() ;
    }
}

boolean
have_intr()
{
    struct EventRecord myEvent ;

    if (GetNextEvent(mDownMask, &myEvent) != 0) {
		rmmouse() ;
		return(TRUE) ;
    }
    return(FALSE) ;
}

rmmouse()
{
    /*struct EventRecord myEvent ;*/

    FlushEvents(mDownMask, 0) ;
    /*while (GetNextEvent(mDownMask, &myEvent) != 0) ;*/
}
#endif

#ifdef SUN
#define MOUSE SIGINT

#include <signal.h>
/*(*signal())() ;*/
int intFlag ;	/* set to 1 if an interrupt is given */

handle()
{
	intFlag = 1 ;
	signal(MOUSE, handle) ;
}

spec_init()
{
    intFlag = 0 ;
    signal(MOUSE, handle) ;
}

intr_shell()
{
    if (intFlag == 1) {
		intFlag = 0 ;
		print("\n") ;
		shell() ;
		intFlag = 0 ;
    }
}

boolean
have_intr()
{
    if (intFlag == 1) {
	rmmouse() ;
	return(TRUE) ;
    }
    return(FALSE) ;
}

rmmouse()
{
    intFlag = 0 ;
}

prsetup() {}

#endif

setTextSize(n)
int n ;
{
#ifdef ANSI
 #pragma unused(n)
#endif
}

#ifdef SUN
#define UNIX_TIMER
#define TICK 60
#endif

#ifdef RIDGE
#define UNIX_TIMER
#define TICK 1000
#endif

#ifdef UNIX_TIMER
#include <sys/types.h>
#include <sys/times.h>

static struct tms time_buf ;

markTime()
{
    times(&time_buf) ;
    startTime = time_buf.tms_utime + time_buf.tms_stime ;
}

long
nSeconds()
{
    times(&time_buf) ;
    return((time_buf.tms_utime + time_buf.tms_stime - startTime)/TICK) ;
}
#endif

#ifdef MACINTOSH
markTime()
{
    startTime = TickCount() ;
}

long
nSeconds()
{
    long n ;

    n = TickCount() - startTime ;
    return(n / 60) ;
}
#endif

/*------------------------------------------------------
 *
 *	timer routine (machine indep.)
 *
 *------------------------------------------------------*/

prTime(str)
char *str ;
{
	long tot, s, m ;

	if (timer <= 0) return ;
	tot = nSeconds() ;
	if (tot == 0) return ;
	s = tot % 60 ;
	m = tot / 60 ;
	newline() ;
	print("%s ",str) ;
	if (m > 1) 
		print("%ld minutes and " , m) ;
	else if (m == 1)
		print("1 minute and ") ;
	if (s != 1)
		print("%ld seconds\n", s) ;
	else 
		print("1 second\n") ;
}

#ifdef MACINTOSH
prsetup()
{
}
#endif
