/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "hull.h"

vector *
new_vector(len)
int len;
/* return new vector */
{
	vector *p;
	int i;
	
	if (len == 4)
		p = (vector *) get_slug(h_vecstash);
	else
		p = (vector *) gimmy(sizeof(vector) + (len > 1 ? len-1 : 0)*sizeof(long));
	ERROR_IF(p == NULL, "new_vector");
	for (i=0; i<len; ++i) p->v[i] = 0;
	p->len = len;
/* printf("\t\t\t\t\t\t\t+\t%lu\n", p); */
	return p;
}

void
free_vector(p)
vector *p;
/* dispose of storage for vector p */
{
/* printf("\t\t\t\t\t\t\t-\t%lu\n", p); */
	if (p->len == 4)
		free_slug(h_vecstash, p);
	else
		ungimmy(p);
}

vector *
copy_vector(p)
vector *p;
/* return copy of p */
{
	int i, len;
	vector *q;
	
	len = p->len;
	q = new_vector(len);
	for (i=0; i<len; ++i)
		q->v[i] = p->v[i];
	return q;
}	

void
pr_vector(p)
vector *p;
/* print vector p */
{
	int j, len;
	
	len = p->len;
	for (j=0; j<len; ++j)
		printf("%3ld ", p->v[j]);
	printf("\n"); FL;
}

long
dot_prod(p, q)
vector *p, *q;
/* return dot product of p, q */
{
	int j, len;
	long sum;
	
	sum = 0;
	len = p->len;
if (q->len != len) {
pr_vector(p);
pr_vector(q);
}
	ERROR_IF(q->len != len, "dot_prod");
	for (j=0; j<len; ++j)
		sum += p->v[j] * q->v[j];
	return sum;
}

vector *
add_vectors(a,p,b,q)
long a, b;
vector *p, *q;
/* return r = a*p + b*q */
/* warning: if a, b are constants, they must be LONGS */
{
	int i, len;
	vector *r;
	
	len = p->len;
	ERROR_IF(len != q->len, "comb_vectors");
	r = new_vector(len);
	for (i=0; i<len; ++i)
		r->v[i] = a * p->v[i] + b * q->v[i];
	return r;
}

int
ziptest_vector(p)
vector *p;
/* return 1 if p nonzero, 0 if p zero */
{
	int i, len;
	
	len = p->len;
	for (i=0; i<len; ++i)
		if (p->v[i] != 0) return 1;
	return 0;
}

void
basis_vector(p, i)
vector *p;
int i;
/* set entries of p to 0, except ith enty to 1 */
{
	int j, len;
	
	len = p->len;
	ERROR_IF(i >= len, "basis_vector");
	for (j=0; j<len; ++j) {
		if (j == i)
			p->v[j] = 1;
		else
			p->v[j] = 0;
	}
}

void
neg_vector(p)
vector *p;
/* negate p */
{
	int i, len;
	
	len = p->len;
	for (i=0; i<len; ++i)
		p->v[i] = - p->v[i];
}
