/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "hull.h"
extern int verbose;

void
shine(fs, v, dim)
facet **fs;
vector *v;
int dim;
/* mark light, critical, dark flags on facets */
/* while at it, set spawn pointers to NULL */
{
	facet *f;
	long a;
	int i;
	link *p;
	
#define SET_FLAGS(F,A,B,C) \
	{ F->light = A; F->critical = B; F->dark = C; }
	 
	for (f=fs[dim-1]; f!=NULL; f=f->p) {
		f->spawn = NULL;
		a = dot_prod(f->v, v);
		if (a < f->c)
			SET_FLAGS(f,1,0,0)
		else if (a == f->c)
			SET_FLAGS(f,0,1,0)
		else
			SET_FLAGS(f,0,0,1)
	}
	for (i=dim-2; i>=0; --i)
		for (f=fs[i]; f!=NULL; f=f->p) {
			f->spawn = NULL;
			SET_FLAGS(f,0,0,0);
			for (p=f->up; p!=NULL; p=p->p) {
				if (p->f->light == 1) f->light = 1;
				if (p->f->critical == 1) f->critical = 1;
				if (p->f->dark == 1) f->dark = 1;
			}
		}
}

void
insert_facet(fs, cf, i)
facet **fs, *cf;
int i;
/* insert new facet of dim i, created by cf */
{
	facet *f, *f2;
	link *p, *q;
	
	f = new_facet();
	f->p = fs[i];
	fs[i] = f;
	cf->spawn = f;
	
	q = new_link();
	q->p = cf->up;
	cf->up = q;
	q->f = f;
	
	q = new_link();
	q->p = f->dn;
	f->dn = q;
	q->f = cf;
	
	for (p=cf->up; p!=NULL; p=p->p) {
		if ((f2 = p->f->spawn) == NULL) continue;
		q = new_link();
		q->p = f->up;
		f->up = q;
		q->f = f2;
		
		q = new_link();
		q->p = f2->dn;
		f2->dn = q;
		q->f = f;
	}
	if (verbose) printf("+");
} 

void
delete_facet(pf)
facet **pf;
/* delete facet f from data structure fs */
{
	facet *f;
	link *p, *q, **r;
	
	f = *pf;
	for (p=f->up; p!=NULL; q=p, p=p->p, free_link(q)) {
		for (r= &(p->f->dn); (*r)->f!=f; r= &((*r)->p));
		q = *r;
		*r = q->p;
		free_link(q);
	}
	for (p=f->dn; p!=NULL; q=p, p=p->p, free_link(q)) {
		for (r= &(p->f->up); (*r)->f!=f; r= &((*r)->p));
		q = *r;
		*r = q->p;
		free_link(q);
	}
	*pf = f->p;
	free_facet(f);
	if (verbose) printf("-");
}

void
rescale(p, pi)
vector *p;
long *pi;
/* divide p by gcd of entries */
{
	int i, len;
	long d;

	len = p->len;
	d = *pi;
	for (i=0; i<len; ++i)
		d = gcd_long(d, p->v[i]);
	if (d != 0) {
		for (i=0; i<len; ++i)
			p->v[i] /= d;
		*pi /= d;
	}
}
			
void
compute_normal(fs, i, v)
facet **fs;
int i;
vector *v;
{
	facet *f, *flight, *fdark, *swap;
	long clight, cdark, gcd;
	link *q;

	f = fs[i];
	q = f->dn->f->up->p;
	ERROR_IF(q == NULL, "compute_normal");
	flight = q->f;
	q = q->p;
	ERROR_IF(q == NULL, "compute_normal");
	fdark = q->f;
	if (!flight->light) {
		swap = flight;
		flight = fdark;
		fdark = swap;
	}
	cdark = flight->c - dot_prod(flight->v, v);
	clight = - fdark->c + dot_prod(fdark->v, v);
	gcd = gcd_long(clight, cdark);
	ERROR_IF(gcd < 0, "compute_normal: gcd < 0");
	clight /= gcd;
	cdark /= gcd;
	f->v = add_vectors(clight, flight->v, cdark, fdark->v);
	scale_vector(f->v);
	f->c = dot_prod(f->v,v);
	if (verbose) printf("n");
}

void
find_spawn(f)
facet *f;
{
	link *p;

	for (p=f->up; p!=NULL; p=p->p) {
		if (!p->f->light && !p->f->dark) {
			f->spawn = p->f;
			break;
		}
	}
	if (verbose) printf("s");
}

void
complete_cone(fs, v)
facet **fs;
vector *v;
{
	facet *g, *f2;
	link *q;
	
	g = new_facet();
	g->v = copy_vector(v);
	for (f2=fs[0]; f2!=NULL; f2=f2->p) {
		if (f2->spawn != NULL) {
			q = new_link();
			q->p = g->up;
			g->up = q;
			q->f = f2->spawn;
			
			q = new_link();
			q->p = f2->spawn->dn;
			f2->spawn->dn = q;
			q->f = g;
		}
	}

	g->p = fs[0];
	fs[0] = g;
	if (verbose) printf("c");
}			

void
adjoin_vertex(fs, v, dim)
facet **fs;
vector *v;
int dim;
{
	int i;
	facet **pf, *f;

/* printf("about to adjoin a vertex\n"); */
/* PV("new vertex", v); */	
	shine(fs, v, dim);
/* screen_tope(fs); */
	for (i=dim-2; i>=0; --i) {
		for (pf= &fs[i]; *pf!=NULL; pf= &(*pf)->p) {
			f = *pf;
/* printf("working on facet %d\n", f->id); */
			if (f->light && f->dark) {
				insert_facet(fs, f, i+1);
/* screen_tope(fs); */
				if (i == dim-2)
					compute_normal(fs, i+1, v);
			}
			else if (i < dim-1 && f->critical && f->dark)
				find_spawn(f);
/* screen_tope(fs); */
		}
	}
	for (i=dim-1; i>=0; --i) {
		for (pf= &fs[i]; *pf!=NULL; ) {
			f = *pf;
/* printf("working on facet %d\n", f->id); */
			if (f->light && !f->dark)
					delete_facet(pf);
			else
				pf= &(*pf)->p;
/* screen_tope(fs); */
		}
	}
	complete_cone(fs, v);
	if (verbose) printf("\n");
}
