/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */

/* commands to build in MPW C

C -dMPWC sendit.c
Set L "{CLibraries}"
Set S "{L}StdCLib.o {L}CInterface.o {L}CRuntime.o {L}CSANELib.o"
Link sendit.c.o {S} -o {MPW}Tools:sendit -t MPST -c 'MPS '
Delete sendit.c.o
	
*/

#include <stdio.h>

#ifdef MPWC
#include <Types.h>
#include <OSUtils.h>
#include <Files.h>	
#endif
     
char tag[] = "@@ship@@";
int tag_len = 8;
     
FILE *topen(fileName, mode)
char *fileName, *mode;
{
#ifdef MPWC
	FInfo fndrInfo;
#endif
	FILE *fp, *fopen();
	
	fp = fopen(fileName, mode);
#ifdef MPWC
	/* doesn't work but not needed in LSC */
	if (fp != NULL) {
		GetFInfo(fileName, 0, &fndrInfo);
		if(fndrInfo.fdType == 0) fndrInfo.fdType = 'TEXT';
		if(fndrInfo.fdCreator == 0) fndrInfo.fdCreator = 'MPS ';
		SetFInfo(fileName, 0, &fndrInfo);
	}
#endif
	return fp;
}

int doFile(fil)
FILE *fil ;
{
  FILE *ofil ;
  char line[1000] ;
  char name[1000] ;
     
  do {
    if (fgets(line, 1000, fil) == NULL) return(0) ;
  } while (!is_tag(line)) ;
  if (sscanf(line + tag_len, "%s", name) != 1)
    {
      printf("name garbled for next source file\n") ;
      return(0) ;
    }
  ofil = topen(name, "w") ;
  if (ofil == NULL)
    {
      printf("can't open output file %s\n", line+tag_len) ;
      return ;
    }
  fgets(line, 1000, fil) ;
  while (!is_tag(line))
    {
      fputs(line, ofil) ;
      fgets(line, 1000, fil) ;
    }
  fclose(ofil) ;
  return(1) ;
}
     
     
take(fil)
FILE *fil ;
{
  while (doFile(fil)) ;
}
     
int
is_tag(s)
char *s;
{
  char *t;
     
  t = tag;
  while (*s != '\0') {
    if (*t == '\0') return 1;
    else if (*s != *t) return 0;
    ++s, ++t;
  }
  return 0;
}
     
putfiles(fil, argc, argv)
FILE *fil ;
int argc ;
char *argv[] ;
{
  int i, last ;
  FILE *ifil ;
  char line[1000] ;
     
  for (i=0; i<argc; i++) {
    ifil = topen(argv[i], "r") ;
    if (ifil == NULL)
      {
        printf("can't open file %s\n", argv[i]) ;
        continue ;
      }
    fprintf(fil, "%s%s\n", tag, argv[i]) ;
    while (fgets(line, 1000, ifil) != NULL)
      fputs(line, fil) ;
	last = strlen(line) - 1 ;
	if (line[last] != '\n')
		fputc('\n', fil) ;
    fprintf(fil, "%s\n", tag) ;
    fclose(ifil) ;
  }
}
     
main(argc, argv)
int argc ;
char *argv[] ;
{
  FILE *fil ;
  int which ;
     
  if (argc == 1) {
    printf("to unpack: sendit 0 in_file\n") ;
    printf("to pack  : sendit 1 out_file source_file(s)\n") ;
    return ;
  }
  which = atoi(argv[1]) ;
  if (which == 0) {
    fil = topen(argv[2], "r") ;
    if (fil == NULL)
      {
        printf("can't open file %s\n", argv[2]) ;
        return ;
      }
    take(fil) ;
  } else {
    fil = topen(argv[2], "w") ;
    if (fil == NULL)
      {
        printf("can't open file %s\n", argv[2]) ;
        return ;
      }
    putfiles(fil, argc-3, argv+3) ;
  }
}
     
     
