/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "hull.h"

long
gcd_long(a,b)
long a, b;
/* return gcd of a and b */
{
	if (a == 0 && b == 0) return 0;
	if (a < 0) a = -a;
	if (b < 0) b = -b;
	if (b < a) {
		if (b == 0) return a;
		a = a % b;
	}
	while (1) {
		/* assume |a| <= |b| */		
		if (a == 0) return b;
		b = b % a;
		/* assume |b| <= |a| */		
		if (b == 0) return a;
		a = a % b;
	}
}

void
scale_vector(p)
vector *p;
/* divide p by gcd of entries */
{
	int i, len;
	long d;
	
	len = p->len;
	d = 0;
	for (i=0; i<len; ++i)
		d = gcd_long(d, p->v[i]);
	if (d != 0)
		for (i=0; i<len; ++i)
			p->v[i] /= d;
}
			

vector *
delta_matrix(p,q)
matrix *p;
vector *q;
/* return x, where x->v[i] = determinant of r = p, with ith col = q */
{
	int i, rows;
	vector *x;
	matrix *r;
	
	rows = p->rows;
	ERROR_IF(rows != p->cols || rows != q->len, "delta_matrix");
	r = copy_matrix(p);
	x = new_vector(rows);
	for (i=0; i<rows; ++i) {
		free_vector(r->v[i]);
		r->v[i] = copy_vector(q);
		x->v[i] = det_matrix(r);
		free_vector(r->v[i]);
		r->v[i] = copy_vector(p->v[i]);
	}
	free_matrix(r);
	return x;
}

vector *
normal_vector(p,q)
matrix *p;
vector *q;
/* return normal to rows of p, in span of p and q */
{
	matrix *m, *pt;
	vector *r, *x, *y, *z;
	long d;
	int i;
	
	for (i=0; i<p->rows; ++i) scale_vector(p->v[i]);
	scale_vector(q);
	m = mat_times_tmat(p, p);
	r = mat_times_vec(p, q);
	x = delta_matrix(m, r);
	d = det_matrix(m);
	pt = trans_matrix(p);
	y = mat_times_vec(pt, x);
	z = add_vectors(d, q, -1L, y);
	scale_vector(z);
	free_matrix(m);
	free_matrix(pt);
	free_vector(r);
	free_vector(x);
	free_vector(y);
	return z;
}
