/*----------------------------------------------------------------------------
    message.c	a simple message function with variable aruments, Mar 6, 1992

    written by Andreas Hohmann, ZIB, Hohmann@sc.ZIB-Berlin.DE
    
    (along the lines of the C++ Reference Manual, Section 8.3)

    (set to standart ANSI-output routines; change it, if windows system

     or other output devices available)
-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdarg.h>
#include <malloc.h>

#include "mystd.h"
#include "message.h"

Bool printMessages, printWarnings, printErrors, printFatals;
static char *errStrings[] = {"message", "warning", "error", "fatal"};
 
void DoMessage(MessageType type, char *format, va_list va) {
    printf("%s: ", errStrings[type]);
    vprintf(format, va);
    printf("\n");
    if (type >= eError) abort(1);
}

void Message(char *format, ...) {
    va_list va;
    
    va_start(va, format);
    DoMessage(eMessage, format, va);	
    va_end(va);
}

void Warning(char *format, ...) {
    va_list va;
    
    va_start(va, format);
    DoMessage(eWarning, format, va);	
    va_end(va);
}

void Error(char *format, ...) {
    va_list va;
    
    va_start(va, format);
    DoMessage(eError, format, va);	
    va_end(va);
}

void Fatal(char *format, ...) {
    va_list va;
    
    va_start(va, format);
    DoMessage(eFatal, format, va);	
    va_end(va);
}

void InitMessage() {
}
 
