 /*
  * Khoros: $Id: writer.c,v 1.2 1991/10/02 00:12:30 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: writer.c,v 1.2 1991/10/02 00:12:30 khoros Exp $";
#endif

 /*
  * $Log: writer.c,v $
 * Revision 1.2  1991/10/02  00:12:30  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: writer.c
 >>>>
 >>>>      Program Name: writer
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	The purpose of Ghostwriter is to create C  source  code  and
 >>>>	man  pages  for  the  application  program.   The  SOURCE of
 >>>>	information  for  ghostwriter  are  the  *.pane  file  (User
 >>>>	Interface  Specification File), and the *.prog file (Program
 >>>>	Specification   file).    The   DESTINATION   of   extracted
 >>>>	information is one or more of five files:  a *.c file, a *.h
 >>>>	file, an l*.c file, a *.1 file, and a *.3 file, where '*' is
 >>>>	the name of the program being generated.
 >>>>	
 >>>> Date Last Updated: Wed Sep 11 11:08:37 1991
 >>>>
 >>>>          Routines: main- the main program for writer
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "writer.h"


/****************************************************************
 *
 * Routine Name:  main program for writer
 *
 *       Input:  
 *        -name  name of program to be generated 
 *
 *
 *        [-config] use configuration file?
 *        [-lib] generate lib file?
 *        [-man3] generate man3 file?
 *        [-install] install output?
 *        [-format] formatting (0 = none, 1 = nroff)  (0 < value < 1)
 *        [-debug] generate debug statements in main?
 *        [-tag] append tags on variable names?
 *        [-force] force output?
 *        [-cp] alternate copyright file (*.prog style)
 *        [-toolbox] toolbox name
 *        [-type] type of program
 *		'prog' (vroutine),
 *		'xprog' (xvroutine),
 *		'fprog' (vroutine w/ calls to FORTRAN),
 *		 or 'fxprog' (xvroutine w/ calls to FORTRAN)
 *		   [default = prog] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        int dummy;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (dummy != dummy) XtToolkitInitialize();
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!(lwriter()))
        {
           fprintf(stderr, "\nghostwriter:\n");
           fprintf(stderr, "New Files Have NOT Been Generated\n");
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for writer 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "writer :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThe purpose of Ghostwriter is to create C  source  code  and\n");
	fprintf(stderr, "\tman  pages  for  the  application  program.   The  SOURCE of\n");
	fprintf(stderr, "\tinformation  for  ghostwriter  are  the  *.pane  file  (User\n");
	fprintf(stderr, "\tInterface  Specification File), and the *.prog file (Program\n");
	fprintf(stderr, "\tSpecification   file).    The   DESTINATION   of   extracted\n");
	fprintf(stderr, "\tinformation is one or more of five files:  a *.c file, a *.h\n");
	fprintf(stderr, "\tfile, an l*.c file, a *.1 file, and a *.3 file, where '*' is\n");
	fprintf(stderr, "\tthe name of the program being generated.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-name  name of program to be generated  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-config]  use configuration file? (boolean) [false]\n");
	fprintf(stderr,"\t[-lib]  generate lib file? (boolean) [true]\n");
	fprintf(stderr,"\t[-man3]  generate man3 file? (boolean) [true]\n");
	fprintf(stderr,"\t[-install]  install output? (boolean) [false]\n");
	fprintf(stderr,"\t[-format]  formatting (0 = none, 1 = nroff) (integer, 0 to 1) [1]\n");
	fprintf(stderr,"\t[-debug]  generate debug statements in main? (boolean) [false]\n");
	fprintf(stderr,"\t[-tag]  append tags on variable names? (boolean) [true]\n");
	fprintf(stderr,"\t[-force]  force output? (boolean) [false]\n");
	fprintf(stderr,"\t[-cp]  alternate copyright file (*.prog style) (string) [null]\n");
	fprintf(stderr,"\t[-toolbox]  toolbox name (string) [null]\n");
	fprintf(stderr, "\t[-type]  type of program\n");
	fprintf(stderr, "\t\t'prog'  (vroutine),\n");
	fprintf(stderr, "\t\t'xprog'  (xvroutine),\n");
	fprintf(stderr, "\t\t'fprog'  (vroutine w/ calls to FORTRAN),\n");
	fprintf(stderr, "\t\t or 'fxprog'  (xvroutine w/ calls to FORTRAN)\n");
	fprintf(stderr, "\t\t[default = prog]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for ghostwriter\n");
	fprintf(stderr, "\t[-U] Gives the usage for ghostwriter\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called ghost.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses ghost.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for writer
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*name_pstr = 
	"\nEnter: (name) name of program to be generated \n        {string}: "; 
char	*name_def = NULL;
char	*config_pstr = 
	"\nEnter: (config) use configuration file? \n        {boolean, (y/n)  [no] }: "; 
char	*lib_pstr = 
	"\nEnter: (lib) generate lib file? \n        {boolean, (y/n)  [yes] }: "; 
char	*man3_pstr = 
	"\nEnter: (man3) generate man3 file? \n        {boolean, (y/n)  [yes] }: "; 
char	*install_pstr = 
	"\nEnter: (install) install output? \n        {boolean, (y/n)  [no] }: "; 
char	*format_pstr = 
	"\nEnter: (format) formatting (0 = none, 1 = nroff) \n        {integer, 0 to 1 [1] }: "; 
char	*debug_pstr = 
	"\nEnter: (debug) generate debug statements in main? \n        {boolean, (y/n)  [no] }: "; 
char	*tag_pstr = 
	"\nEnter: (tag) append tags on variable names? \n        {boolean, (y/n)  [yes] }: "; 
char	*force_pstr = 
	"\nEnter: (force) force output? \n        {boolean, (y/n)  [no] }: "; 
char	*cp_pstr = 
	"\nEnter: (cp) alternate copyright file (*.prog style) \n        {string}: "; 
char	*cp_def = NULL;
char	*toolbox_pstr = 
	"\nEnter: (toolbox) toolbox name \n        {string}: "; 
char	*toolbox_def = NULL;
char	*type_pstr = "\nEnter: (type) type of program -- \n      \t\t'prog' (vroutine)\n\t\t'xprog' (xvroutine)\n\t\t'fprog' (vroutine w/ calls to FORTRAN)\n\t\tor 'fxprog' (xvroutine w/ calls to FORTRAN)\n  [prog]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "ghostwriter", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "ghost.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "ghostwriter: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "ghost.ans");
		}

	     }

	}

	/*
	 * allocate the writer structure
	 */
	writer = (writer_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (writer_struct));

	/*
	 * get required arguments for writer
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(writer->name_flag = vget_string(fid, prompt_flag,
			"-name", name_pstr, &(writer->name),
			name_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(writer->name_flag))
		{
		    fprintf(stderr, "\t\tname is required, please re-enter: \n");
		    writer->name_flag = vget_string(fid, prompt_flag,
		    "-name", name_pstr, &(writer->name),
		    name_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-name' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for writer
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	writer->config_flag = vget_logic(fid, prompt_flag,
	"-config", config_pstr, &(writer->config), 0);

	writer->lib_flag = vget_logic(fid, prompt_flag,
	"-lib", lib_pstr, &(writer->lib), 1);

	writer->man3_flag = vget_logic(fid, prompt_flag,
	"-man3", man3_pstr, &(writer->man3), 1);

	writer->install_flag = vget_logic(fid, prompt_flag,
	"-install", install_pstr, &(writer->install), 0);

	writer->format_flag = vget_int(fid, prompt_flag,
	"-format", format_pstr, &(writer->format),
	1, 0, 1);

	writer->debug_flag = vget_logic(fid, prompt_flag,
	"-debug", debug_pstr, &(writer->debug), 0);

	writer->tag_flag = vget_logic(fid, prompt_flag,
	"-tag", tag_pstr, &(writer->tag), 1);

	writer->force_flag = vget_logic(fid, prompt_flag,
	"-force", force_pstr, &(writer->force), 0);

	writer->cp_flag = vget_string(fid, prompt_flag,
	"-cp", cp_pstr, &(writer->cp),
	cp_def);

	if (prompt_flag == FALSE)
	{
	    if ((writer->cp_flag == 1)&&(writer->cp == NULL))
    	{
		fprintf(stderr, "writer:\n");
		fprintf(stderr, "you must specify a name following '-cp'\n");
		gw_usage();
		exit(1);
		}
	}
	writer->toolbox_flag = vget_string(fid, prompt_flag,
	"-toolbox", toolbox_pstr, &(writer->toolbox),
	toolbox_def);

	if (prompt_flag == FALSE)
	{
	    if ((writer->toolbox_flag == 1)&&(writer->toolbox == NULL))
    	{
		fprintf(stderr, "writer:\n");
		fprintf(stderr, "you must specify a name following '-toolbox'\n");
		gw_usage();
		exit(1);
		}
	}

	/*
	 * get optional toggles for writer
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		writer->type_flag = vget_string(fid, prompt_flag,
		"-type", type_pstr, &(writer->type),
		"prog");

		if (((strcmp(writer->type, "prog") == 0)) || 
		     ((strcmp(writer->type, "xprog") == 0)) || 
		     ((strcmp(writer->type, "fprog") == 0)) || 
		     ((strcmp(writer->type, "fxprog") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		writer->type_flag = vget_string(fid, prompt_flag,
		"-type", type_pstr, &(writer->type),
		"prog");

		if (((strcmp(writer->type, "prog") != 0)) && 
		     ((strcmp(writer->type, "xprog") != 0)) && 
		     ((strcmp(writer->type, "fprog") != 0)) && 
		     ((strcmp(writer->type, "fxprog") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



