 /*
  * Khoros: $Id: routines.h,v 1.4 1992/03/20 22:43:55 dkhoros Exp $
  */

 /*
  * $Log: routines.h,v $
 * Revision 1.4  1992/03/20  22:43:55  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: routines.h                             <<<<
   >>>>                                                       <<<<
   >>>>   description: routine declarations used by cantata   <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/*
 *   util.c miscellaneous routines
 */
Widget	 	xvl_change_workspace();
Glyph		*xvl_find_glyph();
Node		*xvl_locate_connection();
Node		*xvl_find_node();
Node		*xvl_get_node();
char		*xvl_get_filename();
char	 	*xvl_tempnam();
Pixmap		xvl_create_bitmap();
Pixmap		xvl_create_stippled();
char		*xvl_find_subform_label();
Node		*xvl_find_onode();

/*
 *   find.c finds miscelleaneous user interface buttons
 */
Widget	 	xvl_find_stop_button();
xvf_sub_form    *xvl_find_undo_button();

/*
 *   distribute.c miscelleaneous distributed utilties
 */
MachineInfo	*xvl_get_machine();
MachineInfo	*xvl_add_machine();
char		**xvl_remote_machines();
char		*xvl_get_machname();
char		*xvl_get_machlabel();
MachineInfo	*xvl_get_machinfo();


/*
 *   nodelist.c routines used to manipulate node (connection) lists
 */
int      	xvl_check_if_nodelist();
NodeList 	*xvl_add_to_nodelist();
NodeList 	*xvl_copy_nodelist();
NodeList 	*xvl_delete_from_nodelist();
NodeList 	*xvl_update_nodelist();

/*
 *   glyphlist.c routines used to manipulate glyph lists
 */
int       	xvl_check_if_glyphlist();
GlyphList 	*xvl_add_to_glyphlist();
GlyphList 	*xvl_copy_glyphlist();
GlyphList 	*xvl_delete_from_glyphlist();
xvf_sub_form	*xvl_copy_subform();

/*
 *   glyph.c routines used for manipulating glyphs
 */
Glyph		*xvl_copy_glyph();

/*
 *   build.c routines used for building the different glyphs structures.
 */
Glyph		*xvl_build_glyph();

/*
 *   menu.c routines used for creating toplevel workspace menus.
 */
void	  xvl_main_menu_cb();
void	  xvl_clipboard_menu_cb();
void	  xvl_procedure_menu_cb();
void	  xvl_glyph_menu_cb();

char	    *xvl_transport_menu();
char	    *xvl_distribute_menu();
Menu	    *xvl_build_menu();

/*
 *   form.c routines that will be integrated back into xvforms
 */
Widget		xvf_create_back();
Widget		xvf_create_label();
Widget		xvf_create_bitmap();
Widget		xvf_create_command();
xvf_selection	*xvf_sel_search_subform();
xvf_form	*xvf_create_xvl_form(), *xvf_begin_form();
void		xvf_pseudo_action_cb();
char		*xvf_lower();

/*
 *   callback.c routines that are used as callbacks with the toolkit
 */
void	  xvl_run_cb();
void	  xvl_error_cb();
void	  xvl_reset_cb();
void	  xvl_form_cb();
void	  xvl_destroy_cb();
void	  xvl_input_cb();
void	  xvl_output_cb();
void	  xvl_exposure_cb();
void	  xvl_connection_cb();
void	  xvl_select_cb();
void	  xvl_control_cb();
void	  xvl_move_cb();
void	  xvl_blink_cb();
void	  xvl_clipboard_cb();
void	  xvl_dispatch_cb();
void	  xvl_distributed_cb();
void	  xvl_phantomd_cb();
void	  xvl_manage_glyph();

/*
 *  error.c routines that are used to handle errors with either signal or
 *  X handlers.
 */
vsignal	  xvl_error_signal();

/*
 *   attributes.c routines used for setting and getting workspace attributes
 */
Workspace *xvl_get_attributes();
