 /*
  * Khoros: $Id: vctor.h,v 1.2 1992/03/20 22:53:40 dkhoros Exp $
  */

 /*
  * $Log: vctor.h,v $
 * Revision 1.2  1992/03/20  22:53:40  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vctor.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Mar  9 18:42:19 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vctor_h_
#define _vctor_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vctor Argument Structure
*
****************************************************************/

typedef struct _vctor  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 * Choose type of mapping from COMPLEX to REAL (Optional integer toggle - )
 */
int	 t_toggle;		/* Choose type of mapping from COMPLEX to REAL INT TOGGLE */
int	 t_flag;		/* Choose type of mapping from COMPLEX to REAL FLAG */

}  vctor_struct;

vctor_struct *vctor;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);  \
        if (image->data_storage_type != VFF_TYP_COMPLEX && \
            image->data_storage_type != VFF_TYP_DCOMPLEX) \
          { \
            (void)fprintf(stderr,"vctor: Image must be COMPLEX or DCOMPLEX\n"); \
            exit(1); \
          }
/* -include_macros_end */

#endif
