 /*
  * Khoros: $Id: lvmoredge.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmoredge.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvmoredge.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmoredge.c
 >>>>
 >>>>      Program Name: vmoredge
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:31:35 1991 
 >>>>
 >>>>          Routines: lvmoredge - the library call for vmoredge
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmoredge - library call for vmoredge
*
* Purpose:
*    
*    Morphological  edge  extraction  for  binary  byte   xvimage
*    structures.
*    
*    
* Input:
*    
*         image  - an xvimage structure (binary byte data structure)
*         kernel - an xvimage morphological-kernel structure.
*    
*    
* Output:
*    
*    image  - holds the result (Edge Map Image)
*    
*    
*
* Written By: Pascal ADAM
*    
*    Ghosted by Pascal ADAM  Mon Jun  4 16:25:26 MDT 1990
*    
*    
****************************************************************/


/* -library_def */
int
lvmoredge(image,kernel)
struct xvimage *image, *kernel;
/* -library_def_end */

/* -library_code */
{
int lvmdilate();
int lvxor();
struct xvimage *imagecopy, *createimage();
unsigned char *cptr, *cptrcp;
int i;
char   *program = "lvmoredge";

    /* Check type,... of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "lvmoredge: image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }


    /* Check type,... of kernel*/
    if (!(propertype(program, kernel, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"lvmoredge: image must be of type byte/n");
        return (0);
    }
    if (!(proper_num_images (program, kernel, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, kernel, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }


    imagecopy = createimage((unsigned long) image->row_size,
                            (unsigned long) image->col_size,
                            (unsigned long) image-> location_type, 
                            (unsigned long) 1,
                            (unsigned long) 1, 
                            "copy d'image",
                            (unsigned long) 0,  
                            (unsigned long) 0,   
                            (unsigned long) VFF_MS_NONE,
                            (unsigned long) VFF_MAPTYP_NONE,
                            (unsigned long) VFF_LOC_IMPLICIT,
                            (unsigned long) 0);

    if (imagecopy == NULL)
    {
      (void)fprintf(stderr,"lvmcustom: Unable to allocate new image!\n");
       return(0);
    }

    cptr = (unsigned char *) image->imagedata;
    cptrcp = (unsigned char *) imagecopy->imagedata;

    for (i=0; i< image->row_size*image->col_size; i++) 
    {
       *cptrcp++ = *cptr++;
    }
    if(! lvmdilate(image,kernel))
    {
        (void) fprintf(stderr, "vmoredge: lvmdilate Failed\n");
        return(0);
    }

    if(! lvxor(image,imagecopy))
    {
        (void) fprintf(stderr, "vmoredge: lvxor Failed\n");
        return(0);
    }


    return(1);
}
/* -library_code_end */
