 /*
  * Khoros: $Id: ksrcconf.c,v 1.2 1991/10/01 23:53:22 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ksrcconf.c,v 1.2 1991/10/01 23:53:22 khoros Exp $";
#endif

 /*
  * $Log: ksrcconf.c,v $
 * Revision 1.2  1991/10/01  23:53:22  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ksrcconf.c
 >>>>
 >>>>      Program Name: ksrcconf
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	A utility for configuring source in the khoros environment.
 >>>>	
 >>>>	

 >>>>            Author: Tom Sauer and Charlie Gage
 >>>>
 >>>> Date Last Updated: Wed Sep 25 22:11:28 1991
 >>>>
 >>>>          Routines: main- the main program for ksrcconf
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "ksrcconf.h"


/****************************************************************
 *
 * Routine Name:  main program for ksrcconf
 *
 *       Input:  
 *
 *
 *          [-source] input source directory [.]
 *          [-toolbox] Toolbox name
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
char *sourcepath, machpath[MAXPATHLEN];
char *vexpandpath(), *vbasename();
char buffer[BUFSIZE];
char *script_file, *toolboxpath, *toolbox;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

if (ksrcconf->source_flag)
{
  if ((sourcepath = vexpandpath(ksrcconf->source_string, NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path obtained for the source file.\n");
    exit(0);
  }
}
else
{
  if ((sourcepath = vexpandpath(".", NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path obtained for the source file.\n");
    exit(0);
  }
}

if (ksrcconf->toolbox_flag)
{
  toolboxpath = vtoolbox_path(ksrcconf->toolbox_string);
  if (toolboxpath == NULL)
  {
     fprintf(stderr, "%s:  The toolbox name '%s' is not a valid toolbox.\n",
             program, ksrcconf->toolbox_string);
     exit(0);
  }

  toolbox = vlower_string(ksrcconf->toolbox_string, NULL);

  sprintf(machpath, "%s/%s/%s_mf", toolboxpath, MACH_FILE_PATH, toolbox);
  free(toolbox);

}
else
{
  sprintf(machpath, "_NULL_");
}


/* Assign a filename to the shell script file */
script_file = "ksrcconf_csh";

/* Build the buffer for the system call */
(void) sprintf(buffer,"%s %s %s", script_file, sourcepath, machpath);

/* System off the ksrcconf_csh script */
system(buffer);

/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for ksrcconf 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "ksrcconf :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tA utility for configuring source in the khoros environment.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-source]  input source directory [.] (string) [null]\n");
	fprintf(stderr,"\t[-toolbox]  Toolbox name (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for ksrcconf\n");
	fprintf(stderr, "\t[-U] Gives the usage for ksrcconf\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called ksrcconf.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses ksrcconf.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for ksrcconf
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*source_pstr = 
	"\nEnter: (source) input source directory [.] \n        {string}: "; 
char	*source_def = NULL;
char	*toolbox_pstr = 
	"\nEnter: (toolbox) Toolbox name \n        {string}: "; 
char	*toolbox_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "ksrcconf", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "ksrcconf.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "ksrcconf: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "ksrcconf.ans");
		}

	     }

	}

	/*
	 * allocate the ksrcconf structure
	 */
	ksrcconf = (ksrcconf_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (ksrcconf_struct));

	/*
	 * get optional arguments for ksrcconf
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	ksrcconf->source_flag = vget_string(fid, prompt_flag,
	"-source", source_pstr, &(ksrcconf->source_string),
	source_def);

	if (prompt_flag == FALSE)
	{
	    if ((ksrcconf->source_flag == 1)&&(ksrcconf->source_string == NULL))
    	{
		fprintf(stderr, "ksrcconf:\n");
		fprintf(stderr, "you must specify a name following '-source'\n");
		gw_usage();
		exit(1);
		}
	}
	ksrcconf->toolbox_flag = vget_string(fid, prompt_flag,
	"-toolbox", toolbox_pstr, &(ksrcconf->toolbox_string),
	toolbox_def);

	if (prompt_flag == FALSE)
	{
	    if ((ksrcconf->toolbox_flag == 1)&&(ksrcconf->toolbox_string == NULL))
    	{
		fprintf(stderr, "ksrcconf:\n");
		fprintf(stderr, "you must specify a name following '-toolbox'\n");
		gw_usage();
		exit(1);
		}
	}

}



