 /*
  * Khoros: $Id: viff2xbm.c,v 1.1 1991/05/10 15:53:17 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: viff2xbm.c,v 1.1 1991/05/10 15:53:17 khoros Exp $";
#endif

 /*
  * $Log: viff2xbm.c,v $
 * Revision 1.1  1991/05/10  15:53:17  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viff2xbm.c
 >>>>
 >>>>      Program Name: viff2xbm
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts an Khoros (viff) bitmap file to an X11 bitmap  file
 >>>>	(xbm).
 >>>>	
 >>>>	
 >>>>            Author: Mark Young, Mike Lang
 >>>>
 >>>> Date Last Updated: Thu Apr  4 17:36:29 1991
 >>>>
 >>>>          Routines: main- the main program for viff2xbm
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "viff2xbm.h"


/****************************************************************
 *
 * Routine Name:  main program for viff2xbm
 *
 *       Input:  
 *          -i  input image 
 *          -o  output resulting xbm definition 
 *          -n  xbm description name 
 *
 *
 *          [-p] if yes (default) photopositive
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
    FILE   *printdev;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READINPUT(image) ;
CHECKINPUT(program, image) ;

if (! vwrite_ascii(viff2xbm->o_file, &printdev))
{
   (void) fprintf(stderr, "viff2xbm:  Can't open xbm output file: \n");
   exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */
if (! lviff2xbm(printdev, image, viff2xbm->n_string, viff2xbm->p_logic))
{
(void) fprintf(stderr, "lviff2xbm Failed\n");
exit(1);
}

/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for viff2xbm 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "viff2xbm :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts an Khoros (viff) bitmap file to an X11 bitmap  file\n");
	fprintf(stderr, "\t(xbm).\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output resulting xbm definition  (outfile)\n");
	fprintf(stderr,"\t-n  xbm description name  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-p]  if yes (default) photopositive (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for viff2xbm\n");
	fprintf(stderr, "\t[-U] Gives the usage for viff2xbm\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called viff2xbm.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses viff2xbm.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for viff2xbm
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output resulting xbm definition \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) xbm description name \n        {string}: "; 
char	*n_def = "bitmap";
char	*p_pstr = 
	"\nEnter: (p) if yes (default) photopositive \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "viff2xbm", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "viff2xbm.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "viff2xbm: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "viff2xbm.ans");
		}

	     }

	}

	/*
	 * allocate the viff2xbm structure
	 */
	viff2xbm = (viff2xbm_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (viff2xbm_struct));

	/*
	 * get required arguments for viff2xbm
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(viff2xbm->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(viff2xbm->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2xbm->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    viff2xbm->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(viff2xbm->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(viff2xbm->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(viff2xbm->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2xbm->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    viff2xbm->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(viff2xbm->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(viff2xbm->n_flag = vget_string(fid, prompt_flag,
			"-n", n_pstr, &(viff2xbm->n_string),
			n_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2xbm->n_flag))
		{
		    fprintf(stderr, "\t\tn is required, please re-enter: \n");
		    viff2xbm->n_flag = vget_string(fid, prompt_flag,
		    "-n", n_pstr, &(viff2xbm->n_string),
		    n_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-n' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for viff2xbm
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	viff2xbm->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(viff2xbm->p_logic), 1);


}



