 /*
  * Khoros: $Id: dfiltbp.c,v 1.3 1992/03/20 23:24:04 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dfiltbp.c,v 1.3 1992/03/20 23:24:04 dkhoros Exp $";
#endif

 /*
  * $Log: dfiltbp.c,v $
 * Revision 1.3  1992/03/20  23:24:04  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfiltbp.c
 >>>>
 >>>>      Program Name: dfiltbp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	designs bandpass filters
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Mon Mar  9 20:16:24 1992
 >>>>
 >>>>          Routines: main- the main program for dfiltbp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dfiltbp.h"


/****************************************************************
 *
 * Routine Name:  main program for dfiltbp
 *
 *       Input:  
 *         -o  resulting output file (polynomial file) 
 *
 *
 *         [-h] sampling frequency in hertz  (value > 0.0)
 *         [-f1] lower rejection frequency  (value > 0.0)
 *         [-f2] lower cutoff frequency  (value > 0.0)
 *         [-f3] upper cutoff frequency  (value > 0.0)
 *         [-f4] upper rejection frequency  (value > 0.0)
 *         [-tc] gain at passband edges   (0.000 < value < 1.000)
 *         [-tr] gain at stopband edges   (0.000 < value < 1.000)
 *         [-c] filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii)
 *		0 (butterworth),
 *		1 (chebychev i),
 *		or 2 (chebychev ii)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    int class;
    float f1,f2,f3,f4,sfreq,tolr,tolc; 
    struct  poly_struct *poly = NULL;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    f1 = dfiltbp->f1_float;
    f2 = dfiltbp->f2_float;
    f3 = dfiltbp->f3_float;
    f4 = dfiltbp->f4_float;

    tolr = dfiltbp->tr_float;
    tolc = dfiltbp->tc_float;
    class = dfiltbp->c_toggle;
    sfreq = dfiltbp->h_float;

/*
** allocate memory for junk passed into writepoly()
*/

  if(!createpoly(&poly,MAXPOLYS,MAXTERMS,MAXSTAGES,STRMAX)){
     fprintf(stderr,"%s:  failure to create polynomial.\n",program);
     exit(1);
  }
  strcpy(poly->func_name,FUNC_NAME);
  strcpy(poly->indep_var,INDEP_VAR);
/* -main_before_lib_call_end */

/* -main_library_call */
    if(!ldfiltbp(poly,f1,f2,f3,f4,tolc,tolr,sfreq,class)){
       fprintf(stderr,"%s:  call to ldfiltbp failed.\n",program);
       exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writepoly(dfiltbp->o_file,poly,1,"filter created by dfiltbp");
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dfiltbp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dfiltbp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tdesigns bandpass filters\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting output file (polynomial file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-h]  sampling frequency in hertz (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-f1]  lower rejection frequency (float, > 0.0) [0.1]\n");
	fprintf(stderr,"\t[-f2]  lower cutoff frequency (float, > 0.0) [0.2]\n");
	fprintf(stderr,"\t[-f3]  upper cutoff frequency (float, > 0.0) [0.3]\n");
	fprintf(stderr,"\t[-f4]  upper rejection frequency (float, > 0.0) [0.4]\n");
	fprintf(stderr,"\t[-tc]  gain at passband edges  (float,  0.000 to 1.000) [0.707]\n");
	fprintf(stderr,"\t[-tr]  gain at stopband edges  (float,  0.000 to 1.000) [0.316]\n");
	fprintf(stderr, "\t[-c]  filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii)\n");
	fprintf(stderr, "\t\t0  (butterworth),\n");
	fprintf(stderr, "\t\t1  (chebychev i),\n");
	fprintf(stderr, "\t\tor 2  (chebychev ii)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dfiltbp\n");
	fprintf(stderr, "\t[-U] Gives the usage for dfiltbp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dfiltbp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dfiltbp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dfiltbp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting output file (polynomial file) \n        {outfile}: "; 
char	*h_pstr = 
	"\nEnter: (h) sampling frequency in hertz \n        {float, > 0.0 [1.000000] }: "; 
char	*f1_pstr = 
	"\nEnter: (f1) lower rejection frequency \n        {float, > 0.0 [0.100000] }: "; 
char	*f2_pstr = 
	"\nEnter: (f2) lower cutoff frequency \n        {float, > 0.0 [0.200000] }: "; 
char	*f3_pstr = 
	"\nEnter: (f3) upper cutoff frequency \n        {float, > 0.0 [0.300000] }: "; 
char	*f4_pstr = 
	"\nEnter: (f4) upper rejection frequency \n        {float, > 0.0 [0.400000] }: "; 
char	*tc_pstr = 
	"\nEnter: (tc) gain at passband edges  \n        {float,  0.000 to 1.000 [0.707000] }: "; 
char	*tr_pstr = 
	"\nEnter: (tr) gain at stopband edges  \n        {float,  0.000 to 1.000 [0.316000] }: "; 
char	*c_pstr = "\nEnter: (c) filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) -- \n      \t\t0 (butterworth)\n\t\t1 (chebychev i)\n\t\tor 2 (chebychev ii)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dfiltbp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dfiltbp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dfiltbp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dfiltbp.ans");
		}

	     }

	}

	/*
	 * allocate the dfiltbp structure
	 */
	dfiltbp = (dfiltbp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dfiltbp_struct));

	/*
	 * get required arguments for dfiltbp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dfiltbp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dfiltbp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfiltbp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dfiltbp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dfiltbp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dfiltbp
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dfiltbp->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(dfiltbp->h_float),
	1.000000, 2.000000, 2.000000);

	dfiltbp->f1_flag = vget_float(fid, prompt_flag,
	"-f1", f1_pstr, &(dfiltbp->f1_float),
	0.100000, 2.000000, 2.000000);

	dfiltbp->f2_flag = vget_float(fid, prompt_flag,
	"-f2", f2_pstr, &(dfiltbp->f2_float),
	0.200000, 2.000000, 2.000000);

	dfiltbp->f3_flag = vget_float(fid, prompt_flag,
	"-f3", f3_pstr, &(dfiltbp->f3_float),
	0.300000, 2.000000, 2.000000);

	dfiltbp->f4_flag = vget_float(fid, prompt_flag,
	"-f4", f4_pstr, &(dfiltbp->f4_float),
	0.400000, 2.000000, 2.000000);

	dfiltbp->tc_flag = vget_float(fid, prompt_flag,
	"-tc", tc_pstr, &(dfiltbp->tc_float),
	0.707000, 0.000000, 1.000000);

	dfiltbp->tr_flag = vget_float(fid, prompt_flag,
	"-tr", tr_pstr, &(dfiltbp->tr_float),
	0.316000, 0.000000, 1.000000);


	/*
	 * get optional toggles for dfiltbp
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dfiltbp->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(dfiltbp->c_toggle),
		0, 0, 0);

		if ((dfiltbp->c_toggle == 0 ) || 
		    (dfiltbp->c_toggle == 1 ) || 
		    (dfiltbp->c_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dfiltbp->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(dfiltbp->c_toggle),
		0, 0, 0);

		if ((dfiltbp->c_toggle != 0 ) && 
		    (dfiltbp->c_toggle != 1 ) && 
		    (dfiltbp->c_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



