 /*
  * Khoros: $Id: Shm.h,v 1.3 1992/03/20 23:38:15 dkhoros Exp $
  */

 /*
  * $Log: Shm.h,v $
 * Revision 1.3  1992/03/20  23:38:15  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: Shm.h					<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _Shm_h_
#define _Shm_h_

#include <sys/ipc.h>
#include <sys/shm.h>


/*
 *  Internal structures for the following transport
 *
 *		shm	   -  Shared Memory transport
 */

/* shared memory structure */
typedef struct
{
	int     shmid;
	int     key;
	int     size;
	int     offset;
	int     shmflag;
	caddr_t addr;

} ShmStruct;

#undef  ResourceStruct
#define ResourceStruct ShmStruct


int	shm_tempnam(),
	shm_open(),
	shm_close(),
	shm_read(),
	shm_write(),
	shm_lseek(),
	shm_tell(),
	shm_access(),
	shm_unlink(),
	shm_lock();


static TransportInformation shm_routines[] =
{
    {
	"Shared Memory",
	"shm",
	TRUE,
	shm_tempnam,
	shm_open,
	shm_close,
	shm_read,
	shm_write,
	shm_lseek,
	shm_tell,
	shm_access,
	shm_unlink,
	shm_lock,
	NULL,

	NULL,
    }
};

#endif /* _Shm_h_ */
/* don`t add after the endif */
