#!/usr/bin/awk -f
BEGIN {
 split(ARGV[1],arg,".")
# pdb calculates bonds by itself, if the scaling is right:
 pdbscale=0.1
 dateiname=arg[1]?arg[1]:"foo"
 datenfile=ARGV[2]?ARGV[2]:ENVIRON["HOME"]"/atoms.dec"
 datenfile=ENVIRON["CASCADE"]?ENVIRON["CASCADE"]"/atoms.dec":datenfile
 while (0!=getline <datenfile) {
  if (($0!~/#/)&&($0!~/;/)&&($0!~/\*/)&&($0!="")) name[$4+0]=$1}}
NR==1 {
 A=$1}
NR==2,NR==A+1 {
 if ($1!=0) {
  id[++atome]=name[$1+0]
  x[atome]=$2*pdbscale
  y[atome]=$3*pdbscale 
  z[atome]=$4*pdbscale}}
END {
 printf("HEADER    %s.pdb\n",dateiname)
 print "REMARK   1 Dieses File wurde automatisch mithilfe"
 print "REMARK   1 des AWK-scripts mol2pdb generiert."
 if (arg[1]!="") print "REMARK   1 Sourcefile:" arg[1] ".mol"
 print "REMARK   1 Es nutzt nur wenige Faehigkeiten"
 print "REMARK   1 des PDB-Formats aus."
 print "REMARK   2 This file has been generated by the"
 print "REMARK   2 AWK-script mol2pdb."
 if (arg[1]!="") print "REMARK   1 Sourcefile:" arg[1] ".mol"
 print "REMARK   2 It uses few features of the PDB format."
 for (i=1; i<=atome; i++) {
  printf("ATOM  %5d  %-3s      %4d    %-8.4f%-8.4f%-8.4f1.000 %6.4f\n",\
                  i, id[i],      1,     x[i], y[i], z[i],      1.0)}
 printf("END\n")}
