/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	scrlbar.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_scroll_bar class header
 *
 *	RCSid = "$Id: scrlbar.H,v 4.10.1.1 1993/06/01 22:56:32 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_scrlbar_H
#define OI_scrlbar_H

#ifndef OI_ctlr_1d_H
#include <OI/ctlr_1d.H>
#endif /* OI_ctlr_1d_H */

	class	OI_menu ;
	class	OI_menu_cell ;

#define OI_SCROLLBAR_TIMER		0x01		/* 1 => timer is currently active */

	// class forward reference declarations
	class OI_mdl_scroll_bar;

	class OI_scroll_bar : public OI_ctlr_1d {
			OI_mdl_scroll_bar	*mdl_dep ;		/* ptr to model dependent aspects */
			unsigned long		ctl_bits;			
	 protected:
			OI_orient		orient ;		/* orientation */
			OI_number		obj_pix ;		/* # pixels occupied by one unit of controlled object */
	 public:
		static	OI_class		*clsp ;			/* ptr to class record */

	 private:
			void			construct(OI_number, OI_orient) ;
			void			new_orientation(OI_orient) ;
			void			res_major_size( void * );
			void			res_orientation( void * );
			void			resize(OI_d_tech*,void*) ;
		friend	void			dmpOI_scroll_bar(OI_scroll_bar*) ;		/* diagnostic dump procedure */
	 protected:
						OI_scroll_bar(OI_class *clsp, const char *usr_namp, OI_number s, OI_orient or,
							OI_ctlr_1d_fnp fp=NULL, OI_callback *op=NULL, OI_ctlr_1d_memfnp mfp=NULL,
							void *ap=NULL) ;
		virtual	OI_stat			create() ;
		virtual	void			new_model(OI_model_type) ;
		virtual	void			paint(const XEvent*, void* =NULL) ;
		virtual	void			span_changed(long l) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_scroll_bar(const char*,OI_number,OI_orient,OI_ctlr_1d_fnp =NULL,OI_callback* =NULL,
							OI_ctlr_1d_memfnp =NULL,void* =NULL) ;
						~OI_scroll_bar() ;
			void			allow_timer()		{ ctl_bits |= OI_SCROLLBAR_TIMER; }
			void			disallow_timer()	{ ctl_bits &= ~OI_SCROLLBAR_TIMER; }
		virtual	void			disable() ;
		virtual	void			enable() ;
		static	OI_bool			init(OI_connection*) ;
			OI_bool			is_timer()		{ return ((ctl_bits&OI_SCROLLBAR_TIMER)?OI_YES:OI_NO); }
		static	OI_scroll_bar		*make_minimal(const char*,OI_minimal_type) ;
			void			menu_psn(OI_menu_cell*,void*,OI_number) ;	/* callback for popup for positioning */
			OI_number		minimum_major_size() ;
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
			OI_bool			mov_hdl(long) ;					/* move handle on display */
		virtual	OI_stat			new_size(OI_number,OI_number) ;			/* set size */
		virtual	void			nominal_outside_size(OI_number*,OI_number*);
			OI_number		obj_units()			{ return(obj_pix); }
		virtual	void			popup_child(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			OI_menu			*scrollbar_menu() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void			clone_adjust(OI_d_tech*) ;
		virtual	OI_number		num_props() ;
		virtual	OI_d_tech		*numbered_child(OI_number) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_number		major_size() ;
			OI_number		major_space() ;
			OI_number		minor_space() ;
			OI_orient		orientation()		{ return(orient); }
			void			set_orientation(OI_orient) ;
			OI_stat			set_major_size(OI_number) ;			/* set major axis size */
			OI_stat			set_view(long,OI_number=0) ;			/* set span of viewport (user units) */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			enter(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			increment_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			increment_left(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			increment_right(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			increment_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			leave(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			moved(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			page_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			page_left(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			page_right(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			page_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			release(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			select(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			top_or_bottom(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_scroll_bar	*oi_create_scroll_bar_cb(const char*, OI_number, OI_orient, OI_ctlr_1d_fnp, OI_callback*,
					OI_ctlr_1d_memfnp, void *) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_scroll_bar	*oi_create_scroll_bar(const char *name,OI_number len,OI_orient or,OI_ctlr_1d_fnp fp=NULL,void *argp=NULL) ;
		OI_scroll_bar	*oi_create_scroll_bar(const char *name,OI_number len,OI_orient or,OI_callback *objp,OI_ctlr_1d_memfnp mfp,
					void *argp=NULL) ;

#endif /* OI_scrlbar_H */
