/*
 * @(#)defs.h	1.5 91/09/05
 */

#include <sys/types.h>
#include <sys/time.h>
#define ptrace	xptrace	/* bad prototype in ptrace.h */
#include <sys/ptrace.h>
#undef ptrace

typedef struct tcb /* Trace Control Block */ {
	short	flags;
#define TCB_STARTUP	01
#define TCB_INUSE	02
#define TCB_INSYSCALL	04
#define TCB_ATTACHED	010
#define TCB_EXITING	020
#define TCB_SUSPENDED	040
#define TCB_BPTSET	0100
#define TCB_FOLLOWFORK	0200
#define entering(tcp)	(!((tcp)->flags & TCB_INSYSCALL))
#define exiting(tcp)	((tcp)->flags & TCB_INSYSCALL)
#define syserror(tcp)	((tcp)->u_error != 0)
#define waiting_parent(tcp) \
		(tcp->parent && \
		(tcp->parent->flags & TCB_SUSPENDED) && \
		(tcp->parent->waitpid <= 0 || tcp->parent->waitpid == tcp->pid))

	int	pid;		/* Process Id of this entry */
	int	scno;		/* System call number */
	int	u_args[8];	/* System call arguments */
	int	u_error;	/* Error code */
	int	u_rval;		/* (first) return value */
	FILE	*outf;		/* Output file for this process */
	char	*auxstr;	/* Auxiliary info from syscall (see RVAL_STR) */

	/* Support for tracing forked processes */
	struct	tcb *parent;	/* Parent of this process */
	int	nchildren;	/* # of traced children */
	int	waitpid;	/* pid(s) this process is waiting for */
				/* (1st arg of wait4()) */
	int	baddr;		/* `Breakpoint' address */
	int	inst[2];	/* Instructions on above */
	struct timeval tv;	/* Syscall entry time */
} Tcb;
#define NULLTCB		((struct tcb *)0)

typedef struct xlat {
	int	val;
	char	*str;
} Xlat;
extern char *xlookup();

#define MAX_PROCS	16
extern struct tcb tcbtab[];
extern struct tcb *alloctcb();

extern char *signals[];
extern int debug, followfork, brutal, tflag, dtime, cflag;
extern FILE *outf;
extern int Nproc;

extern void newoutf();
extern int syscall();
extern int printargs();
extern int addflags();
extern int printflags();
extern int umove();
extern int umovestr();
extern int printstr();
extern int printnum();

/*
 * sys_* return values
 */
#define RVAL_HEX	1	/* Print syscall return value in hex format */
#define RVAL_STR	2	/* Print `auxstr' field after return val */
#define RVAL_NONE	0200	/* Print nothing */

#define DFLT_STR_LEN	32	/* default maximum # of bytes printed in
				  `printstr', change with `-s' switch */

/* macro's */
#ifndef MAX
#define MAX(a,b)		(((a)>(b))?(a):(b))
#endif
#ifndef MIN
#define MIN(a,b)		(((a)<(b))?(a):(b))
#endif

/* get offset of field within a user struct */
#define uoff(field)	((char *)&(((struct user *)0)->field) - \
			(char *)(struct user *)0)
#define Xoff(X, field)	((char *)&(((struct X *)0)->field) - \
			(char *)(struct X *)0)
