/*
 * Copyright 2002-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package example.scannable;

import java.util.concurrent.Future;

import org.springframework.scheduling.annotation.Async;

/**
 * @author Mark Fisher
 * @author Juergen Hoeller
 */
public interface FooService {

	String foo(int id);

	@Async
	Future<String> asyncFoo(int id);

	boolean isInitCalled();

}
