/*
 * Decompiled with CFR 0.152.
 */
package Rijndael;

import Rijndael.Rijndael_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class Rijndael_Algorithm {
    static final String NAME = "Rijndael_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err;
    static final boolean TRACE;
    static final int BLOCK_SIZE = 16;
    static final int[] alog;
    static final int[] log;
    static final byte[] S;
    static final byte[] Si;
    static final int[] T1;
    static final int[] T2;
    static final int[] T3;
    static final int[] T4;
    static final int[] T5;
    static final int[] T6;
    static final int[] T7;
    static final int[] T8;
    static final int[] U1;
    static final int[] U2;
    static final int[] U3;
    static final int[] U4;
    static final byte[] rcon;
    static final int[][][] shifts;
    private static final char[] HEX_DIGITS;

    static void debug(String string) {
        ((PrintWriter)null).println(">>> Rijndael_Algorithm: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> Rijndael_Algorithm." + string);
        }
    }

    static final int mul(int n, int n2) {
        if (n != 0 && n2 != 0) {
            return alog[(log[n & 0xFF] + log[n2 & 0xFF]) % 255];
        }
        return 0;
    }

    static final int mul4(int n, byte[] byArray) {
        if (n == 0) {
            return 0;
        }
        n = log[n & 0xFF];
        int n2 = byArray[0] != 0 ? alog[(n + log[byArray[0] & 0xFF]) % 255] & 0xFF : 0;
        int n3 = byArray[1] != 0 ? alog[(n + log[byArray[1] & 0xFF]) % 255] & 0xFF : 0;
        int n4 = byArray[2] != 0 ? alog[(n + log[byArray[2] & 0xFF]) % 255] & 0xFF : 0;
        int n5 = byArray[3] != 0 ? alog[(n + log[byArray[3] & 0xFF]) % 255] & 0xFF : 0;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static Object makeKey(byte[] byArray) throws InvalidKeyException {
        return Rijndael_Algorithm.makeKey(byArray, 16);
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        int[][] nArray = (int[][])((Object[])object)[0];
        int n2 = nArray.length - 1;
        int[] nArray2 = nArray[0];
        int n3 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[0];
        int n4 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[1];
        int n5 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[2];
        int n6 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[3];
        int n7 = 1;
        while (n7 < n2) {
            nArray2 = nArray[n7];
            int n8 = T1[n3 >>> 24 & 0xFF] ^ T2[n4 >>> 16 & 0xFF] ^ T3[n5 >>> 8 & 0xFF] ^ T4[n6 & 0xFF] ^ nArray2[0];
            int n9 = T1[n4 >>> 24 & 0xFF] ^ T2[n5 >>> 16 & 0xFF] ^ T3[n6 >>> 8 & 0xFF] ^ T4[n3 & 0xFF] ^ nArray2[1];
            int n10 = T1[n5 >>> 24 & 0xFF] ^ T2[n6 >>> 16 & 0xFF] ^ T3[n3 >>> 8 & 0xFF] ^ T4[n4 & 0xFF] ^ nArray2[2];
            int n11 = T1[n6 >>> 24 & 0xFF] ^ T2[n3 >>> 16 & 0xFF] ^ T3[n4 >>> 8 & 0xFF] ^ T4[n5 & 0xFF] ^ nArray2[3];
            n3 = n8;
            n4 = n9;
            n5 = n10;
            n6 = n11;
            ++n7;
        }
        byte[] byArray2 = new byte[16];
        nArray2 = nArray[n2];
        int n12 = nArray2[0];
        byArray2[0] = (byte)(S[n3 >>> 24 & 0xFF] ^ n12 >>> 24);
        byArray2[1] = (byte)(S[n4 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[2] = (byte)(S[n5 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[3] = (byte)(S[n6 & 0xFF] ^ n12);
        n12 = nArray2[1];
        byArray2[4] = (byte)(S[n4 >>> 24 & 0xFF] ^ n12 >>> 24);
        byArray2[5] = (byte)(S[n5 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[6] = (byte)(S[n6 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[7] = (byte)(S[n3 & 0xFF] ^ n12);
        n12 = nArray2[2];
        byArray2[8] = (byte)(S[n5 >>> 24 & 0xFF] ^ n12 >>> 24);
        byArray2[9] = (byte)(S[n6 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[10] = (byte)(S[n3 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[11] = (byte)(S[n4 & 0xFF] ^ n12);
        n12 = nArray2[3];
        byArray2[12] = (byte)(S[n6 >>> 24 & 0xFF] ^ n12 >>> 24);
        byArray2[13] = (byte)(S[n3 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[14] = (byte)(S[n4 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[15] = (byte)(S[n5 & 0xFF] ^ n12);
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        int[][] nArray = (int[][])((Object[])object)[1];
        int n2 = nArray.length - 1;
        int[] nArray2 = nArray[0];
        int n3 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[0];
        int n4 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[1];
        int n5 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[2];
        int n6 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[3];
        int n7 = 1;
        while (n7 < n2) {
            nArray2 = nArray[n7];
            int n8 = T5[n3 >>> 24 & 0xFF] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ nArray2[0];
            int n9 = T5[n4 >>> 24 & 0xFF] ^ T6[n3 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ nArray2[1];
            int n10 = T5[n5 >>> 24 & 0xFF] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n3 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ nArray2[2];
            int n11 = T5[n6 >>> 24 & 0xFF] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n3 & 0xFF] ^ nArray2[3];
            n3 = n8;
            n4 = n9;
            n5 = n10;
            n6 = n11;
            ++n7;
        }
        byte[] byArray2 = new byte[16];
        nArray2 = nArray[n2];
        int n12 = nArray2[0];
        byArray2[0] = (byte)(Si[n3 >>> 24 & 0xFF] ^ n12 >>> 24);
        byArray2[1] = (byte)(Si[n6 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[2] = (byte)(Si[n5 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[3] = (byte)(Si[n4 & 0xFF] ^ n12);
        n12 = nArray2[1];
        byArray2[4] = (byte)(Si[n4 >>> 24 & 0xFF] ^ n12 >>> 24);
        byArray2[5] = (byte)(Si[n3 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[6] = (byte)(Si[n6 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[7] = (byte)(Si[n5 & 0xFF] ^ n12);
        n12 = nArray2[2];
        byArray2[8] = (byte)(Si[n5 >>> 24 & 0xFF] ^ n12 >>> 24);
        byArray2[9] = (byte)(Si[n4 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[10] = (byte)(Si[n3 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[11] = (byte)(Si[n6 & 0xFF] ^ n12);
        n12 = nArray2[3];
        byArray2[12] = (byte)(Si[n6 >>> 24 & 0xFF] ^ n12 >>> 24);
        byArray2[13] = (byte)(Si[n5 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[14] = (byte)(Si[n4 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[15] = (byte)(Si[n3 & 0xFF] ^ n12);
        return byArray2;
    }

    public static boolean self_test() {
        return Rijndael_Algorithm.self_test(16);
    }

    public static int blockSize() {
        return 16;
    }

    public static synchronized Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        int n2;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        int n3 = Rijndael_Algorithm.getRounds(byArray.length, n);
        int n4 = n / 4;
        int[][] nArray = new int[n3 + 1][n4];
        int[][] nArray2 = new int[n3 + 1][n4];
        int n5 = (n3 + 1) * n4;
        int n6 = byArray.length / 4;
        int[] nArray3 = new int[n6];
        int n7 = 0;
        int n8 = 0;
        while (n7 < n6) {
            nArray3[n7++] = (byArray[n8++] & 0xFF) << 24 | (byArray[n8++] & 0xFF) << 16 | (byArray[n8++] & 0xFF) << 8 | byArray[n8++] & 0xFF;
        }
        int n9 = 0;
        n8 = 0;
        while (n8 < n6 && n9 < n5) {
            nArray[n9 / n4][n9 % n4] = nArray3[n8];
            nArray2[n3 - n9 / n4][n9 % n4] = nArray3[n8];
            ++n8;
            ++n9;
        }
        int n10 = 0;
        while (n9 < n5) {
            n2 = nArray3[n6 - 1];
            nArray3[0] = nArray3[0] ^ ((S[n2 >>> 16 & 0xFF] & 0xFF) << 24 ^ (S[n2 >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n2 & 0xFF] & 0xFF) << 8 ^ S[n2 >>> 24 & 0xFF] & 0xFF ^ (rcon[n10++] & 0xFF) << 24);
            if (n6 != 8) {
                n7 = 1;
                n8 = 0;
                while (n7 < n6) {
                    int n11 = n7++;
                    nArray3[n11] = nArray3[n11] ^ nArray3[n8++];
                }
            } else {
                n7 = 1;
                n8 = 0;
                while (n7 < n6 / 2) {
                    int n12 = n7++;
                    nArray3[n12] = nArray3[n12] ^ nArray3[n8++];
                }
                n2 = nArray3[n6 / 2 - 1];
                int n13 = n6 / 2;
                nArray3[n13] = nArray3[n13] ^ (S[n2 & 0xFF] & 0xFF ^ (S[n2 >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n2 >>> 16 & 0xFF] & 0xFF) << 16 ^ (S[n2 >>> 24 & 0xFF] & 0xFF) << 24);
                n8 = n6 / 2;
                n7 = n8 + 1;
                while (n7 < n6) {
                    int n14 = n7++;
                    nArray3[n14] = nArray3[n14] ^ nArray3[n8++];
                }
            }
            n8 = 0;
            while (n8 < n6 && n9 < n5) {
                nArray[n9 / n4][n9 % n4] = nArray3[n8];
                nArray2[n3 - n9 / n4][n9 % n4] = nArray3[n8];
                ++n8;
                ++n9;
            }
        }
        int n15 = 1;
        while (n15 < n3) {
            n8 = 0;
            while (n8 < n4) {
                n2 = nArray2[n15][n8];
                nArray2[n15][n8] = U1[n2 >>> 24 & 0xFF] ^ U2[n2 >>> 16 & 0xFF] ^ U3[n2 >>> 8 & 0xFF] ^ U4[n2 & 0xFF];
                ++n8;
            }
            ++n15;
        }
        Object[] objectArray = new Object[]{nArray, nArray2};
        return objectArray;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object, int n2) {
        if (n2 == 16) {
            return Rijndael_Algorithm.blockEncrypt(byArray, n, object);
        }
        Object[] objectArray = (Object[])object;
        int[][] nArray = (int[][])objectArray[0];
        int n3 = n2 / 4;
        int n4 = nArray.length - 1;
        int n5 = n3 == 4 ? 0 : (n3 == 6 ? 1 : 2);
        int n6 = shifts[n5][1][0];
        int n7 = shifts[n5][2][0];
        int n8 = shifts[n5][3][0];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        byte[] byArray2 = new byte[n2];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n3) {
            nArray3[n10] = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][n10];
            ++n10;
        }
        int n11 = 1;
        while (n11 < n4) {
            n10 = 0;
            while (n10 < n3) {
                nArray2[n10] = T1[nArray3[n10] >>> 24 & 0xFF] ^ T2[nArray3[(n10 + n6) % n3] >>> 16 & 0xFF] ^ T3[nArray3[(n10 + n7) % n3] >>> 8 & 0xFF] ^ T4[nArray3[(n10 + n8) % n3] & 0xFF] ^ nArray[n11][n10];
                ++n10;
            }
            System.arraycopy(nArray2, 0, nArray3, 0, n3);
            ++n11;
        }
        n10 = 0;
        while (n10 < n3) {
            int n12 = nArray[n4][n10];
            byArray2[n9++] = (byte)(S[nArray3[n10] >>> 24 & 0xFF] ^ n12 >>> 24);
            byArray2[n9++] = (byte)(S[nArray3[(n10 + n6) % n3] >>> 16 & 0xFF] ^ n12 >>> 16);
            byArray2[n9++] = (byte)(S[nArray3[(n10 + n7) % n3] >>> 8 & 0xFF] ^ n12 >>> 8);
            byArray2[n9++] = (byte)(S[nArray3[(n10 + n8) % n3] & 0xFF] ^ n12);
            ++n10;
        }
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object, int n2) {
        if (n2 == 16) {
            return Rijndael_Algorithm.blockDecrypt(byArray, n, object);
        }
        Object[] objectArray = (Object[])object;
        int[][] nArray = (int[][])objectArray[1];
        int n3 = n2 / 4;
        int n4 = nArray.length - 1;
        int n5 = n3 == 4 ? 0 : (n3 == 6 ? 1 : 2);
        int n6 = shifts[n5][1][1];
        int n7 = shifts[n5][2][1];
        int n8 = shifts[n5][3][1];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        byte[] byArray2 = new byte[n2];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n3) {
            nArray3[n10] = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][n10];
            ++n10;
        }
        int n11 = 1;
        while (n11 < n4) {
            n10 = 0;
            while (n10 < n3) {
                nArray2[n10] = T5[nArray3[n10] >>> 24 & 0xFF] ^ T6[nArray3[(n10 + n6) % n3] >>> 16 & 0xFF] ^ T7[nArray3[(n10 + n7) % n3] >>> 8 & 0xFF] ^ T8[nArray3[(n10 + n8) % n3] & 0xFF] ^ nArray[n11][n10];
                ++n10;
            }
            System.arraycopy(nArray2, 0, nArray3, 0, n3);
            ++n11;
        }
        n10 = 0;
        while (n10 < n3) {
            int n12 = nArray[n4][n10];
            byArray2[n9++] = (byte)(Si[nArray3[n10] >>> 24 & 0xFF] ^ n12 >>> 24);
            byArray2[n9++] = (byte)(Si[nArray3[(n10 + n6) % n3] >>> 16 & 0xFF] ^ n12 >>> 16);
            byArray2[n9++] = (byte)(Si[nArray3[(n10 + n7) % n3] >>> 8 & 0xFF] ^ n12 >>> 8);
            byArray2[n9++] = (byte)(Si[nArray3[(n10 + n8) % n3] & 0xFF] ^ n12);
            ++n10;
        }
        return byArray2;
    }

    private static boolean self_test(int n) {
        boolean bl = false;
        try {
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[16];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)n2;
                ++n2;
            }
            n2 = 0;
            while (n2 < 16) {
                byArray2[n2] = (byte)n2;
                ++n2;
            }
            Object object = Rijndael_Algorithm.makeKey(byArray, 16);
            byte[] byArray3 = Rijndael_Algorithm.blockEncrypt(byArray2, 0, object, 16);
            byte[] byArray4 = Rijndael_Algorithm.blockDecrypt(byArray3, 0, object, 16);
            bl = Rijndael_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static int getRounds(int n, int n2) {
        switch (n) {
            case 16: {
                if (n2 == 16) {
                    return 10;
                }
                if (n2 == 24) {
                    return 12;
                }
                return 14;
            }
            case 24: {
                if (n2 != 32) {
                    return 12;
                }
                return 14;
            }
        }
        return 14;
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String byteToString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(cArray);
    }

    private static String intToString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    private static String toString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = nArray[n2];
            cArray[n3++] = HEX_DIGITS[n4 >>> 28 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 24 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 20 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 16 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 12 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 8 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 & 0xF];
            ++n2;
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        Rijndael_Algorithm.self_test(16);
        Rijndael_Algorithm.self_test(24);
        Rijndael_Algorithm.self_test(32);
    }

    static {
        int n;
        err = null;
        TRACE = Rijndael_Properties.isTraceable(NAME);
        alog = new int[256];
        log = new int[256];
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        shifts = new int[][][]{new int[][]{new int[2], {1, 3}, {2, 2}, {3, 1}}, new int[][]{new int[2], {1, 5}, {2, 4}, {3, 3}}, new int[][]{new int[2], {1, 7}, {3, 5}, {4, 4}}};
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        long l = System.currentTimeMillis();
        int n2 = 0;
        Rijndael_Algorithm.alog[0] = 1;
        int n3 = 1;
        while (n3 < 256) {
            n2 = alog[n3 - 1] << 1 ^ alog[n3 - 1];
            if ((n2 & 0x100) != 0) {
                n2 ^= 0x11B;
            }
            Rijndael_Algorithm.alog[n3] = n2;
            ++n3;
        }
        n3 = 1;
        while (n3 < 255) {
            Rijndael_Algorithm.log[Rijndael_Algorithm.alog[n3]] = n3;
            ++n3;
        }
        byte[][] byArrayArray = new byte[8][];
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[1] = 1;
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[4] = 1;
        byArray2[5] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[4] = 1;
        byArray3[5] = 1;
        byArray3[6] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[3] = 1;
        byArray4[4] = 1;
        byArray4[5] = 1;
        byArray4[6] = 1;
        byArray4[7] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[0] = 1;
        byArray5[4] = 1;
        byArray5[5] = 1;
        byArray5[6] = 1;
        byArray5[7] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[8];
        byArray6[0] = 1;
        byArray6[1] = 1;
        byArray6[5] = 1;
        byArray6[6] = 1;
        byArray6[7] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[8];
        byArray7[0] = 1;
        byArray7[1] = 1;
        byArray7[2] = 1;
        byArray7[6] = 1;
        byArray7[7] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[8];
        byArray8[0] = 1;
        byArray8[1] = 1;
        byArray8[2] = 1;
        byArray8[3] = 1;
        byArray8[7] = 1;
        byArrayArray[7] = byArray8;
        byte[][] byArrayArray2 = byArrayArray;
        byte[] byArray9 = new byte[8];
        byArray9[1] = 1;
        byArray9[2] = 1;
        byArray9[6] = 1;
        byArray9[7] = 1;
        byte[] byArray10 = byArray9;
        byte[][] byArray11 = new byte[256][8];
        byArray11[1][7] = 1;
        n3 = 2;
        while (n3 < 256) {
            n2 = alog[255 - log[n3]];
            n = 0;
            while (n < 8) {
                byArray11[n3][n] = (byte)(n2 >>> 7 - n & 1);
                ++n;
            }
            ++n3;
        }
        byte[][] byArray12 = new byte[256][8];
        n3 = 0;
        while (n3 < 256) {
            n = 0;
            while (n < 8) {
                byArray12[n3][n] = byArray10[n];
                n2 = 0;
                while (n2 < 8) {
                    byte[] byArray13 = byArray12[n3];
                    int n4 = n;
                    byArray13[n4] = (byte)(byArray13[n4] ^ byArrayArray2[n][n2] * byArray11[n3][n2]);
                    ++n2;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 256) {
            Rijndael_Algorithm.S[n3] = (byte)(byArray12[n3][0] << 7);
            n = 1;
            while (n < 8) {
                int n5 = n3;
                S[n5] = (byte)(S[n5] ^ byArray12[n3][n] << 7 - n);
                ++n;
            }
            Rijndael_Algorithm.Si[Rijndael_Algorithm.S[n3] & 0xFF] = (byte)n3;
            ++n3;
        }
        byte[][] byArrayArray3 = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] byArray14 = new byte[4][8];
        n3 = 0;
        while (n3 < 4) {
            n2 = 0;
            while (n2 < 4) {
                byArray14[n3][n2] = byArrayArray3[n3][n2];
                ++n2;
            }
            byArray14[n3][n3 + 4] = 1;
            ++n3;
        }
        byte[][] byArray15 = new byte[4][4];
        n3 = 0;
        while (n3 < 4) {
            byte by = byArray14[n3][n3];
            if (by == 0) {
                n = n3 + 1;
                while (byArray14[n][n3] == 0 && n < 4) {
                    ++n;
                }
                if (n == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                n2 = 0;
                while (n2 < 8) {
                    byte by2 = byArray14[n3][n2];
                    byArray14[n3][n2] = byArray14[n][n2];
                    byArray14[n][n2] = by2;
                    ++n2;
                }
                by = byArray14[n3][n3];
            }
            n2 = 0;
            while (n2 < 8) {
                if (byArray14[n3][n2] != 0) {
                    byArray14[n3][n2] = (byte)alog[(255 + log[byArray14[n3][n2] & 0xFF] - log[by & 0xFF]) % 255];
                }
                ++n2;
            }
            n = 0;
            while (n < 4) {
                if (n3 != n) {
                    n2 = n3 + 1;
                    while (n2 < 8) {
                        byte[] byArray16 = byArray14[n];
                        int n6 = n2;
                        byArray16[n6] = (byte)(byArray16[n6] ^ Rijndael_Algorithm.mul(byArray14[n3][n2], byArray14[n][n3]));
                        ++n2;
                    }
                    byArray14[n][n3] = 0;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 4) {
            n2 = 0;
            while (n2 < 4) {
                byArray15[n3][n2] = byArray14[n3][n2 + 4];
                ++n2;
            }
            ++n3;
        }
        n = 0;
        while (n < 256) {
            byte by = S[n];
            Rijndael_Algorithm.T1[n] = Rijndael_Algorithm.mul4(by, byArrayArray3[0]);
            Rijndael_Algorithm.T2[n] = Rijndael_Algorithm.mul4(by, byArrayArray3[1]);
            Rijndael_Algorithm.T3[n] = Rijndael_Algorithm.mul4(by, byArrayArray3[2]);
            Rijndael_Algorithm.T4[n] = Rijndael_Algorithm.mul4(by, byArrayArray3[3]);
            by = Si[n];
            Rijndael_Algorithm.T5[n] = Rijndael_Algorithm.mul4(by, byArray15[0]);
            Rijndael_Algorithm.T6[n] = Rijndael_Algorithm.mul4(by, byArray15[1]);
            Rijndael_Algorithm.T7[n] = Rijndael_Algorithm.mul4(by, byArray15[2]);
            Rijndael_Algorithm.T8[n] = Rijndael_Algorithm.mul4(by, byArray15[3]);
            Rijndael_Algorithm.U1[n] = Rijndael_Algorithm.mul4(n, byArray15[0]);
            Rijndael_Algorithm.U2[n] = Rijndael_Algorithm.mul4(n, byArray15[1]);
            Rijndael_Algorithm.U3[n] = Rijndael_Algorithm.mul4(n, byArray15[2]);
            Rijndael_Algorithm.U4[n] = Rijndael_Algorithm.mul4(n, byArray15[3]);
            ++n;
        }
        Rijndael_Algorithm.rcon[0] = 1;
        int n7 = 1;
        n = 1;
        while (n < 30) {
            int n8 = n++;
            n7 = Rijndael_Algorithm.mul(2, n7);
            Rijndael_Algorithm.rcon[n8] = (byte)n7;
        }
        l = System.currentTimeMillis() - l;
    }
}

