/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.math.BigInteger;
import cryptix.math.MPI;
import cryptix.math.RandomStream;
import cryptix.pgp.FormatException;
import cryptix.pgp.HashFactory;
import cryptix.pgp.KeyID;
import cryptix.pgp.Packet;
import cryptix.security.MD5;
import cryptix.security.MessageHash;
import cryptix.security.rsa.PublicKey;
import cryptix.security.rsa.SecretKey;
import cryptix.util.core.Hex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class Signature
extends Packet {
    private static final boolean DEBUG = false;
    public static final int BINARY_IMAGE = 0;
    public static final int CANONICAL_TEXT = 1;
    public static final int KEY_CERT_GENERIC = 16;
    public static final int KEY_CERT_PERSONA = 17;
    public static final int KEY_CERT_CASUAL_ID = 18;
    public static final int KEY_CERT_POSITIVE_ID = 19;
    public static final int KEY_COMPROMISE_CERTIFICATE = 32;
    public static final int USER_ID_REVOCATION_CERTIFICATE = 48;
    public static final int TIMESTAMP_CERTIFICATE = 64;
    private BigInteger number;
    private byte[] extra;
    private byte[] keyId;
    private int pkeAlgorithm = 1;
    private int hashAlgorithm = 1;
    private byte[] hashId;

    public Signature(SecretKey secretKey, MD5 mD5) {
        this(secretKey, mD5, null);
    }

    public Signature(SecretKey secretKey, MD5 mD5, RandomStream randomStream) {
        int n = (int)(System.currentTimeMillis() / 1000L);
        this.extra = new byte[5];
        this.extra[0] = 0;
        this.extra[1] = (byte)(n >>> 24 & 0xFF);
        this.extra[2] = (byte)(n >>> 16 & 0xFF);
        this.extra[3] = (byte)(n >>> 8 & 0xFF);
        this.extra[4] = (byte)(n & 0xFF);
        mD5.add(this.extra);
        byte[] byArray = mD5.digest();
        BigInteger bigInteger = HashFactory.bigIntFromHash((PublicKey)secretKey, byArray, randomStream);
        this.number = secretKey.decrypt(bigInteger);
        this.hashId = new byte[2];
        this.hashId[0] = byArray[0];
        this.hashId[1] = byArray[1];
        this.keyId = secretKey.id();
    }

    public Signature(DataInput dataInput, int n) throws IOException {
        super(dataInput, n);
    }

    public void read(DataInput dataInput, int n) throws IOException {
        dataInput.readByte();
        int n2 = dataInput.readByte() & 0xFF;
        if (n2 != 5 && n2 != 7) {
            throw new FormatException("The length of the extra data field is incorrect.");
        }
        this.extra = new byte[n2];
        dataInput.readFully(this.extra);
        this.keyId = new byte[8];
        dataInput.readFully(this.keyId);
        this.pkeAlgorithm = dataInput.readByte();
        this.hashAlgorithm = dataInput.readByte();
        this.hashId = new byte[2];
        dataInput.readFully(this.hashId);
        this.number = MPI.read((DataInput)dataInput);
    }

    public int write(DataOutput dataOutput) throws IOException {
        dataOutput.write(2);
        dataOutput.write(this.extra.length);
        dataOutput.write(this.extra);
        dataOutput.write(this.keyId);
        dataOutput.write(this.pkeAlgorithm);
        dataOutput.write(this.hashAlgorithm);
        dataOutput.write(this.hashId);
        byte[] byArray = MPI.save((BigInteger)this.number);
        dataOutput.write(byArray);
        return this.extra.length + byArray.length + 14;
    }

    public String typeString() {
        switch (this.extra[0]) {
            case 0: {
                return "Binary image";
            }
            case 1: {
                return "Text image";
            }
            case 16: {
                return "Key cert";
            }
            case 17: {
                return "Key certificate anon";
            }
            case 18: {
                return "Key certificate casual";
            }
            case 19: {
                return "Key certificate heavy duty";
            }
            case 32: {
                return "Key compromise certificate";
            }
            case 48: {
                return "User ID revocation certificate";
            }
            case 64: {
                return "Time stamp certificate";
            }
        }
        return "unknown type (" + this.extra[0] + ")";
    }

    public String toString() {
        return "Signature packet " + this.typeString() + " key id : " + Hex.toString((byte[])this.keyId);
    }

    private boolean check(PublicKey publicKey, byte[] byArray) {
        if (byArray[0] != this.hashId[0] || byArray[1] != this.hashId[1]) {
            return false;
        }
        byte[] byArray2 = publicKey.id();
        int n = byArray2.length;
        if (n == this.keyId.length) {
            int n2 = 0;
            while (n2 < n) {
                if (byArray2[n2] != this.keyId[n2]) {
                    return false;
                }
                ++n2;
            }
        }
        BigInteger bigInteger = publicKey.encrypt(this.number);
        BigInteger bigInteger2 = HashFactory.bigIntFromHash(publicKey, byArray);
        return bigInteger.equals((Object)bigInteger2);
    }

    public boolean check(PublicKey publicKey, MD5 mD5) {
        mD5.add(this.extra);
        return this.check(publicKey, mD5.digest());
    }

    public boolean verify(PublicKey publicKey, byte[] byArray) {
        MD5 mD5 = new MD5();
        mD5.add(byArray);
        mD5.add(this.extra);
        return this.check(publicKey, mD5.digest());
    }

    public byte[] checkAndGetHash(PublicKey publicKey, MD5 mD5) {
        mD5.add(this.extra);
        byte[] byArray = mD5.digest();
        if (!this.check(publicKey, byArray)) {
            return null;
        }
        return byArray;
    }

    public void addExtasToHash(MD5 mD5) {
        mD5.add(this.extra);
    }

    public int getSignatureType() {
        return this.extra[0];
    }

    public boolean check(PublicKey publicKey, MessageHash messageHash) {
        return this.check(publicKey, messageHash.toByteArray());
    }

    public byte[] keyId() {
        int n = this.keyId.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.keyId, 0, byArray, 0, n);
        return byArray;
    }

    public KeyID getKeyId() {
        return new KeyID(this.keyId);
    }

    public int getType() {
        return 2;
    }
}

