/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.mime.LegacyString;
import cryptix.pgp.ArmouredMessage;
import cryptix.pgp.CRC;
import cryptix.pgp.FormatException;
import cryptix.pgp.InvalidChecksumException;
import cryptix.pgp.Packet;
import cryptix.pgp.PublicKeyCertificate;
import cryptix.pgp.SecretKeyCertificate;
import cryptix.pgp.Signature;
import cryptix.security.Cryptix;
import cryptix.util.mime.Base64;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class Armoury {
    private static Base64 base64 = new Base64();
    public static final String LINEFEED = "\r\n";

    private Armoury() {
    }

    public static String messageWithChecksum(byte[] byArray) {
        byte[] byArray2 = new byte[3];
        int n = CRC.checksum(byArray);
        byArray2[0] = (byte)(n >>> 16);
        byArray2[1] = (byte)(n >>> 8);
        byArray2[2] = (byte)n;
        return String.valueOf(base64.encode(byArray)) + "=" + base64.encode(byArray2);
    }

    public static void message(PrintStream printStream, String string, byte[] byArray) {
        printStream.println("-----BEGIN PGP " + string + "-----");
        printStream.println("Version: " + Cryptix.getVersionString());
        printStream.println();
        printStream.print(Armoury.messageWithChecksum(byArray));
        printStream.println("-----END PGP " + string + "-----");
    }

    public static String message(String string, byte[] byArray) {
        String string2 = "-----BEGIN PGP " + string + "-----" + LINEFEED + "Version: " + Cryptix.getVersionString() + LINEFEED + LINEFEED + Armoury.messageWithChecksum(byArray) + "-----END PGP " + string + "-----" + LINEFEED;
        return string2;
    }

    public static void message(PrintStream printStream, Packet packet) throws IOException {
        Armoury.message(printStream, Armoury.name(packet), packet.save());
    }

    public static byte[] strip(String string) throws FormatException, IOException, InvalidChecksumException {
        int n;
        int n2 = string.indexOf("-----BEGIN PGP");
        if (n2 == -1) {
            throw new FormatException("Couldn't find PGP part in message.");
        }
        n2 = string.indexOf("\r\n\r\n", n2);
        int n3 = n2 + 4;
        n2 = string.indexOf("\r\n=");
        String string2 = string.substring(n3, n2);
        String string3 = string.substring(n2 + 2, n2 + 7);
        int n4 = Armoury.decodeChecksum(string3);
        if (n4 != (n = CRC.checksum(base64.decode(string2)))) {
            throw new InvalidChecksumException("Message checksum wrong.");
        }
        return base64.decode(ArmouredMessage.byteEncode(string2));
    }

    public static String name(Packet packet) {
        if (packet instanceof Signature) {
            return "SIGNATURE";
        }
        if (packet instanceof SecretKeyCertificate) {
            return "SECRET KEY BLOCK";
        }
        if (packet instanceof PublicKeyCertificate) {
            return "PUBLIC KEY BLOCK";
        }
        throw new IllegalArgumentException("PGP Packet type " + packet.getClass().getName() + " not valid for this method");
    }

    public static void readUntilBegin(DataInputStream dataInputStream) throws IOException {
        String string;
        while (!(string = dataInputStream.readLine()).startsWith("-----BEGIN PGP")) {
        }
        while (!(string = dataInputStream.readLine()).equals("")) {
        }
    }

    public static int decodeChecksum(String string) {
        string.length();
        byte[] byArray = LegacyString.toByteArray((String)string, (int)1, (int)4);
        byte[] byArray2 = base64.decode(byArray);
        int n = (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
        return n;
    }
}

