/*
 * irc.h: header file for all of ircII! 
 *
 * Written By Michael Sandrof
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 */

#ifndef _IRC_H_
#define _IRC_H_

#define IRCII_COMMENT   "Are we there yet ?"

#define IRCRC_NAME "/.ircrc"

/*
 * Here you can set the in-line quote character, normally backslash, to
 * whatever you want.  Note that we use two backslashes since a backslash is
 * also C's quote character.  You do not need two of any other character.
 */
#define QUOTE_CHAR '\\'

#undef DEBUG

#include "config.h"
#include <sys/types.h>

/* these define what characters do, inverse, underline, bold and all off */
#ifdef OLD_LAME_STYLE
# define REV_TOG	'\002'
# define UND_TOG	'\026'
# define BOLD_TOG	'\037'
# define ALL_OFF	'\017'
#endif
# define REV_TOG	'\026'		/* ^V */
# define UND_TOG	'\037'		/* ^_ */
# define BOLD_TOG	'\002'		/* ^B */
# define ALL_OFF	'\017'		/* ^O */

#define IRCD_BUFFER_SIZE 1024
#define BIG_BUFFER_SIZE (IRCD_BUFFER_SIZE * 2)
#define INPUT_BUFFER_SIZE (IRCD_BUFFER_SIZE / 4)

#define DAEMON_UID 1

#ifdef TRUE
# undef TRUE
#endif /*TRUE*/
#define TRUE 1

#ifdef FALSE
# undef FALSE
#endif /*FALSE*/
#define FALSE 0

#define NICKNAME_LEN 9
#define NAME_LEN 80
#define REALNAME_LEN 50
#define PATH_LEN 1024

#ifdef _IBMR2
# include <sys/select.h>
#endif

/* stolen from ircd ;) */
#ifdef        __alpha
#define       Long    int
#define       U_Long  u_int
#else
#define       Long    long
#define       U_Long  u_long
#endif

/* stuff that exists on 4.3 machines, so I stuck it in here */
#ifndef NBBY
# define NBBY	8		/* number of bits in a byte */
#endif /*NBBY*/

#ifndef NFDBITS
# define NFDBITS	(sizeof(long) * NBBY)	/* bits per mask */
#endif /*NFDBITS*/

#ifndef FD_SET
# define FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#endif /*FD_SET*/

#ifndef FD_CLR
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#endif /*FD_CLR*/

#ifndef FD_ISSET
# define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#endif /*FD_ISSET*/

#ifndef FD_ZERO
# define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif /*FD_ZERO*/

#ifndef	FD_SETSIZE
# define FD_SETSIZE	32
#endif

#define null(type) ((type) 0L)

#if defined(__hpux) || defined(hpux)
# ifndef HPUX
#  define HPUX
# endif
# ifndef HPUX70
#  define killpg(pgrp,sig) kill(-pgrp,sig)
#  define getwd(b) getcwd(b, PATH_LEN+1)
# endif
#endif

#ifdef SVR4
# define getwd(b) getcwd(b, PATH_LEN+1)
# define bcopy(a,b,c) memmove(b,a,c)
# define bzero(a,b) memset(a,0,b)
#endif

#if defined(POSIX) || defined(SOLARIS) || defined (HPUX70) || defined(SVR4)
# include "string.h"
#else
# include "strings.h"
#endif /* POSIX */

#ifdef _IBMR2
# include <sys/errno.h>
#else
# if defined(ISC22) || defined(SVR4)
extern	char	*strchr();
extern	char	*strrchr();
#  define index strchr
#  define rindex strrchr
# else
#  ifndef index
extern	char	*index();
#  endif
#  ifndef rindex
extern	char	*rindex();
#  endif
# endif
extern	int	errno;
#endif
extern	char	*sys_errlist[];
extern	char	*getenv();
extern	char	*ctime();

/* Base type for signal() functions */
#ifdef __STRICT_BSD__
# define SIGTYP int
#else
# define SIGTYP void
#endif

/*
 * Fix for Sun SPARC and gcc v1.xx.xx: structure arguments seem to be passed
 * by reference with cc!!
 */
#if defined(sparc) && defined(__GNUC__) && !defined(SOLARIS)
# define INetNtoA(structure) inet_ntoa(&(structure))
#else
# define INetNtoA(structure) inet_ntoa(structure)
#endif

/* flags used by who() and whoreply() for who_mask */
#define WHO_OPS 1
#define WHO_NAME 2
#define WHO_ZERO 4
#define WHO_CHOPS 8
#define WHO_FILE 16
#define WHO_HOST 32
#define WHO_SERVER 64
#define	WHO_HERE 128
#define	WHO_AWAY 256
#define	WHO_NICK 512
#define	WHO_LUSERS 1024
#define	WHO_REAL 2048

/* Define ZSUFFIX in case we are using ZCAT */
#ifdef ZCAT
# define ZSUFFIX ".Z"
#endif

/*
 (* Some defines in case we're using IRCII setuid->root, so that we can bind
 * to privileged ports. This will allow future IRC nets to verify the true
 * identity of users much more reliably.
 */
#ifdef PRIV_PORT
#define open ruid_open
#define fopen ruid_fopen
#define system ruid_system
#define unlink ruid_unlink
#define stat_file ruid_stat
#ifdef EOF	/* defined if stdio.h has been included */
extern FILE *ruid_fopen();
#endif /*EOF*/
extern int ruid_open();
extern int ruid_system();
extern int ruid_unlink();
#else
#define stat_file stat
#endif /*PRIV_PORT*/

/*
 * declared in irc.c 
 */
extern	char	*cut_buffer;
extern	char	oper_command;
extern	int	irc_port;
extern	int	send_text_flag;
extern	int	irc_io_loop;
extern	int	break_io_processing;
extern	int	use_flow_control;
extern	char	*joined_nick;
extern	char	*public_nick;
extern	char	empty_string[];

extern	char	irc_version[];
extern	char	internal_version[];
extern	char	buffer[];
extern	char	nickname[];
extern	char	*ircrc_file;
extern	char	hostname[];
extern	char	realname[];
extern	char	username[];
extern	char	*send_umode;
extern	char	*last_notify_nick;
extern	int	away_set;
extern	int	background;
extern	char	*my_path;
extern	char	*irc_path;
extern	char	*irc_lib;
extern	char	*args_str;
extern	char	*invite_channel;
extern	int	who_mask;
extern	char	*who_name;
extern	char	*who_host;
extern	char	*who_server;
extern	char	*who_file;
extern	char	*who_nick;
extern	char	*who_real;
extern	char	*cannot_open;
extern	char	global_all_off[];
extern	int	dumb;
extern	int	use_input;
extern	Long	idle_time;
extern	int	waiting;
extern	char	wait_nick[];
extern	char	whois_nick[];
extern	char	lame_wait_nick[];
extern	char	**environ;
extern	int	current_numeric;
extern	int	new_select();

extern	int	irc_io();
extern	int	dgets();
extern	void	help();
extern	char	*current_channel();
extern	void	new_stty();
extern	int	wild_match();
extern	char	*new_malloc();
extern	void	do_server();
extern	char	*get_server_nickname();
extern  int     connect_by_number();
extern	int	is_channel();
extern	void	irc_exit();
extern	void	new_close();
extern	void	beep_em();

typedef	struct	WhoisStuffStru
{
	char	*nick;
	char	*user;
	char	*host;
	char	*channel;
	char	*channels;
	char	*name;
	char	*server;
	char	*server_stuff;
	char	*away;
	int	oper;
	int	chop;
	int	not_on;
}	WhoisStuff;

/* Moved into here, because some weird CC's can't do (void *) */
typedef	struct	WhoisQueueStru
{
	char	*nick;			/* nickname of whois'ed person(s) */
	char	*text;			/* additional text */
	int	type;			/* Type of WHOIS queue entry */
	/*
	 * called with func((WhoisStuff *)stuff,(char *) nick, (char *) text) 
	 */
	void	(*func)();
	struct	WhoisQueueStru	*next;/* next element in queue */
}	WhoisQueue;

extern	char	*PasteArgs();

#ifdef PHONE
# define ON_KICK
# define COMMAND_LINE_L
#endif /* PHONE */
/*
 * SGI machines define `sgi' themselves, so we take that out of the
 * Makefile.. and define _AUX_SOURCE here, if sgi is defined.
 * Same for linux.
 */
#if defined(sgi)
# define _AUX_SOURCE
#endif /* sgi */

/*
 * Lame Linux doesn't define X_OK in a non-broken header file, so
 * we define it here.. 
 */
#ifdef linux
# define X_OK  1
#endif /* linux */

#if __osf__
# define _BSD
#endif

#if defined(sun) && !defined(solaris)
#include <sys/time.h>
extern	int	fprintf();
extern	time_t	time();
#endif /* defined(sun) && !defined(solaris) */

#endif /* _IRC_H_ */
