# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.avs import AVSClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAVSVirtualMachinesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AVSClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machines_list(self, resource_group):
        response = self.client.virtual_machines.list(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machines_get(self, resource_group):
        response = self.client.virtual_machines.get(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            virtual_machine_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_machines_begin_restrict_movement(self, resource_group):
        response = self.client.virtual_machines.begin_restrict_movement(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            virtual_machine_id="str",
            restrict_movement={"restrictMovement": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
