# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iotoperations.aio import IoTOperationsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIoTOperationsMgmtDataflowEndpointOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IoTOperationsMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dataflow_endpoint_get(self, resource_group):
        response = await self.client.dataflow_endpoint.get(
            resource_group_name=resource_group.name,
            instance_name="str",
            dataflow_endpoint_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dataflow_endpoint_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.dataflow_endpoint.begin_create_or_update(
                resource_group_name=resource_group.name,
                instance_name="str",
                dataflow_endpoint_name="str",
                resource={
                    "extendedLocation": {"name": "str", "type": "str"},
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "endpointType": "str",
                        "dataExplorerSettings": {
                            "authentication": {
                                "method": "str",
                                "systemAssignedManagedIdentitySettings": {"audience": "str"},
                                "userAssignedManagedIdentitySettings": {
                                    "clientId": "str",
                                    "tenantId": "str",
                                    "scope": "str",
                                },
                            },
                            "database": "str",
                            "host": "str",
                            "batching": {"latencySeconds": 0, "maxMessages": 0},
                        },
                        "dataLakeStorageSettings": {
                            "authentication": {
                                "method": "str",
                                "accessTokenSettings": {"secretRef": "str"},
                                "systemAssignedManagedIdentitySettings": {"audience": "str"},
                                "userAssignedManagedIdentitySettings": {
                                    "clientId": "str",
                                    "tenantId": "str",
                                    "scope": "str",
                                },
                            },
                            "host": "str",
                            "batching": {"latencySeconds": 0, "maxMessages": 0},
                        },
                        "fabricOneLakeSettings": {
                            "authentication": {
                                "method": "str",
                                "systemAssignedManagedIdentitySettings": {"audience": "str"},
                                "userAssignedManagedIdentitySettings": {
                                    "clientId": "str",
                                    "tenantId": "str",
                                    "scope": "str",
                                },
                            },
                            "host": "str",
                            "names": {"lakehouseName": "str", "workspaceName": "str"},
                            "oneLakePathType": "str",
                            "batching": {"latencySeconds": 0, "maxMessages": 0},
                        },
                        "kafkaSettings": {
                            "authentication": {
                                "method": "str",
                                "saslSettings": {"saslType": "str", "secretRef": "str"},
                                "systemAssignedManagedIdentitySettings": {"audience": "str"},
                                "userAssignedManagedIdentitySettings": {
                                    "clientId": "str",
                                    "tenantId": "str",
                                    "scope": "str",
                                },
                                "x509CertificateSettings": {"secretRef": "str"},
                            },
                            "host": "str",
                            "batching": {"latencyMs": 0, "maxBytes": 0, "maxMessages": 0, "mode": "str"},
                            "cloudEventAttributes": "str",
                            "compression": "str",
                            "consumerGroupId": "str",
                            "copyMqttProperties": "str",
                            "kafkaAcks": "str",
                            "partitionStrategy": "str",
                            "tls": {"mode": "str", "trustedCaCertificateConfigMapRef": "str"},
                        },
                        "localStorageSettings": {"persistentVolumeClaimRef": "str"},
                        "mqttSettings": {
                            "authentication": {
                                "method": "str",
                                "serviceAccountTokenSettings": {"audience": "str"},
                                "systemAssignedManagedIdentitySettings": {"audience": "str"},
                                "userAssignedManagedIdentitySettings": {
                                    "clientId": "str",
                                    "tenantId": "str",
                                    "scope": "str",
                                },
                                "x509CertificateSettings": {"secretRef": "str"},
                            },
                            "clientIdPrefix": "str",
                            "cloudEventAttributes": "str",
                            "host": "str",
                            "keepAliveSeconds": 0,
                            "maxInflightMessages": 0,
                            "protocol": "str",
                            "qos": 0,
                            "retain": "str",
                            "sessionExpirySeconds": 0,
                            "tls": {"mode": "str", "trustedCaCertificateConfigMapRef": "str"},
                        },
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dataflow_endpoint_begin_delete(self, resource_group):
        response = await (
            await self.client.dataflow_endpoint.begin_delete(
                resource_group_name=resource_group.name,
                instance_name="str",
                dataflow_endpoint_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dataflow_endpoint_list_by_resource_group(self, resource_group):
        response = self.client.dataflow_endpoint.list_by_resource_group(
            resource_group_name=resource_group.name,
            instance_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
