#!/bin/bash

if [ -f "$1" -a -f "$2" ] ; then
   rpm1=$1
   rpm2=$2
else
   echo "usage: $0 file1.rpm file2.rpm"
   exit 1
fi

file1=`basename $rpm1`
file2=`basename $rpm2`

topdir1=/tmp/$USER/diff-$file1
topdir2=/tmp/$USER/diff-$file2

if [ $topdir1 = $topdir2 ] ; then
   topdir2=$topdir2-2
fi

rm -rf $topdir1 $topdir2
mkdir -p $topdir1 $topdir2

mkdir -p $topdir1 ; (cd $topdir1 ; mkdir -p BUILD RPMS SOURCES SPECS SRPMS)
mkdir -p $topdir2 ; (cd $topdir2 ; mkdir -p BUILD RPMS SOURCES SPECS SRPMS)

rpm --define _topdir$topdir1 -i $rpm1
rpm --define _topdir$topdir2 -i $rpm2

