/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.PrimProcedure;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AddOp
extends ProcedureN
implements CanInline,
Inlineable {
    int plusOrMinus = 1;
    public static final AddOp $Pl = new AddOp("+", 1);
    public static final AddOp $Mn = new AddOp("-", -1);
    static ClassType typeIntNum = ClassType.make("gnu.math.IntNum");
    static ClassType typeDFloNum = ClassType.make("gnu.math.DFloNum");
    static ClassType typeRealNum = ClassType.make("gnu.math.RealNum");
    static ClassType typeNumeric = ClassType.make("gnu.math.Numeric");

    public AddOp(String name, int plusOrMinus) {
        this.setName(name);
        this.plusOrMinus = plusOrMinus;
    }

    public static Object apply2(int plusOrMinus, Object arg1, Object arg2) {
        int code2;
        int code1 = Arithmetic.classifyValue(arg1);
        int code = code1 < (code2 = Arithmetic.classifyValue(arg2)) ? code2 : code1;
        switch (code) {
            case 1: {
                int i1 = Arithmetic.asInt(arg1);
                int i2 = Arithmetic.asInt(arg2);
                return new Integer(plusOrMinus > 0 ? i1 + i2 : i1 - i2);
            }
            case 2: {
                long l1 = Arithmetic.asLong(arg1);
                long l2 = Arithmetic.asLong(arg2);
                return new Long(plusOrMinus > 0 ? l1 + l2 : l1 - l2);
            }
            case 3: {
                BigInteger bi1 = Arithmetic.asBigInteger(arg1);
                BigInteger bi2 = Arithmetic.asBigInteger(arg2);
                return plusOrMinus > 0 ? bi1.add(bi2) : bi1.subtract(bi2);
            }
            case 4: {
                return IntNum.add(Arithmetic.asIntNum(arg1), Arithmetic.asIntNum(arg2), plusOrMinus);
            }
            case 5: {
                BigDecimal bd1 = Arithmetic.asBigDecimal(arg1);
                BigDecimal bd2 = Arithmetic.asBigDecimal(arg2);
                return plusOrMinus > 0 ? bd1.add(bd2) : bd1.subtract(bd2);
            }
            case 6: {
                return RatNum.add(Arithmetic.asRatNum(arg1), Arithmetic.asRatNum(arg2), plusOrMinus);
            }
            case 7: {
                float f1 = Arithmetic.asFloat(arg1);
                float f2 = Arithmetic.asFloat(arg2);
                return new Float(plusOrMinus > 0 ? f1 + f2 : f1 - f2);
            }
            case 8: {
                double d1 = Arithmetic.asDouble(arg1);
                double d2 = Arithmetic.asDouble(arg2);
                return new Double(plusOrMinus > 0 ? d1 + d2 : d1 - d2);
            }
            case 9: {
                double d1 = Arithmetic.asDouble(arg1);
                double d2 = Arithmetic.asDouble(arg2);
                return new DFloNum(plusOrMinus > 0 ? d1 + d2 : d1 - d2);
            }
        }
        Numeric num1 = Arithmetic.asNumeric(arg1);
        Numeric num2 = Arithmetic.asNumeric(arg2);
        return num1.add(num2, plusOrMinus);
    }

    public static Object $Pl(Object arg1, Object arg2) {
        return AddOp.apply2(1, arg1, arg2);
    }

    public static Object $Mn(Object arg1, Object arg2) {
        return AddOp.apply2(-1, arg1, arg2);
    }

    public static Object $Mn(Object arg1) {
        return ((Numeric)arg1).neg();
    }

    public static Object $Pl$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return AddOp.applyN(1, AddOp.apply2(1, AddOp.apply2(1, arg1, arg2), arg3), rest);
    }

    public static Object $Mn$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return AddOp.applyN(-1, AddOp.apply2(-1, AddOp.apply2(-1, arg1, arg2), arg3), rest);
    }

    public static Object applyN(int plusOrMinus, Object[] args) {
        int len = args.length;
        if (len == 0) {
            return IntNum.zero();
        }
        Object result = args[0];
        if (len == 1 && plusOrMinus < 0) {
            return AddOp.$Mn(result);
        }
        for (int i = 1; i < len; ++i) {
            result = AddOp.apply2(plusOrMinus, result, args[i]);
        }
        return result;
    }

    public static Object applyN(int plusOrMinus, Object init, Object[] args) {
        int len = args.length;
        Object result = init;
        for (int i = 0; i < len; ++i) {
            result = AddOp.apply2(plusOrMinus, result, args[i]);
        }
        return result;
    }

    public Object applyN(Object[] args) {
        return AddOp.applyN(this.plusOrMinus, args);
    }

    public static Expression pairwise(Procedure proc, Expression rproc, Expression[] args, ExpWalker walker) {
        int len = args.length;
        Expression prev = args[0];
        for (int i = 1; i < len; ++i) {
            Expression[] args2 = new Expression[]{prev, args[i]};
            ApplyExp next = new ApplyExp(rproc, args2);
            prev = proc instanceof CanInline ? ((CanInline)((Object)proc)).inline(next, walker) : next;
        }
        return prev;
    }

    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Type type0;
        if (!walker.getCompilation().mustCompile) {
            return exp;
        }
        Expression folded = exp.inlineIfConstant((Procedure)this, walker);
        if (folded != exp) {
            return folded;
        }
        Expression[] args = exp.getArgs();
        if (args.length > 2) {
            return AddOp.pairwise(this, exp.getFunction(), args, walker);
        }
        if (args.length == 1 && this.plusOrMinus < 0 && (type0 = args[0].getType()) instanceof PrimType) {
            char sig0 = type0.getSignature().charAt(0);
            LangPrimType type = null;
            int opcode = 0;
            if (sig0 != 'V' && sig0 != 'Z' && sig0 != 'C') {
                if (sig0 == 'D') {
                    opcode = 119;
                    type = LangPrimType.doubleType;
                } else if (sig0 == 'F') {
                    opcode = 118;
                    type = LangPrimType.floatType;
                } else if (sig0 == 'J') {
                    opcode = 117;
                    type = LangPrimType.longType;
                } else {
                    opcode = 116;
                    type = LangPrimType.intType;
                }
            }
            if (type != null) {
                PrimProcedure prim = PrimProcedure.makeBuiltinUnary(opcode, type);
                return new ApplyExp(prim, args);
            }
        }
        if (args.length == 2) {
            return AddOp.primInline(this.plusOrMinus > 0 ? 96 : 100, exp);
        }
        return exp;
    }

    public static Expression primInline(int opcode, ApplyExp exp) {
        Expression[] args = exp.getArgs();
        if (args.length == 2) {
            Type type0 = args[0].getType();
            Type type1 = args[1].getType();
            if (type0 instanceof PrimType && type1 instanceof PrimType) {
                char sig0 = type0.getSignature().charAt(0);
                char sig1 = type1.getSignature().charAt(0);
                LangPrimType type = null;
                if (sig0 != 'V' && sig0 != 'Z' && sig0 != 'C' && sig1 != 'V' && sig1 != 'Z' && sig1 != 'C') {
                    if (sig0 == 'D' || sig1 == 'D') {
                        opcode += 3;
                        type = LangPrimType.doubleType;
                    } else if (sig0 == 'F' || sig1 == 'F') {
                        opcode += 2;
                        type = LangPrimType.floatType;
                    } else if (sig0 == 'J' || sig1 == 'J') {
                        ++opcode;
                        type = LangPrimType.longType;
                    } else {
                        type = LangPrimType.intType;
                    }
                }
                if (type != null) {
                    PrimProcedure prim = PrimProcedure.makeBuiltinBinary(opcode, type);
                    return new ApplyExp(prim, args);
                }
            }
        }
        return exp;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        int len = args.length;
        if (len == 0) {
            comp.compileConstant(IntNum.zero(), target);
            return;
        }
        Type type = this.getReturnType(args);
        Type ttype = target.getType();
        if (len == 1 || target instanceof IgnoreTarget) {
            ApplyExp.compile(exp, comp, target);
            return;
        }
        LangPrimType ptype = null;
        if (ttype instanceof PrimType) {
            char sig = type.getSignature().charAt(0);
            if (sig == 'V' || sig == 'Z' || sig == 'C') {
                ptype = null;
            } else if (sig == 'D' || sig == 'F') {
                if (type.isSubtype(typeRealNum)) {
                    ptype = LangPrimType.doubleType;
                }
            } else if (type.isSubtype(typeIntNum)) {
                LangPrimType langPrimType = ptype = sig == 'J' ? LangPrimType.longType : LangPrimType.intType;
            }
        }
        if (ptype != null) {
            CodeAttr code = comp.getCode();
            args[0].compile(comp, ttype);
            for (int i = 1; i < len; ++i) {
                args[i].compile(comp, ptype);
                if (this.plusOrMinus > 0) {
                    code.emitAdd(ptype);
                    continue;
                }
                code.emitSub(ptype);
            }
            target.compileFromStack(comp, ttype);
        } else if (type.isSubtype(typeDFloNum)) {
            LangPrimType dtype = LangPrimType.doubleType;
            StackTarget dtarget = new StackTarget(dtype);
            CodeAttr code = comp.getCode();
            args[0].compile(comp, dtarget);
            for (int i = 1; i < len; ++i) {
                args[i].compile(comp, dtarget);
                if (this.plusOrMinus > 0) {
                    code.emitAdd(dtype);
                    continue;
                }
                code.emitSub(dtype);
            }
            target.compileFromStack(comp, dtype);
        } else {
            ApplyExp.compile(exp, comp, target);
        }
    }

    public static int classify(Type type) {
        boolean kind = false;
        if (type instanceof PrimType) {
            char sig = type.getSignature().charAt(0);
            if (sig == 'V' || sig == 'Z' || sig == 'C') {
                return 0;
            }
            if (sig == 'D' || sig == 'F') {
                return 3;
            }
            return 4;
        }
        if (type.isSubtype(typeIntNum)) {
            return 4;
        }
        if (type.isSubtype(typeDFloNum)) {
            return 3;
        }
        if (type.isSubtype(typeRealNum)) {
            return 2;
        }
        if (type.isSubtype(typeNumeric)) {
            return 1;
        }
        return 0;
    }

    public Type getReturnType(Expression[] args) {
        int len = args.length;
        if (len == 0) {
            return typeIntNum;
        }
        ClassType type = Type.pointer_type;
        int kind0 = 0;
        for (int i = 0; i < len; ++i) {
            Expression arg = args[i];
            int kind = AddOp.classify(arg.getType());
            if (kind == 0) {
                return Type.pointer_type;
            }
            if (i == 0) {
                kind0 = kind;
            }
            if (kind0 == 4 && kind == 4) {
                type = typeIntNum;
                continue;
            }
            if (kind0 >= 2 && kind >= 2) {
                if (kind0 == 3 || kind == 3) {
                    type = typeDFloNum;
                    kind0 = 3;
                    continue;
                }
                type = typeRealNum;
                kind0 = 2;
                continue;
            }
            if (kind0 >= 1 && kind >= 1) {
                type = typeNumeric;
                kind0 = 1;
                continue;
            }
            return Type.pointer_type;
        }
        return type;
    }
}

