/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath
implements Serializable {
    private static ClassPath SYSTEM_CLASS_PATH = null;
    private PathEntry[] paths;
    private String class_path;

    public static ClassPath getSystemClassPath() {
        if (SYSTEM_CLASS_PATH == null) {
            SYSTEM_CLASS_PATH = new ClassPath();
        }
        return SYSTEM_CLASS_PATH;
    }

    public ClassPath(String class_path) {
        this.class_path = class_path;
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
        StringTokenizer tok = new StringTokenizer(class_path, System.getProperty("path.separator"));
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.equals("")) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vec.add(new Dir(path));
                    continue;
                }
                vec.add(new Zip(new ZipFile(file)));
            }
            catch (IOException e) {
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new PathEntry[vec.size()];
        vec.toArray(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public String toString() {
        return this.class_path;
    }

    public int hashCode() {
        return this.class_path.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPath) {
            return this.class_path.equals(((ClassPath)o).class_path);
        }
        return false;
    }

    private static final void getPathComponents(String path, ArrayList list) {
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.add(name);
            }
        }
    }

    public static final String getClassPath() {
        String class_path = System.getProperty("java.class.path");
        String boot_path = System.getProperty("sun.boot.class.path");
        String ext_path = System.getProperty("java.ext.dirs");
        ArrayList<String> list = new ArrayList<String>();
        ClassPath.getPathComponents(class_path, list);
        ClassPath.getPathComponents(boot_path, list);
        ArrayList dirs = new ArrayList();
        ClassPath.getPathComponents(ext_path, dirs);
        Iterator e = ((AbstractList)dirs).iterator();
        while (e.hasNext()) {
            File ext_dir = new File((String)e.next());
            String[] extensions = ext_dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).endsWith(".zip") || name.endsWith(".jar");
                }
            });
            if (extensions == null) continue;
            int i = 0;
            while (i < extensions.length) {
                list.add(String.valueOf(ext_path) + File.separatorChar + extensions[i]);
                ++i;
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator e2 = ((AbstractList)list).iterator();
        while (e2.hasNext()) {
            buf.append((String)e2.next());
            if (!e2.hasNext()) continue;
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString().intern();
    }

    public InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, ".class");
    }

    public InputStream getInputStream(String name, String suffix) throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(String.valueOf(name) + suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public ClassFile getClassFile(String name, String suffix) throws IOException {
        int i = 0;
        while (i < this.paths.length) {
            ClassFile cf = this.paths[i].getClassFile(name, suffix);
            if (cf != null) {
                return cf;
            }
            ++i;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    public ClassFile getClassFile(String name) throws IOException {
        return this.getClassFile(name, ".class");
    }

    public byte[] getBytes(String name, String suffix) throws IOException {
        InputStream is = this.getInputStream(name, suffix);
        if (is == null) {
            throw new IOException("Couldn't find: " + name + suffix);
        }
        DataInputStream dis = new DataInputStream(is);
        byte[] bytes = new byte[is.available()];
        dis.readFully(bytes);
        dis.close();
        is.close();
        return bytes;
    }

    public byte[] getBytes(String name) throws IOException {
        return this.getBytes(name, ".class");
    }

    public String getPath(String name) throws IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public String getPath(String name, String suffix) throws IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    private static abstract class PathEntry
    implements Serializable {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }

    public static interface ClassFile {
        public InputStream getInputStream() throws IOException;

        public String getPath();

        public String getBase();

        public long getTime();

        public long getSize();
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String d) {
            this.dir = d;
        }

        ClassFile getClassFile(String name, String suffix) throws IOException {
            File file = new File(String.valueOf(this.dir) + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(this, file){
                final /* synthetic */ Dir this$1;
                private final /* synthetic */ File val$file;
                {
                    this.this$1 = dir;
                    this.val$file = file;
                }

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(this.val$file);
                }

                public String getPath() {
                    try {
                        return this.val$file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                public long getTime() {
                    return this.val$file.lastModified();
                }

                public long getSize() {
                    return this.val$file.length();
                }

                public String getBase() {
                    return Dir.access$0(this.this$1);
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }

        static /* synthetic */ String access$0(Dir dir) {
            return dir.dir;
        }
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
        }

        ClassFile getClassFile(String name, String suffix) throws IOException {
            ZipEntry entry = this.zip.getEntry(String.valueOf(name.replace('.', '/')) + suffix);
            return entry != null ? new ClassFile(this, entry){
                final /* synthetic */ Zip this$1;
                private final /* synthetic */ ZipEntry val$entry;
                {
                    this.this$1 = zip;
                    this.val$entry = zipEntry;
                }

                public InputStream getInputStream() throws IOException {
                    return Zip.access$0(this.this$1).getInputStream(this.val$entry);
                }

                public String getPath() {
                    return this.val$entry.toString();
                }

                public long getTime() {
                    return this.val$entry.getTime();
                }

                public long getSize() {
                    return this.val$entry.getSize();
                }

                public String getBase() {
                    return Zip.access$0(this.this$1).getName();
                }
            } : null;
        }

        static /* synthetic */ ZipFile access$0(Zip zip) {
            return zip.zip;
        }
    }
}

