/*
 * Decompiled with CFR 0.152.
 */
package jbet;

import java.lang.reflect.Array;
import java.util.Hashtable;
import jbet.CPInterface;
import jbet.ClassFileException;
import jbet.ClassInfo;
import jbet.ClassInfoLoader;
import jbet.Instruction;
import jbet.Jbet;
import jbet.ParseException;
import jbet.Util;

public final class Type {
    public static final int VM_INT = 1;
    public static final int VM_ADDRESS = 2;
    public static final int VM_FLOAT = 3;
    public static final int VM_LONG = 4;
    public static final int VM_DOUBLE = 5;
    public static final int VM_RETADDR = 6;
    public char base;
    public int arraydepth = 0;
    public String cname = null;
    public Object extra = null;
    public static final Type VOID;
    public static final Type INT;
    public static final Type BOOLEAN;
    public static final Type BYTE;
    public static final Type CHAR;
    public static final Type SHORT;
    public static final Type FLOAT;
    public static final Type LONG;
    public static final Type DOUBLE;
    public static final Type RETADDR;
    public static final Type DASH;
    public static final Type NULL;
    public static final Type ARRAY;
    public static final Type SHORTARRAY;
    public static final Type CHARARRAY;
    public static final Type INTARRAY;
    public static final Type BOOLARRAY;
    public static final Type BYTEARRAY;
    public static final Type DOUBLEARRAY;
    public static final Type FLOATARRAY;
    public static final Type LONGARRAY;
    public static final Type STRING;
    public static final Type STRINGBUFFER;
    public static final Type OBJECT;
    public static final Type CLASS;
    public static final Type THROWABLE;
    public static final Type CLONEABLE;
    public static final Type SERIALIZABLE;
    public static final Type REFARRAY;
    public static final Type CLASSARRAY;
    public static final Type STRINGARRAY;
    public static final Type PRINTSTREAM;
    private String stringCache = null;

    Instruction target() {
        Type type = this;
        return (Instruction)type.extra;
    }

    Instruction setTarget(Instruction instruction) {
        Instruction instruction2;
        Type type = this;
        Instruction instruction3 = instruction2 = instruction;
        type.extra = instruction3;
        return instruction3;
    }

    public String toClassRef() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        Type type6 = type;
        if (type6.arraydepth != 0) {
            return type2.toString();
        }
        Type type7 = NULL;
        if (type.equals(type7)) {
            return "java/lang/Object";
        }
        if (type3.base != 'L') {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("no classref for non-class type ");
            String string = type4.toString();
            StringBuffer stringBuffer3 = stringBuffer2.append(string);
            String string2 = stringBuffer3.toString();
            throw new IllegalStateException(string2);
        }
        return type5.cname;
    }

    public String declaration() {
        StringBuffer stringBuffer;
        String string;
        String string2;
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        switch (type3.base) {
            case 'I': {
                string2 = "int";
                string = "int";
                break;
            }
            case 'J': {
                string2 = "long";
                string = "long";
                break;
            }
            case 'F': {
                string2 = "float";
                string = "float";
                break;
            }
            case 'D': {
                string2 = "double";
                string = "double";
                break;
            }
            case 'L': 
            case 'l': {
                String string3 = type4.cname;
                string = string2 = Util.srcClassName(string3);
                break;
            }
            case 'V': {
                string2 = "void";
                string = "void";
                break;
            }
            case 'Z': {
                string2 = "boolean";
                string = "boolean";
                break;
            }
            case 'S': {
                string2 = "short";
                string = "short";
                break;
            }
            case 'C': {
                string2 = "char";
                string = "char";
                break;
            }
            case 'B': {
                string2 = "byte";
                string = "byte";
                break;
            }
            case 'N': {
                string2 = "Object";
                string = "Object";
                break;
            }
            default: {
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = stringBuffer2.append("can't declare a ");
                String string4 = type2.toString();
                StringBuffer stringBuffer4 = stringBuffer3.append(string4);
                String string5 = stringBuffer4.toString();
                throw new IllegalStateException(string5);
            }
        }
        if (type5.arraydepth == 0) {
            return string2;
        }
        StringBuffer stringBuffer5 = stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while (n2 < type.arraydepth) {
            int n3 = n;
            n2 = n = n3 + 1;
            stringBuffer5.append("[]");
        }
        return stringBuffer.toString();
    }

    private static Type newType(String string) {
        String string2;
        String string3 = string2 = string;
        try {
            Type type = new Type(string3);
            return type;
        }
        catch (ParseException parseException) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("bad type string: ");
            StringBuffer stringBuffer3 = stringBuffer2.append(string2);
            String string4 = stringBuffer3.toString();
            throw new IllegalStateException(string4);
        }
    }

    private static Type newType(String string, int n) {
        String string2;
        String string3 = string2 = string;
        int n2 = n;
        try {
            Type type = new Type(string2, n2);
            return type;
        }
        catch (ParseException parseException) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("bad type string: ");
            StringBuffer stringBuffer3 = stringBuffer2.append(string3);
            String string4 = stringBuffer3.toString();
            throw new IllegalStateException(string4);
        }
    }

    public Type(ClassInfo cr) {
        this('L', 0, cr.name());
    }

    public Type(char ch) {
        this.base = ch;
    }

    public Type(char ch, int d) {
        this(ch);
        this.arraydepth = d;
    }

    public Type(char ch, int d, String s) {
        this(ch, d);
        this.cname = s;
    }

    public Type(char ch, int d, String s, Object x) {
        this(ch, d, s);
        this.extra = x;
    }

    public Type(String s, int d) {
        this.base = (char)76;
        this.cname = s;
        this.arraydepth = d;
    }

    public Type(Type t) {
        this.base = t.base;
        this.arraydepth = t.arraydepth;
        this.cname = t.cname;
        this.extra = t.extra;
    }

    Type() {
    }

    public Type(String s) throws ParseException {
        this.parse(s);
    }

    public Type(Object o) {
        String cn = o.getClass().getName().replace('.', '/');
        if (cn.equals("java/lang/Integer")) {
            this.base = (char)73;
            this.arraydepth = 0;
        } else if (cn.equals("java/lang/Long")) {
            this.base = (char)74;
            this.arraydepth = 0;
        } else if (cn.equals("java/lang/Float")) {
            this.base = (char)70;
            this.arraydepth = 0;
        } else if (cn.equals("java/lang/Double")) {
            this.base = (char)68;
            this.arraydepth = 0;
        } else {
            if (cn.startsWith("[")) {
                throw new IllegalStateException("not implemented yet");
            }
            this.cname = cn;
            this.base = (char)76;
            this.arraydepth = 0;
        }
    }

    static Type newarray(int n) {
        int n2;
        int n3 = n2 = n;
        switch (n3) {
            case 10: {
                return INTARRAY;
            }
            case 8: {
                return BYTEARRAY;
            }
            case 5: {
                return CHARARRAY;
            }
            case 4: {
                return BOOLARRAY;
            }
            case 9: {
                return SHORTARRAY;
            }
            case 6: {
                return FLOATARRAY;
            }
            case 7: {
                return DOUBLEARRAY;
            }
            case 11: {
                return LONGARRAY;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("invalid new array type ");
        StringBuffer stringBuffer3 = stringBuffer2.append(n2);
        String string = stringBuffer3.toString();
        throw new IllegalStateException(string);
    }

    public static Type merge(Type type, Type type2) throws ClassFileException {
        Type type3;
        Type type4;
        Type type5;
        Type type6 = type5 = type;
        Type type7 = type5;
        Type type8 = type5;
        Type type9 = type5;
        Type type10 = type5;
        Type type11 = type5;
        Type type12 = type5;
        Type type13 = type5;
        Type type14 = type5;
        Type type15 = type5;
        Type type16 = type5;
        Type type17 = type5;
        Type type18 = type5;
        Type type19 = type5;
        Type type20 = type5;
        Type type21 = type5;
        Type type22 = type5;
        Type type23 = type5;
        Type type24 = type5;
        Type type25 = type5;
        Type type26 = type5;
        Type type27 = type5;
        Type type28 = type5;
        Type type29 = type5;
        Type type30 = type5;
        Type type31 = type5;
        Type type32 = type5;
        Type type33 = type5;
        Type type34 = type5;
        Type type35 = type4 = type2;
        Type type36 = type4;
        Type type37 = type4;
        Type type38 = type4;
        Type type39 = type4;
        Type type40 = type4;
        Type type41 = type4;
        Type type42 = type4;
        Type type43 = type4;
        Type type44 = type4;
        Type type45 = type4;
        Type type46 = type4;
        Type type47 = type4;
        Type type48 = type4;
        Type type49 = type4;
        Type type50 = type4;
        Type type51 = type4;
        Type type52 = type4;
        Type type53 = type4;
        Type type54 = type4;
        Type type55 = type4;
        Type type56 = type4;
        Type type57 = type4;
        Type type58 = type4;
        Type type59 = type4;
        if (type19 == null || type47 == null) {
            return null;
        }
        Type type60 = ARRAY;
        if (type10.equals(type60) && type43.arraydepth > 0) {
            return type33;
        }
        Type type61 = ARRAY;
        if (type37.equals(type61) && type11.arraydepth > 0) {
            return type45;
        }
        if (type26.base == 'l' || type36.base == 'l') {
            String string;
            String string2;
            if (type25.base == type48.base && type18.target() == type58.target() && (string2 = type24.cname).equals(string = type52.cname) && type23.arraydepth == 0 && type46.arraydepth == 0) {
                return type34;
            }
            return null;
        }
        if (type22.equals(type35)) {
            Type type62 = RETADDR;
            if (type9.equals(type62)) {
                if (type21.target() == type4.target()) {
                    return type32;
                }
                return RETADDR;
            }
            return type8;
        }
        if (type16.isPrimitive() || type42.isPrimitive()) {
            return null;
        }
        Type type63 = NULL;
        if (type30.equals(type63)) {
            return type57;
        }
        Type type64 = NULL;
        if (type49.equals(type64)) {
            return type13;
        }
        Type type65 = OBJECT;
        if (type20.equals(type65) || type56.equals(type3 = OBJECT)) {
            return OBJECT;
        }
        if (type5.arraydepth > 0 || type41.arraydepth > 0) {
            Type type66;
            Type type67;
            Type type68 = CLONEABLE;
            if (type28.equals(type68) || type14.equals(type67 = SERIALIZABLE)) {
                return type27;
            }
            Type type69 = CLONEABLE;
            if (type53.equals(type69) || type54.equals(type66 = SERIALIZABLE)) {
                return type50;
            }
            if (type6.base != 'L') {
                int n = type12.arraydepth - 1;
                type29 = type7 = new Type('L', n, "java/lang/Object");
                type31 = type7;
                type17 = type7;
            }
            if (type38.base != 'L') {
                int n = type51.arraydepth - 1;
                type55 = type39 = new Type('L', n, "java/lang/Object");
                type44 = type39;
                type59 = type39;
            }
            if (type7.arraydepth == type55.arraydepth) {
                Type type70 = type29;
                String string = type70.cname;
                String string3 = type44.cname;
                String string4 = Type.merge(string, string3);
                int n = type70.arraydepth;
                return new Type('L', n, string4);
            }
            int n = type17.arraydepth < type59.arraydepth ? type31.arraydepth : type39.arraydepth;
            return new Type('L', n, "java/lang/Object");
        }
        String string = type15.cname;
        String string5 = type40.cname;
        String string6 = Type.merge(string, string5);
        return new Type('L', 0, string6);
    }

    static String merge(String string, String string2) throws ClassFileException {
        String string3;
        String string4;
        String string5 = string4 = string;
        String string6 = string4;
        String string7 = string4;
        String string8 = string3 = string2;
        String string9 = string3;
        String string10 = string3;
        if (ClassInfo.isAncestor(string5, string8)) {
            return string10;
        }
        if (ClassInfo.isAncestor(string3, string6)) {
            return string4;
        }
        return ClassInfo.allCommonAncestors(string7, string9);
    }

    public boolean isa(Type type) throws ClassFileException {
        Type type2 = this;
        Type type3 = type;
        Type type4 = type3;
        Type type5 = Type.merge(type2, type4);
        if (type5 == null) {
            return false;
        }
        return type5.equals(type3);
    }

    public boolean isUninitialized() {
        Type type;
        Type type2 = type = this;
        boolean bl = type.base == 'l' && type2.arraydepth == 0;
        return bl;
    }

    Type initialize() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        if (type2.base != 'l' || type4.arraydepth > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("can't initialize ");
            String string = type.toString();
            StringBuffer stringBuffer3 = stringBuffer2.append(string);
            String string2 = stringBuffer3.toString();
            throw new IllegalStateException(string2);
        }
        String string = type3.cname;
        return new Type('L', 0, string);
    }

    public Type merge(Type type) throws ClassFileException {
        Type type2 = this;
        Type type3 = type;
        return Type.merge(type2, type3);
    }

    public static Type class2type(String string) {
        String string2;
        String string3 = string2 = string;
        String string4 = string2;
        if (string3.startsWith("[")) {
            return new Type(string2);
        }
        return new Type(string4, 0);
    }

    public Type popbracket() throws RuntimeException {
        int n;
        Type type;
        Type type2 = type = this;
        if (type2.arraydepth == 0) {
            throw new RuntimeException("popbracket called on non-array");
        }
        Type type3 = new Type(type);
        type3.arraydepth = n = type3.arraydepth - 1;
        return type3;
    }

    public Type popbrackets() {
        Type type;
        Type type2 = type = this;
        if (type.arraydepth == 0) {
            throw new RuntimeException("popbrackets called on non-array");
        }
        Type type3 = new Type(type2);
        type3.arraydepth = 0;
        return type3;
    }

    void relocate(Hashtable hashtable) {
        String string;
        block5: {
            block4: {
                String string2;
                Type type;
                Type type2 = type = this;
                Type type3 = type;
                Type type4 = type;
                Hashtable hashtable2 = hashtable;
                if (type2.cname == null) {
                    return;
                }
                String string3 = type3.cname;
                string = string2 = (String)hashtable2.get(string3);
                if (string2 == null) break block4;
                String string4 = type.cname;
                if (!string4.equals(string2)) break block5;
            }
            return;
        }
        type4.cname = string;
    }

    Type relocate_new(Hashtable hashtable) {
        Type type = this;
        Hashtable hashtable2 = hashtable;
        Type type2 = new Type(type);
        type2.relocate(hashtable2);
        return type2;
    }

    public boolean basicly_equalls(Type type) {
        Type type2;
        Type type3;
        Type type4 = type3 = this;
        Type type5 = type2 = type;
        boolean bl = type4.base == type2.base && type3.arraydepth == type5.arraydepth;
        return bl;
    }

    public boolean isPrimitive() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        boolean bl = type3.arraydepth == 0 && type2.base != 'L' && type.base != 'N';
        return bl;
    }

    public boolean isRef() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        boolean bl = type.base == 'N' || type3.arraydepth != 0 || type2.base == 'L';
        return bl;
    }

    public String wrapperClass() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        if (type3.arraydepth != 0 || type.base == 'L') {
            throw new RuntimeException("wrapperClass called for non primitive type");
        }
        switch (type2.base) {
            case 'Z': {
                return "java/lang/Boolean";
            }
            case 'C': {
                return "java/lang/Character";
            }
            case 'B': {
                return "java/lang/Byte";
            }
            case 'S': {
                return "java/lang/Short";
            }
            case 'I': {
                return "java/lang/Integer";
            }
            case 'J': {
                return "java/lang/Long";
            }
            case 'F': {
                return "java/lang/Float";
            }
            case 'D': {
                return "java/lang/Double";
            }
        }
        return "unreachable code";
    }

    public Type refType() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        if (type4.arraydepth != 0 || type2.base == 'L') {
            return type;
        }
        String string = type3.wrapperClass();
        return new Type('L', 0, string);
    }

    public String unpackMethod() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        if (type2.arraydepth != 0 || type.base == 'L') {
            throw new RuntimeException("getvalFunc called for non primitive type");
        }
        switch (type3.base) {
            case 'Z': {
                return "booleanValue";
            }
            case 'C': {
                return "charValue";
            }
            case 'B': {
                return "byteValue";
            }
            case 'S': {
                return "shortValue";
            }
            case 'I': {
                return "intValue";
            }
            case 'J': {
                return "longValue";
            }
            case 'F': {
                return "floatValue";
            }
            case 'D': {
                return "doubleValue";
            }
        }
        return "unreachable code";
    }

    public int vmType() {
        Type type;
        Type type2 = type = this;
        if (type.arraydepth > 0) {
            return 2;
        }
        switch (type2.base) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 1;
            }
            case 'L': 
            case 'N': 
            case 'l': {
                return 2;
            }
            case 'J': {
                return 4;
            }
            case 'D': {
                return 5;
            }
            case 'F': {
                return 3;
            }
            case 'R': {
                return 6;
            }
        }
        return 0;
    }

    public Type compType() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        if (type4.arraydepth > 0) {
            return type;
        }
        switch (type3.base) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INT;
            }
            case 'L': 
            case 'l': {
                return type2;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'F': {
                return FLOAT;
            }
            case 'R': {
                return RETADDR;
            }
        }
        return type5;
    }

    public Type rawType() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        if (type.arraydepth > 0) {
            return OBJECT;
        }
        switch (type3.base) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INT;
            }
            case 'L': 
            case 'N': 
            case 'l': {
                return OBJECT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'F': {
                return FLOAT;
            }
            case 'R': {
                return RETADDR;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("bad type: ");
        String string = type2.toString();
        StringBuffer stringBuffer3 = stringBuffer2.append(string);
        String string2 = stringBuffer3.toString();
        throw new IllegalStateException(string2);
    }

    public int category() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        Type type6 = DASH;
        if (type.equals(type6)) {
            return -1;
        }
        if (type5.arraydepth == 0 && (type3.base == 'J' || type2.base == 'D')) {
            return 2;
        }
        if (type4.base == 'V') {
            return 0;
        }
        return 1;
    }

    int parse(String string) throws ParseException {
        Type type = this;
        String string2 = string;
        return type.parse(string2, 0);
    }

    int parse(String string, int n) throws ParseException {
        int n2;
        int n3;
        String string2;
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        Type type6 = type;
        Type type7 = type;
        String string3 = string2 = string;
        String string4 = string2;
        String string5 = string2;
        String string6 = string2;
        String string7 = string2;
        int n4 = n3 = n;
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        type7.stringCache = null;
        while (string5.charAt(n4) == '[') {
            int n8;
            int n9 = n3;
            n4 = n3 = n9 + 1;
            n6 = n3;
            Type type8 = type3;
            type8.arraydepth = n8 = type8.arraydepth + 1;
        }
        int n10 = n6;
        char c = string4.charAt(n10);
        Type type9 = type5;
        type5.base = c;
        int n11 = n2 = n10 + 1;
        int n12 = n2;
        int n13 = n2;
        int n14 = n2;
        int n15 = n2;
        switch (type9.base) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'S': 
            case 'V': 
            case 'Z': {
                break;
            }
            default: {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = stringBuffer.append("bad basetype: ");
                char c2 = type2.base;
                StringBuffer stringBuffer3 = stringBuffer2.append(c2);
                String string8 = stringBuffer3.toString();
                throw new ParseException(string8);
            }
        }
        if (type.base == 'L' || type4.base == 'l') {
            String string9;
            StringBuffer stringBuffer;
            StringBuffer stringBuffer4 = stringBuffer = new StringBuffer();
            StringBuffer stringBuffer5 = stringBuffer;
            while (string3.charAt(n2) != ';') {
                if (n15 >= string7.length()) {
                    StringBuffer stringBuffer6 = new StringBuffer();
                    StringBuffer stringBuffer7 = stringBuffer6.append("unexpected end of string: ");
                    String string10 = string6;
                    StringBuffer stringBuffer8 = stringBuffer7.append(string10);
                    StringBuffer stringBuffer9 = stringBuffer8.append("/");
                    String string11 = stringBuffer4.toString();
                    StringBuffer stringBuffer10 = stringBuffer9.append(string11);
                    StringBuffer stringBuffer11 = stringBuffer10.append("/");
                    StringBuffer stringBuffer12 = stringBuffer11.append(n12);
                    StringBuffer stringBuffer13 = stringBuffer12.append("/");
                    int n16 = string10.length();
                    StringBuffer stringBuffer14 = stringBuffer13.append(n16);
                    String string12 = stringBuffer14.toString();
                    throw new ParseException(string12);
                }
                int n17 = n14;
                char c3 = string2.charAt(n17);
                n11 = n2 = n17 + 1;
                n12 = n2;
                n14 = n2;
                n15 = n2;
                stringBuffer.append(c3);
            }
            n13 = n11 + 1;
            type6.cname = string9 = stringBuffer5.toString();
        }
        return n13 - n5;
    }

    public int count() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        if (type3.arraydepth == 0 && (type2.base == 'J' || type.base == 'D')) {
            return 2;
        }
        return 1;
    }

    public String toString() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        Type type6 = type;
        Type type7 = type;
        if (type3.stringCache == null) {
            String string;
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
            StringBuffer stringBuffer3 = stringBuffer;
            StringBuffer stringBuffer4 = stringBuffer;
            int n = 0;
            int n2 = 0;
            while (n2 < type.arraydepth) {
                stringBuffer2.append('[');
                int n3 = n;
                n2 = n = n3 + 1;
            }
            Type type8 = type5;
            char c = type8.base;
            stringBuffer.append(c);
            if (type8.base == 'L' || type2.base == 'l') {
                String string2 = type6.cname;
                StringBuffer stringBuffer5 = stringBuffer3;
                stringBuffer5.append(string2);
                stringBuffer5.append(';');
            }
            type7.stringCache = string = stringBuffer4.toString();
        }
        return type4.stringCache;
    }

    public boolean equals(Object object) {
        Type type;
        Type type2;
        Type type3 = type2 = this;
        Type type4 = type2;
        Type type5 = type2;
        Object object2 = object;
        Object object3 = object2;
        if (!(object3 instanceof Type)) {
            return false;
        }
        Type type6 = type = (Type)object2;
        Type type7 = type;
        if (type5.base != type.base || type2.arraydepth != type.arraydepth) {
            return false;
        }
        if (type4.cname != null) {
            String string = type3.cname;
            String string2 = type6.cname;
            return string.equals(string2);
        }
        boolean bl = type7.cname == null;
        return bl;
    }

    String ref(CPInterface cPInterface) throws RuntimeException {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        if (type3.isPrimitive()) {
            throw new RuntimeException("ref() called on a primitive type");
        }
        if (type.arraydepth == 0) {
            return type4.cname;
        }
        return type2.toString();
    }

    public int hashCode() {
        int n;
        Type type;
        Type type2;
        Type type3 = type2 = (type = this);
        int n2 = 37 * type3.base;
        int n3 = 11 * type3.arraydepth;
        int n4 = n2 + n3;
        if (type3.cname == null) {
            n = 0;
        } else {
            String string = type.cname;
            n = string.hashCode();
        }
        return n4 + n;
    }

    public ClassInfo getClassInfo() throws ClassFileException {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        if (type4.base != 'L' && type3.base != 'l' || type.arraydepth != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = type5.toString();
            StringBuffer stringBuffer2 = stringBuffer.append(string);
            StringBuffer stringBuffer3 = stringBuffer2.append(" has no class file");
            String string2 = stringBuffer3.toString();
            throw new IllegalStateException(string2);
        }
        ClassInfoLoader classInfoLoader = Jbet.loader;
        String string = type2.cname;
        return classInfoLoader.getClass(string);
    }

    public Class realclass() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        Type type6 = type;
        if (type2.arraydepth > 0) {
            int[] nArray;
            int[] nArray2 = nArray = new int[type4.arraydepth];
            int n = 0;
            int n2 = 0;
            while (n < type3.arraydepth) {
                int n3 = n2;
                nArray2[n3] = 1;
                n2 = n = n3 + 1;
            }
            Type type7 = type.popbrackets();
            Class clazz = type7.realclass();
            Object object = Array.newInstance(clazz, nArray);
            return object.getClass();
        }
        switch (type6.base) {
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                try {
                    String string = type5.declaration();
                    Class<?> clazz = Class.forName(string);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string = classNotFoundException.getMessage();
                    throw new IllegalStateException(string);
                }
            }
        }
        throw new IllegalStateException("type is not usable");
    }

    public String jniType() {
        Type type;
        Type type2 = type = this;
        Type type3 = type;
        Type type4 = type;
        Type type5 = type;
        Type type6 = type;
        Type type7 = type;
        Type type8 = type;
        if (type8.arraydepth == 1) {
            switch (type7.base) {
                case 'B': {
                    return "jbyteArray";
                }
                case 'C': {
                    return "jcharArray";
                }
                case 'S': {
                    return "jshortArray";
                }
                case 'I': {
                    return "jintArray";
                }
                case 'Z': {
                    return "jbooleanArray";
                }
                case 'F': {
                    return "jfloatArray";
                }
                case 'J': {
                    return "jlongArray";
                }
                case 'D': {
                    return "jdoubleArray";
                }
                case 'L': {
                    return "jobjectArray";
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = stringBuffer.append("bad array basetype ");
            char c = type6.base;
            StringBuffer stringBuffer3 = stringBuffer2.append(c);
            String string = stringBuffer3.toString();
            throw new IllegalStateException(string);
        }
        if (type.arraydepth != 0) {
            return "jobjectArray";
        }
        switch (type5.base) {
            case 'V': {
                return "void";
            }
            case 'B': {
                return "jbyte";
            }
            case 'S': {
                return "jshort";
            }
            case 'C': {
                return "jchar";
            }
            case 'Z': {
                return "jboolean";
            }
            case 'I': {
                return "jint";
            }
            case 'F': {
                return "jfloat";
            }
            case 'J': {
                return "jlong";
            }
            case 'D': {
                return "jdouble";
            }
            case 'L': {
                String string = type4.cname;
                if (string.equals("java/lang/Class")) {
                    return "jclass";
                }
                String string2 = type3.cname;
                if (string2.equals("java/lang/String")) {
                    return "jstring";
                }
                return "jobject";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer4 = stringBuffer.append("bad basetype ");
        char c = type2.base;
        StringBuffer stringBuffer5 = stringBuffer4.append(c);
        String string = stringBuffer5.toString();
        throw new IllegalStateException(string);
    }

    static {
        Type type;
        Type type2;
        Type type3;
        Type type4;
        Type type5;
        Type type6;
        Type type7;
        Type type8;
        Type type9;
        Type type10;
        Type type11;
        Type type12;
        Type type13;
        Type type14;
        Type type15;
        Type type16;
        Type type17;
        Type type18;
        Type type19;
        Type type20;
        Type type21;
        Type type22;
        Type type23;
        Type type24;
        Type type25;
        Type type26;
        Type type27;
        Type type28;
        Type type29;
        Type type30;
        Type type31;
        Type type32;
        VOID = type32 = new Type('V');
        INT = type31 = new Type('I');
        BOOLEAN = type30 = new Type('Z');
        BYTE = type29 = new Type('B');
        CHAR = type28 = new Type('C');
        SHORT = type27 = new Type('S');
        FLOAT = type26 = new Type('F');
        LONG = type25 = new Type('J');
        DOUBLE = type24 = new Type('D');
        RETADDR = type23 = new Type('R');
        DASH = type22 = new Type('-');
        NULL = type21 = new Type('N');
        ARRAY = type20 = new Type('-', 1);
        SHORTARRAY = type19 = Type.newType("[S");
        CHARARRAY = type18 = Type.newType("[C");
        INTARRAY = type17 = Type.newType("[I");
        BOOLARRAY = type16 = Type.newType("[Z");
        BYTEARRAY = type15 = Type.newType("[B");
        DOUBLEARRAY = type14 = Type.newType("[D");
        FLOATARRAY = type13 = Type.newType("[F");
        LONGARRAY = type12 = Type.newType("[J");
        STRING = type11 = Type.newType("Ljava/lang/String;");
        STRINGBUFFER = type10 = Type.newType("Ljava/lang/StringBuffer;");
        OBJECT = type9 = Type.newType("Ljava/lang/Object;");
        CLASS = type8 = Type.newType("Ljava/lang/Class;");
        THROWABLE = type7 = Type.newType("Ljava/lang/Throwable;");
        CLONEABLE = type6 = Type.newType("Ljava/lang/Cloneable;");
        SERIALIZABLE = type5 = Type.newType("Ljava/io/Serializable;");
        REFARRAY = type4 = Type.newType("[Ljava/lang/Object;");
        CLASSARRAY = type3 = Type.newType("[Ljava/lang/Class;");
        STRINGARRAY = type2 = Type.newType("[Ljava/lang/String;");
        PRINTSTREAM = type = Type.newType("Ljava/io/PrintStream;");
    }
}

