# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AddParticipantsRequest(_serialization.Model):
    """Participants to be added to the room.

    All required parameters must be populated in order to send to Azure.

    :ivar participants: Participants to add to a room. Required.
    :vartype participants: list[~azure.communication.rooms.models.RoomParticipant]
    """

    _validation = {
        "participants": {"required": True},
    }

    _attribute_map = {
        "participants": {"key": "participants", "type": "[RoomParticipant]"},
    }

    def __init__(self, *, participants: List["_models.RoomParticipant"], **kwargs):
        """
        :keyword participants: Participants to add to a room. Required.
        :paramtype participants: list[~azure.communication.rooms.models.RoomParticipant]
        """
        super().__init__(**kwargs)
        self.participants = participants


class CommunicationError(_serialization.Model):
    """The Communication Services error.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: The error message. Required.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: Further details about specific errors that led to this error.
    :vartype details: list[~azure.communication.rooms.models.CommunicationError]
    :ivar inner_error: The inner error if any.
    :vartype inner_error: ~azure.communication.rooms.models.CommunicationError
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CommunicationError]"},
        "inner_error": {"key": "innererror", "type": "CommunicationError"},
    }

    def __init__(self, *, code: str, message: str, **kwargs):
        """
        :keyword code: The error code. Required.
        :paramtype code: str
        :keyword message: The error message. Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = None
        self.details = None
        self.inner_error = None


class CommunicationErrorResponse(_serialization.Model):
    """The Communication Services error.

    All required parameters must be populated in order to send to Azure.

    :ivar error: The Communication Services error. Required.
    :vartype error: ~azure.communication.rooms.models.CommunicationError
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "CommunicationError"},
    }

    def __init__(self, *, error: "_models.CommunicationError", **kwargs):
        """
        :keyword error: The Communication Services error. Required.
        :paramtype error: ~azure.communication.rooms.models.CommunicationError
        """
        super().__init__(**kwargs)
        self.error = error


class CommunicationIdentifierModel(_serialization.Model):
    """Identifies a participant in Azure Communication services. A participant is, for example, an Azure communication user. This model must be interpreted as a union: Apart from rawId, at most one further property may be set.

    :ivar raw_id: Raw id of the identifier. Optional in requests, required in responses.
    :vartype raw_id: str
    :ivar communication_user: A user that got created with an Azure Communication Services
     resource.
    :vartype communication_user: ~azure.communication.rooms.models.CommunicationUserIdentifierModel
    """

    _attribute_map = {
        "raw_id": {"key": "rawId", "type": "str"},
        "communication_user": {"key": "communicationUser", "type": "CommunicationUserIdentifierModel"},
    }

    def __init__(
        self,
        *,
        raw_id: Optional[str] = None,
        communication_user: Optional["_models.CommunicationUserIdentifierModel"] = None,
        **kwargs
    ):
        """
        :keyword raw_id: Raw id of the identifier. Optional in requests, required in responses.
        :paramtype raw_id: str
        :keyword communication_user: A user that got created with an Azure Communication Services
         resource.
        :paramtype communication_user:
         ~azure.communication.rooms.models.CommunicationUserIdentifierModel
        """
        super().__init__(**kwargs)
        self.raw_id = raw_id
        self.communication_user = communication_user


class CommunicationUserIdentifierModel(_serialization.Model):
    """A user that got created with an Azure Communication Services resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The Id of the communication user. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The Id of the communication user. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class CreateRoomRequest(_serialization.Model):
    """Request payload for creating new room.

    :ivar valid_from: The timestamp from when the room is open for joining. The timestamp is in
     RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_until: The timestamp from when the room can no longer be joined. The timestamp is
     in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype valid_until: ~datetime.datetime
    :ivar room_join_policy: The Policy based on which Participants can join a room. Known values
     are: "InviteOnly" and "CommunicationServiceUsers".
    :vartype room_join_policy: str or ~azure.communication.rooms.models.RoomJoinPolicy
    :ivar participants: (Optional) Collection of participants invited to the room.
    :vartype participants: list[~azure.communication.rooms.models.RoomParticipant]
    """

    _attribute_map = {
        "valid_from": {"key": "validFrom", "type": "iso-8601"},
        "valid_until": {"key": "validUntil", "type": "iso-8601"},
        "room_join_policy": {"key": "roomJoinPolicy", "type": "str"},
        "participants": {"key": "participants", "type": "[RoomParticipant]"},
    }

    def __init__(
        self,
        *,
        valid_from: Optional[datetime.datetime] = None,
        valid_until: Optional[datetime.datetime] = None,
        room_join_policy: Optional[Union[str, "_models.RoomJoinPolicy"]] = None,
        participants: Optional[List["_models.RoomParticipant"]] = None,
        **kwargs
    ):
        """
        :keyword valid_from: The timestamp from when the room is open for joining. The timestamp is in
         RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
        :paramtype valid_from: ~datetime.datetime
        :keyword valid_until: The timestamp from when the room can no longer be joined. The timestamp
         is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
        :paramtype valid_until: ~datetime.datetime
        :keyword room_join_policy: The Policy based on which Participants can join a room. Known values
         are: "InviteOnly" and "CommunicationServiceUsers".
        :paramtype room_join_policy: str or ~azure.communication.rooms.models.RoomJoinPolicy
        :keyword participants: (Optional) Collection of participants invited to the room.
        :paramtype participants: list[~azure.communication.rooms.models.RoomParticipant]
        """
        super().__init__(**kwargs)
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.room_join_policy = room_join_policy
        self.participants = participants


class ParticipantsCollection(_serialization.Model):
    """Collection of participants in a room.

    All required parameters must be populated in order to send to Azure.

    :ivar participants: Room Participants. Required.
    :vartype participants: list[~azure.communication.rooms.models.RoomParticipant]
    """

    _validation = {
        "participants": {"required": True},
    }

    _attribute_map = {
        "participants": {"key": "participants", "type": "[RoomParticipant]"},
    }

    def __init__(self, *, participants: List["_models.RoomParticipant"], **kwargs):
        """
        :keyword participants: Room Participants. Required.
        :paramtype participants: list[~azure.communication.rooms.models.RoomParticipant]
        """
        super().__init__(**kwargs)
        self.participants = participants


class RemoveParticipantsRequest(_serialization.Model):
    """Participants to be removed from a room.

    All required parameters must be populated in order to send to Azure.

    :ivar participants: Participants to be removed from a room. Required.
    :vartype participants: list[~azure.communication.rooms.models.RoomParticipant]
    """

    _validation = {
        "participants": {"required": True},
    }

    _attribute_map = {
        "participants": {"key": "participants", "type": "[RoomParticipant]"},
    }

    def __init__(self, *, participants: List["_models.RoomParticipant"], **kwargs):
        """
        :keyword participants: Participants to be removed from a room. Required.
        :paramtype participants: list[~azure.communication.rooms.models.RoomParticipant]
        """
        super().__init__(**kwargs)
        self.participants = participants


class RoomModel(_serialization.Model):
    """The meeting room.

    :ivar id: Unique identifier of a room. This id is server generated.
    :vartype id: str
    :ivar created_date_time: The timestamp when the room was created at the server. The timestamp
     is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype created_date_time: ~datetime.datetime
    :ivar valid_from: The timestamp from when the room is open for joining. The timestamp is in
     RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_until: The timestamp from when the room can no longer be joined. The timestamp is
     in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype valid_until: ~datetime.datetime
    :ivar room_join_policy: The Policy based on which Participants can join a room. Known values
     are: "InviteOnly" and "CommunicationServiceUsers".
    :vartype room_join_policy: str or ~azure.communication.rooms.models.RoomJoinPolicy
    :ivar participants: Collection of room participants.
    :vartype participants: list[~azure.communication.rooms.models.RoomParticipant]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "valid_from": {"key": "validFrom", "type": "iso-8601"},
        "valid_until": {"key": "validUntil", "type": "iso-8601"},
        "room_join_policy": {"key": "roomJoinPolicy", "type": "str"},
        "participants": {"key": "participants", "type": "[RoomParticipant]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        created_date_time: Optional[datetime.datetime] = None,
        valid_from: Optional[datetime.datetime] = None,
        valid_until: Optional[datetime.datetime] = None,
        room_join_policy: Optional[Union[str, "_models.RoomJoinPolicy"]] = None,
        participants: Optional[List["_models.RoomParticipant"]] = None,
        **kwargs
    ):
        """
        :keyword id: Unique identifier of a room. This id is server generated.
        :paramtype id: str
        :keyword created_date_time: The timestamp when the room was created at the server. The
         timestamp is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
        :paramtype created_date_time: ~datetime.datetime
        :keyword valid_from: The timestamp from when the room is open for joining. The timestamp is in
         RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
        :paramtype valid_from: ~datetime.datetime
        :keyword valid_until: The timestamp from when the room can no longer be joined. The timestamp
         is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
        :paramtype valid_until: ~datetime.datetime
        :keyword room_join_policy: The Policy based on which Participants can join a room. Known values
         are: "InviteOnly" and "CommunicationServiceUsers".
        :paramtype room_join_policy: str or ~azure.communication.rooms.models.RoomJoinPolicy
        :keyword participants: Collection of room participants.
        :paramtype participants: list[~azure.communication.rooms.models.RoomParticipant]
        """
        super().__init__(**kwargs)
        self.id = id
        self.created_date_time = created_date_time
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.room_join_policy = room_join_policy
        self.participants = participants


class RoomParticipant(_serialization.Model):
    """A participant of the room.

    All required parameters must be populated in order to send to Azure.

    :ivar communication_identifier: Identifies a participant in Azure Communication services. A
     participant is, for example, an Azure communication user. This model must be interpreted as a
     union: Apart from rawId, at most one further property may be set. Required.
    :vartype communication_identifier:
     ~azure.communication.rooms.models.CommunicationIdentifierModel
    :ivar role: The Role of a room participant. Known values are: "Presenter", "Attendee", and
     "Consumer".
    :vartype role: str or ~azure.communication.rooms.models.RoleType
    """

    _validation = {
        "communication_identifier": {"required": True},
    }

    _attribute_map = {
        "communication_identifier": {"key": "communicationIdentifier", "type": "CommunicationIdentifierModel"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        communication_identifier: "_models.CommunicationIdentifierModel",
        role: Optional[Union[str, "_models.RoleType"]] = None,
        **kwargs
    ):
        """
        :keyword communication_identifier: Identifies a participant in Azure Communication services. A
         participant is, for example, an Azure communication user. This model must be interpreted as a
         union: Apart from rawId, at most one further property may be set. Required.
        :paramtype communication_identifier:
         ~azure.communication.rooms.models.CommunicationIdentifierModel
        :keyword role: The Role of a room participant. Known values are: "Presenter", "Attendee", and
         "Consumer".
        :paramtype role: str or ~azure.communication.rooms.models.RoleType
        """
        super().__init__(**kwargs)
        self.communication_identifier = communication_identifier
        self.role = role


class UpdateParticipantsRequest(_serialization.Model):
    """Participants to be updated in a room.

    All required parameters must be populated in order to send to Azure.

    :ivar participants: Participants to update in a room. Required.
    :vartype participants: list[~azure.communication.rooms.models.RoomParticipant]
    """

    _validation = {
        "participants": {"required": True},
    }

    _attribute_map = {
        "participants": {"key": "participants", "type": "[RoomParticipant]"},
    }

    def __init__(self, *, participants: List["_models.RoomParticipant"], **kwargs):
        """
        :keyword participants: Participants to update in a room. Required.
        :paramtype participants: list[~azure.communication.rooms.models.RoomParticipant]
        """
        super().__init__(**kwargs)
        self.participants = participants


class UpdateRoomRequest(_serialization.Model):
    """Request payload for updating a room.

    :ivar valid_from: (Optional) The timestamp from when the room is open for joining. The
     timestamp is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype valid_from: ~datetime.datetime
    :ivar valid_until: (Optional) The timestamp from when the room can no longer be joined. The
     timestamp is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype valid_until: ~datetime.datetime
    :ivar room_join_policy: The Policy based on which Participants can join a room. Known values
     are: "InviteOnly" and "CommunicationServiceUsers".
    :vartype room_join_policy: str or ~azure.communication.rooms.models.RoomJoinPolicy
    :ivar participants: Collection of room participants.
    :vartype participants: list[~azure.communication.rooms.models.RoomParticipant]
    """

    _attribute_map = {
        "valid_from": {"key": "validFrom", "type": "iso-8601"},
        "valid_until": {"key": "validUntil", "type": "iso-8601"},
        "room_join_policy": {"key": "roomJoinPolicy", "type": "str"},
        "participants": {"key": "participants", "type": "[RoomParticipant]"},
    }

    def __init__(
        self,
        *,
        valid_from: Optional[datetime.datetime] = None,
        valid_until: Optional[datetime.datetime] = None,
        room_join_policy: Optional[Union[str, "_models.RoomJoinPolicy"]] = None,
        participants: Optional[List["_models.RoomParticipant"]] = None,
        **kwargs
    ):
        """
        :keyword valid_from: (Optional) The timestamp from when the room is open for joining. The
         timestamp is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
        :paramtype valid_from: ~datetime.datetime
        :keyword valid_until: (Optional) The timestamp from when the room can no longer be joined. The
         timestamp is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
        :paramtype valid_until: ~datetime.datetime
        :keyword room_join_policy: The Policy based on which Participants can join a room. Known values
         are: "InviteOnly" and "CommunicationServiceUsers".
        :paramtype room_join_policy: str or ~azure.communication.rooms.models.RoomJoinPolicy
        :keyword participants: Collection of room participants.
        :paramtype participants: list[~azure.communication.rooms.models.RoomParticipant]
        """
        super().__init__(**kwargs)
        self.valid_from = valid_from
        self.valid_until = valid_until
        self.room_join_policy = room_join_policy
        self.participants = participants
