# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._event_hub_management_client_enums import *


class CheckNameAvailabilityParameter(msrest.serialization.Model):
    """Parameter supplied to check Namespace name availability operation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name to check the namespace name availability.
    :vartype name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. Name to check the namespace name availability.
        :paramtype name: str
        """
        super(CheckNameAvailabilityParameter, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The Result of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Value indicating Namespace is availability, true if the Namespace is
     available; otherwise, false.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability of a Namespace. Possible values include: "None",
     "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown",
     "TooManyNamespaceInCurrentSubscription".
    :vartype reason: str or ~azure.mgmt.eventhub.v2015_08_01.models.UnavailableReason
    :ivar message: The detailed info regarding the reason associated with the Namespace.
    :vartype message: str
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "UnavailableReason"]] = None,
        **kwargs
    ):
        """
        :keyword name_available: Value indicating Namespace is availability, true if the Namespace is
         available; otherwise, false.
        :paramtype name_available: bool
        :keyword reason: The reason for unavailability of a Namespace. Possible values include: "None",
         "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown",
         "TooManyNamespaceInCurrentSubscription".
        :paramtype reason: str or ~azure.mgmt.eventhub.v2015_08_01.models.UnavailableReason
        """
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = None


class ConsumerGroupCreateOrUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create Or Update Consumer Group operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. Location of the resource.
    :vartype location: str
    :ivar type: ARM type of the Namespace.
    :vartype type: str
    :ivar name: Name of the consumer group.
    :vartype name: str
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar event_hub_path: The path of the Event Hub.
    :vartype event_hub_path: str
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar user_metadata: The user metadata.
    :vartype user_metadata: str
    """

    _validation = {
        'location': {'required': True},
        'created_at': {'readonly': True},
        'event_hub_path': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'event_hub_path': {'key': 'properties.eventHubPath', 'type': 'str'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'user_metadata': {'key': 'properties.userMetadata', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        type: Optional[str] = None,
        name: Optional[str] = None,
        user_metadata: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Location of the resource.
        :paramtype location: str
        :keyword type: ARM type of the Namespace.
        :paramtype type: str
        :keyword name: Name of the consumer group.
        :paramtype name: str
        :keyword user_metadata: The user metadata.
        :paramtype user_metadata: str
        """
        super(ConsumerGroupCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = location
        self.type = type
        self.name = name
        self.created_at = None
        self.event_hub_path = None
        self.updated_at = None
        self.user_metadata = user_metadata


class ConsumerGroupListResult(msrest.serialization.Model):
    """The result to the List Consumer Group operation.

    :ivar value: Result of the List Consumer Group operation.
    :vartype value: list[~azure.mgmt.eventhub.v2015_08_01.models.ConsumerGroupResource]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Consumer Group.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConsumerGroupResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ConsumerGroupResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Result of the List Consumer Group operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2015_08_01.models.ConsumerGroupResource]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of Consumer Group.
        :paramtype next_link: str
        """
        super(ConsumerGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Resource(msrest.serialization.Model):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.location = location
        self.type = None


class ConsumerGroupResource(Resource):
    """Single item in List or Get Consumer group operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar event_hub_path: The path of the Event Hub.
    :vartype event_hub_path: str
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar user_metadata: The user metadata.
    :vartype user_metadata: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'event_hub_path': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'event_hub_path': {'key': 'properties.eventHubPath', 'type': 'str'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'user_metadata': {'key': 'properties.userMetadata', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        user_metadata: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword user_metadata: The user metadata.
        :paramtype user_metadata: str
        """
        super(ConsumerGroupResource, self).__init__(location=location, **kwargs)
        self.created_at = None
        self.event_hub_path = None
        self.updated_at = None
        self.user_metadata = user_metadata


class EventHubCreateOrUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create Or Update Event Hub operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. Location of the resource.
    :vartype location: str
    :ivar type: ARM type of the Namespace.
    :vartype type: str
    :ivar name: Name of the Event Hub.
    :vartype name: str
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: ~datetime.datetime
    :ivar message_retention_in_days: Number of days to retain the events for this Event Hub.
    :vartype message_retention_in_days: long
    :ivar partition_count: Number of partitions created for the Event Hub.
    :vartype partition_count: long
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :ivar status: Enumerates the possible values for the status of the Event Hub. Possible values
     include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
     "Deleting", "Renaming", "Unknown".
    :vartype status: str or ~azure.mgmt.eventhub.v2015_08_01.models.EntityStatus
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    """

    _validation = {
        'location': {'required': True},
        'created_at': {'readonly': True},
        'partition_ids': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        type: Optional[str] = None,
        name: Optional[str] = None,
        message_retention_in_days: Optional[int] = None,
        partition_count: Optional[int] = None,
        status: Optional[Union[str, "EntityStatus"]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Location of the resource.
        :paramtype location: str
        :keyword type: ARM type of the Namespace.
        :paramtype type: str
        :keyword name: Name of the Event Hub.
        :paramtype name: str
        :keyword message_retention_in_days: Number of days to retain the events for this Event Hub.
        :paramtype message_retention_in_days: long
        :keyword partition_count: Number of partitions created for the Event Hub.
        :paramtype partition_count: long
        :keyword status: Enumerates the possible values for the status of the Event Hub. Possible
         values include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled",
         "Creating", "Deleting", "Renaming", "Unknown".
        :paramtype status: str or ~azure.mgmt.eventhub.v2015_08_01.models.EntityStatus
        """
        super(EventHubCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = location
        self.type = type
        self.name = name
        self.created_at = None
        self.message_retention_in_days = message_retention_in_days
        self.partition_count = partition_count
        self.partition_ids = None
        self.status = status
        self.updated_at = None


class EventHubListResult(msrest.serialization.Model):
    """The result of the List EventHubs operation.

    :ivar value: Result of the List EventHubs operation.
    :vartype value: list[~azure.mgmt.eventhub.v2015_08_01.models.EventHubResource]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of EventHubs.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventHubResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventHubResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Result of the List EventHubs operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2015_08_01.models.EventHubResource]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of EventHubs.
        :paramtype next_link: str
        """
        super(EventHubListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventHubResource(Resource):
    """Single item in List or Get Event Hub operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: ~datetime.datetime
    :ivar message_retention_in_days: Number of days to retain the events for this Event Hub.
    :vartype message_retention_in_days: long
    :ivar partition_count: Number of partitions created for the Event Hub.
    :vartype partition_count: long
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :ivar status: Enumerates the possible values for the status of the Event Hub. Possible values
     include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
     "Deleting", "Renaming", "Unknown".
    :vartype status: str or ~azure.mgmt.eventhub.v2015_08_01.models.EntityStatus
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'partition_ids': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        message_retention_in_days: Optional[int] = None,
        partition_count: Optional[int] = None,
        status: Optional[Union[str, "EntityStatus"]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword message_retention_in_days: Number of days to retain the events for this Event Hub.
        :paramtype message_retention_in_days: long
        :keyword partition_count: Number of partitions created for the Event Hub.
        :paramtype partition_count: long
        :keyword status: Enumerates the possible values for the status of the Event Hub. Possible
         values include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled",
         "Creating", "Deleting", "Renaming", "Unknown".
        :paramtype status: str or ~azure.mgmt.eventhub.v2015_08_01.models.EntityStatus
        """
        super(EventHubResource, self).__init__(location=location, **kwargs)
        self.created_at = None
        self.message_retention_in_days = message_retention_in_days
        self.partition_count = partition_count
        self.partition_ids = None
        self.status = status
        self.updated_at = None


class NamespaceCreateOrUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create Or Update Namespace operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. Namespace location.
    :vartype location: str
    :ivar sku: SKU parameters supplied to the create Namespace operation.
    :vartype sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
    :ivar tags: A set of tags. Namespace tags.
    :vartype tags: dict[str, str]
    :ivar status: State of the Namespace. Possible values include: "Unknown", "Creating",
     "Created", "Activating", "Enabling", "Active", "Disabling", "Disabled", "SoftDeleting",
     "SoftDeleted", "Removing", "Removed", "Failed".
    :vartype status: str or ~azure.mgmt.eventhub.v2015_08_01.models.NamespaceState
    :ivar provisioning_state: Provisioning state of the Namespace.
    :vartype provisioning_state: str
    :ivar created_at: The time the Namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the Namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :ivar enabled: Specifies whether this instance is enabled.
    :vartype enabled: bool
    """

    _validation = {
        'location': {'required': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: Optional["Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "NamespaceState"]] = None,
        provisioning_state: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        service_bus_endpoint: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Namespace location.
        :paramtype location: str
        :keyword sku: SKU parameters supplied to the create Namespace operation.
        :paramtype sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
        :keyword tags: A set of tags. Namespace tags.
        :paramtype tags: dict[str, str]
        :keyword status: State of the Namespace. Possible values include: "Unknown", "Creating",
         "Created", "Activating", "Enabling", "Active", "Disabling", "Disabled", "SoftDeleting",
         "SoftDeleted", "Removing", "Removed", "Failed".
        :paramtype status: str or ~azure.mgmt.eventhub.v2015_08_01.models.NamespaceState
        :keyword provisioning_state: Provisioning state of the Namespace.
        :paramtype provisioning_state: str
        :keyword created_at: The time the Namespace was created.
        :paramtype created_at: ~datetime.datetime
        :keyword updated_at: The time the Namespace was updated.
        :paramtype updated_at: ~datetime.datetime
        :keyword service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
        :paramtype service_bus_endpoint: str
        :keyword enabled: Specifies whether this instance is enabled.
        :paramtype enabled: bool
        """
        super(NamespaceCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = location
        self.sku = sku
        self.tags = tags
        self.status = status
        self.provisioning_state = provisioning_state
        self.created_at = created_at
        self.updated_at = updated_at
        self.service_bus_endpoint = service_bus_endpoint
        self.metric_id = None
        self.enabled = enabled


class NamespaceListResult(msrest.serialization.Model):
    """The response of the List Namespace operation.

    :ivar value: Result of the List Namespace operation.
    :vartype value: list[~azure.mgmt.eventhub.v2015_08_01.models.NamespaceResource]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of namespaces.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NamespaceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NamespaceResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Result of the List Namespace operation.
        :paramtype value: list[~azure.mgmt.eventhub.v2015_08_01.models.NamespaceResource]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of namespaces.
        :paramtype next_link: str
        """
        super(NamespaceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TrackedResource(Resource):
    """Definition of Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(TrackedResource, self).__init__(location=location, **kwargs)
        self.tags = tags


class NamespaceResource(TrackedResource):
    """Single Namespace item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: SKU parameters supplied to the create Namespace operation.
    :vartype sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
    :ivar status: State of the Namespace. Possible values include: "Unknown", "Creating",
     "Created", "Activating", "Enabling", "Active", "Disabling", "Disabled", "SoftDeleting",
     "SoftDeleted", "Removing", "Removed", "Failed".
    :vartype status: str or ~azure.mgmt.eventhub.v2015_08_01.models.NamespaceState
    :ivar provisioning_state: Provisioning state of the Namespace.
    :vartype provisioning_state: str
    :ivar created_at: The time the Namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the Namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :ivar enabled: Specifies whether this instance is enabled.
    :vartype enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        status: Optional[Union[str, "NamespaceState"]] = None,
        provisioning_state: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        service_bus_endpoint: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU parameters supplied to the create Namespace operation.
        :paramtype sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
        :keyword status: State of the Namespace. Possible values include: "Unknown", "Creating",
         "Created", "Activating", "Enabling", "Active", "Disabling", "Disabled", "SoftDeleting",
         "SoftDeleted", "Removing", "Removed", "Failed".
        :paramtype status: str or ~azure.mgmt.eventhub.v2015_08_01.models.NamespaceState
        :keyword provisioning_state: Provisioning state of the Namespace.
        :paramtype provisioning_state: str
        :keyword created_at: The time the Namespace was created.
        :paramtype created_at: ~datetime.datetime
        :keyword updated_at: The time the Namespace was updated.
        :paramtype updated_at: ~datetime.datetime
        :keyword service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
        :paramtype service_bus_endpoint: str
        :keyword enabled: Specifies whether this instance is enabled.
        :paramtype enabled: bool
        """
        super(NamespaceResource, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.status = status
        self.provisioning_state = provisioning_state
        self.created_at = created_at
        self.updated_at = updated_at
        self.service_bus_endpoint = service_bus_endpoint
        self.metric_id = None
        self.enabled = enabled


class NamespaceUpdateParameter(msrest.serialization.Model):
    """Parameters supplied to the Patch/update Namespace operation.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the created Namespace.
    :vartype sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the created Namespace.
        :paramtype sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
        """
        super(NamespaceUpdateParameter, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku


class Operation(msrest.serialization.Model):
    """A Event Hub REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.eventhub.v2015_08_01.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.eventhub.v2015_08_01.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.EventHub.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Invoice, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Event Hub operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Event Hub operations supported by the Microsoft.EventHub resource
     provider.
    :vartype value: list[~azure.mgmt.eventhub.v2015_08_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RegenerateKeysParameters(msrest.serialization.Model):
    """Parameters supplied to the Regenerate Authorization Rule keys operation.

    :ivar policykey: Key that needs to be regenerated. Possible values include: "PrimaryKey",
     "SecondaryKey".
    :vartype policykey: str or ~azure.mgmt.eventhub.v2015_08_01.models.Policykey
    """

    _attribute_map = {
        'policykey': {'key': 'policykey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        policykey: Optional[Union[str, "Policykey"]] = None,
        **kwargs
    ):
        """
        :keyword policykey: Key that needs to be regenerated. Possible values include: "PrimaryKey",
         "SecondaryKey".
        :paramtype policykey: str or ~azure.mgmt.eventhub.v2015_08_01.models.Policykey
        """
        super(RegenerateKeysParameters, self).__init__(**kwargs)
        self.policykey = policykey


class ResourceListKeys(msrest.serialization.Model):
    """Namespace/EventHub Connection String.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_connection_string: Primary connection string of the created Namespace
     AuthorizationRule.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Secondary connection string of the created Namespace
     AuthorizationRule.
    :vartype secondary_connection_string: str
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the AuthorizationRule.
    :vartype key_name: str
    """

    _validation = {
        'primary_connection_string': {'readonly': True},
        'secondary_connection_string': {'readonly': True},
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
        'key_name': {'readonly': True},
    }

    _attribute_map = {
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceListKeys, self).__init__(**kwargs)
        self.primary_connection_string = None
        self.secondary_connection_string = None
        self.primary_key = None
        self.secondary_key = None
        self.key_name = None


class SharedAccessAuthorizationRuleCreateOrUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create Or Update Authorization Rules operation.

    :ivar location: Data center location.
    :vartype location: str
    :ivar name: Name of the AuthorizationRule.
    :vartype name: str
    :ivar rights: The rights associated with the rule.
    :vartype rights: list[str or ~azure.mgmt.eventhub.v2015_08_01.models.AccessRights]
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        name: Optional[str] = None,
        rights: Optional[List[Union[str, "AccessRights"]]] = None,
        **kwargs
    ):
        """
        :keyword location: Data center location.
        :paramtype location: str
        :keyword name: Name of the AuthorizationRule.
        :paramtype name: str
        :keyword rights: The rights associated with the rule.
        :paramtype rights: list[str or ~azure.mgmt.eventhub.v2015_08_01.models.AccessRights]
        """
        super(SharedAccessAuthorizationRuleCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = location
        self.name = name
        self.rights = rights


class SharedAccessAuthorizationRuleListResult(msrest.serialization.Model):
    """The response from the List Namespace operation.

    :ivar value: Result of the List Authorization Rules operation.
    :vartype value:
     list[~azure.mgmt.eventhub.v2015_08_01.models.SharedAccessAuthorizationRuleResource]
    :ivar next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of Authorization Rules.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SharedAccessAuthorizationRuleResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SharedAccessAuthorizationRuleResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Result of the List Authorization Rules operation.
        :paramtype value:
         list[~azure.mgmt.eventhub.v2015_08_01.models.SharedAccessAuthorizationRuleResource]
        :keyword next_link: Link to the next set of results. Not empty if Value contains an incomplete
         list of Authorization Rules.
        :paramtype next_link: str
        """
        super(SharedAccessAuthorizationRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedAccessAuthorizationRuleResource(Resource):
    """Single item in a List or Get AuthorizationRule operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar rights: The rights associated with the rule.
    :vartype rights: list[str or ~azure.mgmt.eventhub.v2015_08_01.models.AccessRights]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        rights: Optional[List[Union[str, "AccessRights"]]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword rights: The rights associated with the rule.
        :paramtype rights: list[str or ~azure.mgmt.eventhub.v2015_08_01.models.AccessRights]
        """
        super(SharedAccessAuthorizationRuleResource, self).__init__(location=location, **kwargs)
        self.rights = rights


class Sku(msrest.serialization.Model):
    """SKU parameters supplied to the create Namespace operation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of this SKU. Possible values include: "Basic", "Standard".
    :vartype name: str or ~azure.mgmt.eventhub.v2015_08_01.models.SkuName
    :ivar tier: Required. The billing tier of this particular SKU. Possible values include:
     "Basic", "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.eventhub.v2015_08_01.models.SkuTier
    :ivar capacity: The Event Hubs throughput units.
    :vartype capacity: int
    """

    _validation = {
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        tier: Union[str, "SkuTier"],
        name: Optional[Union[str, "SkuName"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: Name of this SKU. Possible values include: "Basic", "Standard".
        :paramtype name: str or ~azure.mgmt.eventhub.v2015_08_01.models.SkuName
        :keyword tier: Required. The billing tier of this particular SKU. Possible values include:
         "Basic", "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.eventhub.v2015_08_01.models.SkuTier
        :keyword capacity: The Event Hubs throughput units.
        :paramtype capacity: int
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity
