#!/bin/sh
#
# Copyright (c) 2006 Shawn Pearce
#

test_description='git reset should cull empty subdirs'

. ./test-lib.sh
. "$TEST_DIRECTORY"/lib-diff-data.sh

test_expect_success 'creating initial files' '
	mkdir path0 &&
	COPYING_test_data >path0/COPYING &&
	git add path0/COPYING &&
	git commit -m add -a
'

test_expect_success 'creating second files' '
	mkdir path1 &&
	mkdir path1/path2 &&
	COPYING_test_data >path1/path2/COPYING &&
	COPYING_test_data >path1/COPYING &&
	COPYING_test_data >COPYING &&
	COPYING_test_data >path0/COPYING-TOO &&
	git add path1/path2/COPYING &&
	git add path1/COPYING &&
	git add COPYING &&
	git add path0/COPYING-TOO &&
	git commit -m change -a
'

test_expect_success 'resetting tree HEAD^' '
	git reset --hard HEAD^
'

test_expect_success 'checking initial files exist after rewind' '
	test_path_is_dir path0 &&
	test_path_is_file path0/COPYING
'

test_expect_success 'checking lack of path1/path2/COPYING' '
	test_path_is_missing path1/path2/COPYING
'

test_expect_success 'checking lack of path1/COPYING' '
	test_path_is_missing path1/COPYING
'

test_expect_success 'checking lack of COPYING' '
	test_path_is_missing COPYING
'

test_expect_success 'checking lack of path0/COPYING-TOO' '
	test_path_is_missing path0/COPYING-TOO
'

test_expect_success 'checking lack of path1/path2' '
	test_path_is_missing path1/path2
'

test_expect_success 'checking lack of path1' '
	test_path_is_missing path1
'

test_done
