# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .arm_base_model_py3 import ARMBaseModel


class DataBoxEdgeDevice(ARMBaseModel):
    """The Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param location: Required. The location of the device. This is a supported
     and registered Azure geographical region (for example, West US, East US,
     or Southeast Asia). The geographical region of a device cannot be changed
     once it is created, but if an identical geographical region is specified
     on update, the request will succeed.
    :type location: str
    :param tags: The list of tags that describe the device. These tags can be
     used to view and group this device (across resource groups).
    :type tags: dict[str, str]
    :param sku: The SKU type.
    :type sku: ~azure.mgmt.edgegateway.models.Sku
    :param etag: The etag for the devices.
    :type etag: str
    :param data_box_edge_device_status: The status of the Data Box
     Edge/Gateway device. Possible values include: 'ReadyToSetup', 'Online',
     'Offline', 'NeedsAttention', 'Disconnected', 'PartiallyDisconnected'
    :type data_box_edge_device_status: str or
     ~azure.mgmt.edgegateway.models.DataBoxEdgeDeviceStatus
    :ivar serial_number: The Serial Number of Data Box Edge/Gateway device.
    :vartype serial_number: str
    :param description: The Description of the Data Box Edge/Gateway device.
    :type description: str
    :param model_description: The description of the Data Box Edge/Gateway
     device model.
    :type model_description: str
    :ivar device_type: The type of the Data Box Edge/Gateway device. Possible
     values include: 'DataBoxEdgeDevice'
    :vartype device_type: str or ~azure.mgmt.edgegateway.models.DeviceType
    :param friendly_name: The Data Box Edge/Gateway device name.
    :type friendly_name: str
    :ivar culture: The Data Box Edge/Gateway device culture.
    :vartype culture: str
    :ivar device_model: The Data Box Edge/Gateway device model.
    :vartype device_model: str
    :ivar device_software_version: The Data Box Edge/Gateway device software
     version.
    :vartype device_software_version: str
    :ivar device_local_capacity: The Data Box Edge/Gateway device local
     capacity in MB.
    :vartype device_local_capacity: long
    :ivar time_zone: The Data Box Edge/Gateway device timezone.
    :vartype time_zone: str
    :ivar device_hcs_version: The device software version number of the device
     (eg: 1.2.18105.6).
    :vartype device_hcs_version: str
    :ivar configured_role_types: Type of compute roles configured.
    :vartype configured_role_types: list[str or
     ~azure.mgmt.edgegateway.models.RoleTypes]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'serial_number': {'readonly': True},
        'device_type': {'readonly': True},
        'culture': {'readonly': True},
        'device_model': {'readonly': True},
        'device_software_version': {'readonly': True},
        'device_local_capacity': {'readonly': True},
        'time_zone': {'readonly': True},
        'device_hcs_version': {'readonly': True},
        'configured_role_types': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'data_box_edge_device_status': {'key': 'properties.dataBoxEdgeDeviceStatus', 'type': 'str'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'model_description': {'key': 'properties.modelDescription', 'type': 'str'},
        'device_type': {'key': 'properties.deviceType', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'culture': {'key': 'properties.culture', 'type': 'str'},
        'device_model': {'key': 'properties.deviceModel', 'type': 'str'},
        'device_software_version': {'key': 'properties.deviceSoftwareVersion', 'type': 'str'},
        'device_local_capacity': {'key': 'properties.deviceLocalCapacity', 'type': 'long'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'device_hcs_version': {'key': 'properties.deviceHcsVersion', 'type': 'str'},
        'configured_role_types': {'key': 'properties.configuredRoleTypes', 'type': '[str]'},
    }

    def __init__(self, *, location: str, tags=None, sku=None, etag: str=None, data_box_edge_device_status=None, description: str=None, model_description: str=None, friendly_name: str=None, **kwargs) -> None:
        super(DataBoxEdgeDevice, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.sku = sku
        self.etag = etag
        self.data_box_edge_device_status = data_box_edge_device_status
        self.serial_number = None
        self.description = description
        self.model_description = model_description
        self.device_type = None
        self.friendly_name = friendly_name
        self.culture = None
        self.device_model = None
        self.device_software_version = None
        self.device_local_capacity = None
        self.time_zone = None
        self.device_hcs_version = None
        self.configured_role_types = None
