# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class ConfidenceLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Degree of confidence on the impact being a platform issue."""

    LOW = "Low"
    """Low confidence on azure being the source of impact"""
    MEDIUM = "Medium"
    """Medium confidence on azure being the source of impact"""
    HIGH = "High"
    """High confidence on azure being the source of impact"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class IncidentSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of incident interfaces."""

    AZURE_DEVOPS = "AzureDevops"
    """When source of Incident is AzureDevops"""
    ICM = "ICM"
    """When source of Incident is Microsoft ICM"""
    JIRA = "Jira"
    """When source of Incident is Jira"""
    SERVICE_NOW = "ServiceNow"
    """When source of Incident is ServiceNow"""
    OTHER = "Other"
    """When source of Incident is Other"""


class MetricUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of unit of the metric."""

    BYTE_SECONDS = "ByteSeconds"
    """When measurement is in ByteSeconds"""
    BYTES = "Bytes"
    """When measurement is in Bytes"""
    BYTES_PER_SECOND = "BytesPerSecond"
    """When measurement is in BytesPerSecond"""
    CORES = "Cores"
    """When measurement is in Cores"""
    COUNT = "Count"
    """When measurement is in Count"""
    COUNT_PER_SECOND = "CountPerSecond"
    """When measurement is in CountPerSecond"""
    MILLI_CORES = "MilliCores"
    """When measurement is in MilliCores"""
    MILLI_SECONDS = "MilliSeconds"
    """When measurement is in MilliSeconds"""
    NANO_CORES = "NanoCores"
    """When measurement is in NanoCores"""
    PERCENT = "Percent"
    """When measurement is in Percent"""
    SECONDS = "Seconds"
    """When measurement is in Seconds"""
    OTHER = "Other"
    """When measurement is in Other than listed"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class Platform(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for connector types."""

    AZURE_MONITOR = "AzureMonitor"
    """Type of Azure Monitor"""


class Protocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of protocols."""

    TCP = "TCP"
    """When communication protocol is TCP"""
    UDP = "UDP"
    """When communication protocol is UDP"""
    HTTP = "HTTP"
    """When communication protocol is HTTP"""
    HTTPS = "HTTPS"
    """When communication protocol is HTTPS"""
    RDP = "RDP"
    """When communication protocol is RDP"""
    FTP = "FTP"
    """When communication protocol is FTP"""
    SSH = "SSH"
    """When communication protocol is SSH"""
    OTHER = "Other"
    """When communication protocol is Other"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    """Provisioning Succeeded"""
    FAILED = "Failed"
    """Provisioning Failed"""
    CANCELED = "Canceled"
    """Provisioning Canceled"""


class Toolset(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of azure interfaces."""

    TERRAFORM = "Terraform"
    """If communication toolset is Terraform"""
    PUPPET = "Puppet"
    """If communication toolset is Puppet"""
    CHEF = "Chef"
    """If communication toolset is Chef"""
    SDK = "SDK"
    """If communication toolset is SDK"""
    ANSIBLE = "Ansible"
    """If communication toolset is Ansible"""
    ARM = "ARM"
    """If communication toolset is ARM"""
    PORTAL = "Portal"
    """If communication toolset is Portal"""
    SHELL = "Shell"
    """If communication toolset is Shell"""
    OTHER = "Other"
    """If communication toolset is Other"""
