# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AssessmentSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the assessment severity."""

    HIGH = "High"
    MEDIUM = "Medium"
    LOW = "Low"


class CategoryStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the category status."""

    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"


class CategoryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the compliance category type."""

    FULLY_AUTOMATED = "FullyAutomated"
    PARTIALLY_AUTOMATED = "PartiallyAutomated"
    MANUAL = "Manual"


class ComplianceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The compliance result's status."""

    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"


class ControlFamilyStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the control family status."""

    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"


class ControlFamilyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the control family type."""

    FULLY_AUTOMATED = "FullyAutomated"
    PARTIALLY_AUTOMATED = "PartiallyAutomated"
    MANUAL = "Manual"


class ControlStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the control status."""

    PASSED = "Passed"
    FAILED = "Failed"
    NOT_APPLICABLE = "NotApplicable"


class ControlType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the control type."""

    FULLY_AUTOMATED = "FullyAutomated"
    PARTIALLY_AUTOMATED = "PartiallyAutomated"
    MANUAL = "Manual"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DownloadType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the download type."""

    COMPLIANCE_REPORT = "ComplianceReport"
    COMPLIANCE_PDF_REPORT = "CompliancePdfReport"
    COMPLIANCE_DETAILED_PDF_REPORT = "ComplianceDetailedPdfReport"
    RESOURCE_LIST = "ResourceList"


class IsPass(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether all the resource(s) are compliant."""

    TRUE = "True"
    FALSE = "False"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource provisioning states."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    CREATING = "Creating"
    DELETING = "Deleting"
    UPDATING = "Updating"


class ReportStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Report status."""

    ACTIVE = "Active"
    FAILED = "Failed"
    DISABLED = "Disabled"


class ResourceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the resource status."""

    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    NOT_APPLICABLE = "NotApplicable"
