# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class Configuration(ProxyResource):
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param value: Value of the configuration.
    :type value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration.
    :vartype data_type: str
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :param source: Source of the configuration.
    :type source: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'default_value': {'readonly': True},
        'data_type': {'readonly': True},
        'allowed_values': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'default_value': {'key': 'properties.defaultValue', 'type': 'str'},
        'data_type': {'key': 'properties.dataType', 'type': 'str'},
        'allowed_values': {'key': 'properties.allowedValues', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Configuration, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = kwargs.get('source', None)


class ConfigurationListResult(msrest.serialization.Model):
    """A list of server configurations.

    :param value: The list of server configurations.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.Configuration]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Configuration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Database(ProxyResource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param charset: The charset of the database.
    :type charset: str
    :param collation: The collation of the database.
    :type collation: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'charset': {'key': 'properties.charset', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.charset = kwargs.get('charset', None)
        self.collation = kwargs.get('collation', None)


class DatabaseListResult(msrest.serialization.Model):
    """A List of databases.

    :param value: The list of databases housed in a server.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.Database]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.rdbms.postgresql.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.rdbms.postgresql.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param start_ip_address: Required. The start IP address of the server firewall rule. Must be
     IPv4 format.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the server firewall rule. Must be IPv4
     format.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
        'end_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRule, self).__init__(**kwargs)
        self.start_ip_address = kwargs['start_ip_address']
        self.end_ip_address = kwargs['end_ip_address']


class FirewallRuleListResult(msrest.serialization.Model):
    """A list of firewall rules.

    :param value: The list of firewall rules in a server.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.FirewallRule]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class LogFile(ProxyResource):
    """Represents a log file.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param size_in_kb: Size of the log file.
    :type size_in_kb: long
    :ivar created_time: Creation timestamp of the log file.
    :vartype created_time: ~datetime.datetime
    :ivar last_modified_time: Last modified timestamp of the log file.
    :vartype last_modified_time: ~datetime.datetime
    :param type_properties_type: Type of the log file.
    :type type_properties_type: str
    :param url: The url to download the log file from.
    :type url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'size_in_kb': {'key': 'properties.sizeInKB', 'type': 'long'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogFile, self).__init__(**kwargs)
        self.size_in_kb = kwargs.get('size_in_kb', None)
        self.created_time = None
        self.last_modified_time = None
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.url = kwargs.get('url', None)


class LogFileListResult(msrest.serialization.Model):
    """A list of log files.

    :param value: The list of log files.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.LogFile]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LogFile]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogFileListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class NameAvailability(msrest.serialization.Model):
    """Represents a resource name availability.

    :param message: Error Message.
    :type message: str
    :param name_available: Indicates whether the resource name is available.
    :type name_available: bool
    :param reason: Reason for name being unavailable.
    :type reason: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailability, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)


class NameAvailabilityRequest(msrest.serialization.Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Resource type used for verification.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs.get('type', None)


class Operation(msrest.serialization.Model):
    """REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation or action.
    :vartype display: ~azure.mgmt.rdbms.postgresql.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values include: "NotSpecified",
     "user", "system".
    :vartype origin: str or ~azure.mgmt.rdbms.postgresql.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, any]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of resource provider operations.

    :param value: The list of resource provider operations.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PerformanceTierListResult(msrest.serialization.Model):
    """A list of performance tiers.

    :param value: The list of performance tiers.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.PerformanceTierProperties]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerformanceTierProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerformanceTierListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PerformanceTierProperties(msrest.serialization.Model):
    """Performance tier properties.

    :param id: ID of the performance tier.
    :type id: str
    :param max_backup_retention_days: Maximum Backup retention in days for the performance tier
     edition.
    :type max_backup_retention_days: int
    :param min_backup_retention_days: Minimum Backup retention in days for the performance tier
     edition.
    :type min_backup_retention_days: int
    :param max_storage_mb: Max storage allowed for a server.
    :type max_storage_mb: int
    :param min_large_storage_mb: Max storage allowed for a server.
    :type min_large_storage_mb: int
    :param max_large_storage_mb: Max storage allowed for a server.
    :type max_large_storage_mb: int
    :param min_storage_mb: Max storage allowed for a server.
    :type min_storage_mb: int
    :param service_level_objectives: Service level objectives associated with the performance tier.
    :type service_level_objectives:
     list[~azure.mgmt.rdbms.postgresql.models.PerformanceTierServiceLevelObjectives]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'int'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'int'},
        'max_storage_mb': {'key': 'maxStorageMB', 'type': 'int'},
        'min_large_storage_mb': {'key': 'minLargeStorageMB', 'type': 'int'},
        'max_large_storage_mb': {'key': 'maxLargeStorageMB', 'type': 'int'},
        'min_storage_mb': {'key': 'minStorageMB', 'type': 'int'},
        'service_level_objectives': {'key': 'serviceLevelObjectives', 'type': '[PerformanceTierServiceLevelObjectives]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerformanceTierProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.max_backup_retention_days = kwargs.get('max_backup_retention_days', None)
        self.min_backup_retention_days = kwargs.get('min_backup_retention_days', None)
        self.max_storage_mb = kwargs.get('max_storage_mb', None)
        self.min_large_storage_mb = kwargs.get('min_large_storage_mb', None)
        self.max_large_storage_mb = kwargs.get('max_large_storage_mb', None)
        self.min_storage_mb = kwargs.get('min_storage_mb', None)
        self.service_level_objectives = kwargs.get('service_level_objectives', None)


class PerformanceTierServiceLevelObjectives(msrest.serialization.Model):
    """Service level objectives for performance tier.

    :param id: ID for the service level objective.
    :type id: str
    :param edition: Edition of the performance tier.
    :type edition: str
    :param v_core: vCore associated with the service level objective.
    :type v_core: int
    :param hardware_generation: Hardware generation associated with the service level objective.
    :type hardware_generation: str
    :param max_backup_retention_days: Maximum Backup retention in days for the performance tier
     edition.
    :type max_backup_retention_days: int
    :param min_backup_retention_days: Minimum Backup retention in days for the performance tier
     edition.
    :type min_backup_retention_days: int
    :param max_storage_mb: Max storage allowed for a server.
    :type max_storage_mb: int
    :param min_storage_mb: Max storage allowed for a server.
    :type min_storage_mb: int
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'edition': {'key': 'edition', 'type': 'str'},
        'v_core': {'key': 'vCore', 'type': 'int'},
        'hardware_generation': {'key': 'hardwareGeneration', 'type': 'str'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'int'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'int'},
        'max_storage_mb': {'key': 'maxStorageMB', 'type': 'int'},
        'min_storage_mb': {'key': 'minStorageMB', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerformanceTierServiceLevelObjectives, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.edition = kwargs.get('edition', None)
        self.v_core = kwargs.get('v_core', None)
        self.hardware_generation = kwargs.get('hardware_generation', None)
        self.max_backup_retention_days = kwargs.get('max_backup_retention_days', None)
        self.min_backup_retention_days = kwargs.get('min_backup_retention_days', None)
        self.max_storage_mb = kwargs.get('max_storage_mb', None)
        self.min_storage_mb = kwargs.get('min_storage_mb', None)


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointProperty(msrest.serialization.Model):
    """PrivateEndpointProperty.

    :param id: Resource id of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties: ~azure.mgmt.rdbms.postgresql.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = None


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None


class PrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """PrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status.
    :type status: str
    :param description: Required. The private link service connection description.
    :type description: str
    :ivar actions_required: The actions required for private link service connection.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.description = kwargs['description']
        self.actions_required = None


class RecoverableServerResource(ProxyResource):
    """A recoverable server resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar last_available_backup_date_time: The last available backup date time.
    :vartype last_available_backup_date_time: str
    :ivar service_level_objective: The service level objective.
    :vartype service_level_objective: str
    :ivar edition: Edition of the performance tier.
    :vartype edition: str
    :ivar v_core: vCore associated with the service level objective.
    :vartype v_core: int
    :ivar hardware_generation: Hardware generation associated with the service level objective.
    :vartype hardware_generation: str
    :ivar version: The PostgreSQL version.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_available_backup_date_time': {'readonly': True},
        'service_level_objective': {'readonly': True},
        'edition': {'readonly': True},
        'v_core': {'readonly': True},
        'hardware_generation': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_available_backup_date_time': {'key': 'properties.lastAvailableBackupDateTime', 'type': 'str'},
        'service_level_objective': {'key': 'properties.serviceLevelObjective', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'v_core': {'key': 'properties.vCore', 'type': 'int'},
        'hardware_generation': {'key': 'properties.hardwareGeneration', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoverableServerResource, self).__init__(**kwargs)
        self.last_available_backup_date_time = None
        self.service_level_objective = None
        self.edition = None
        self.v_core = None
        self.hardware_generation = None
        self.version = None


class ResourceIdentity(msrest.serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :param type: The identity type. Set this to 'SystemAssigned' in order to automatically create
     and assign an Azure Active Directory principal for the resource. Possible values include:
     "SystemAssigned".
    :type type: str or ~azure.mgmt.rdbms.postgresql.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.type = kwargs.get('type', None)
        self.tenant_id = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :param administrator_login: The administrator's login name of a server. Can only be specified
     when the server is being created (and is required for creation).
    :type administrator_login: str
    :param version: Server version. Possible values include: "9.5", "9.6", "10", "10.0", "10.2",
     "11".
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server. Possible values
     include: "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :type minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar byok_enforcement: Status showing whether the server data encryption is enabled with
     customer-managed keys.
    :vartype byok_enforcement: str
    :param infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Possible values include: "Enabled", "Disabled".
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param user_visible_state: A state of a server that is visible to user. Possible values
     include: "Ready", "Dropping", "Disabled", "Inaccessible".
    :type user_visible_state: str or ~azure.mgmt.rdbms.postgresql.models.ServerState
    :param fully_qualified_domain_name: The fully qualified domain name of a server.
    :type fully_qualified_domain_name: str
    :param earliest_restore_date: Earliest restore point creation time (ISO8601 format).
    :type earliest_restore_date: ~datetime.datetime
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param replication_role: The replication role of the server.
    :type replication_role: str
    :param master_server_id: The master server id of a replica server.
    :type master_server_id: str
    :param replica_capacity: The maximum number of replicas that a master server can have.
    :type replica_capacity: int
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar private_endpoint_connections: List of private endpoint connections on a server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.rdbms.postgresql.models.ServerPrivateEndpointConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'byok_enforcement': {'readonly': True},
        'replica_capacity': {'minimum': 0},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'byok_enforcement': {'key': 'properties.byokEnforcement', 'type': 'str'},
        'infrastructure_encryption': {'key': 'properties.infrastructureEncryption', 'type': 'str'},
        'user_visible_state': {'key': 'properties.userVisibleState', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'master_server_id': {'key': 'properties.masterServerId', 'type': 'str'},
        'replica_capacity': {'key': 'properties.replicaCapacity', 'type': 'int'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ServerPrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Server, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.administrator_login = kwargs.get('administrator_login', None)
        self.version = kwargs.get('version', None)
        self.ssl_enforcement = kwargs.get('ssl_enforcement', None)
        self.minimal_tls_version = kwargs.get('minimal_tls_version', None)
        self.byok_enforcement = None
        self.infrastructure_encryption = kwargs.get('infrastructure_encryption', None)
        self.user_visible_state = kwargs.get('user_visible_state', None)
        self.fully_qualified_domain_name = kwargs.get('fully_qualified_domain_name', None)
        self.earliest_restore_date = kwargs.get('earliest_restore_date', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.replication_role = kwargs.get('replication_role', None)
        self.master_server_id = kwargs.get('master_server_id', None)
        self.replica_capacity = kwargs.get('replica_capacity', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.private_endpoint_connections = None


class ServerAdministratorResource(ProxyResource):
    """Represents a and external administrator to be created.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param administrator_type: The type of administrator. The only acceptable values to pass in are
     None and "ActiveDirectory". The default value is None.
    :type administrator_type: str
    :param login: The server administrator login account name.
    :type login: str
    :param sid: The server administrator Sid (Secure ID).
    :type sid: str
    :param tenant_id: The server Active Directory Administrator tenant id.
    :type tenant_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerAdministratorResource, self).__init__(**kwargs)
        self.administrator_type = kwargs.get('administrator_type', None)
        self.login = kwargs.get('login', None)
        self.sid = kwargs.get('sid', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class ServerAdministratorResourceListResult(msrest.serialization.Model):
    """The response to a list Active Directory Administrators request.

    :param value: The list of server Active Directory Administrators for the server.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.ServerAdministratorResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerAdministratorResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerAdministratorResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ServerForCreate(msrest.serialization.Model):
    """Represents a server to be created.

    All required parameters must be populated in order to send to Azure.

    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :param properties: Required. Properties of the server.
    :type properties: ~azure.mgmt.rdbms.postgresql.models.ServerPropertiesForCreate
    :param location: Required. The location the resource resides in.
    :type location: str
    :param tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'properties': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'properties': {'key': 'properties', 'type': 'ServerPropertiesForCreate'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerForCreate, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.properties = kwargs['properties']
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class ServerKey(ProxyResource):
    """A PostgreSQL Server key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Kind of encryption protector used to protect the key.
    :vartype kind: str
    :param server_key_type: The key type like 'AzureKeyVault'. Possible values include:
     "AzureKeyVault".
    :type server_key_type: str or ~azure.mgmt.rdbms.postgresql.models.ServerKeyType
    :param uri: The URI of the key.
    :type uri: str
    :ivar creation_date: The key creation date.
    :vartype creation_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'creation_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerKey, self).__init__(**kwargs)
        self.kind = None
        self.server_key_type = kwargs.get('server_key_type', None)
        self.uri = kwargs.get('uri', None)
        self.creation_date = None


class ServerKeyListResult(msrest.serialization.Model):
    """A list of PostgreSQL Server keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of PostgreSQL Server keys.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.ServerKey]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerKey]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerKeyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerListResult(msrest.serialization.Model):
    """A list of servers.

    :param value: The list of servers.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.Server]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Server]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ServerPrivateEndpointConnection(msrest.serialization.Model):
    """A private endpoint connection under a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the Private Endpoint Connection.
    :vartype id: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties:
     ~azure.mgmt.rdbms.postgresql.models.ServerPrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ServerPrivateEndpointConnectionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.properties = None


class ServerPrivateEndpointConnectionProperties(msrest.serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.rdbms.postgresql.models.ServerPrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection. Possible values include:
     "Approving", "Ready", "Dropping", "Failed", "Rejecting".
    :vartype provisioning_state: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'ServerPrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class ServerPrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """ServerPrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status. Possible values include:
     "Approved", "Pending", "Rejected", "Disconnected".
    :type status: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateStatus
    :param description: Required. The private link service connection description.
    :type description: str
    :ivar actions_required: The actions required for private link service connection. Possible
     values include: "None".
    :vartype actions_required: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateActionsRequire
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.description = kwargs['description']
        self.actions_required = None


class ServerPropertiesForCreate(msrest.serialization.Model):
    """The properties used to create a new server.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServerPropertiesForDefaultCreate, ServerPropertiesForGeoRestore, ServerPropertiesForRestore, ServerPropertiesForReplica.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "9.5", "9.6", "10", "10.0", "10.2",
     "11".
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server. Possible values
     include: "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :type minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Possible values include: "Enabled", "Disabled".
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    """

    _validation = {
        'create_mode': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
    }

    _subtype_map = {
        'create_mode': {'Default': 'ServerPropertiesForDefaultCreate', 'GeoRestore': 'ServerPropertiesForGeoRestore', 'PointInTimeRestore': 'ServerPropertiesForRestore', 'Replica': 'ServerPropertiesForReplica'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPropertiesForCreate, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.ssl_enforcement = kwargs.get('ssl_enforcement', None)
        self.minimal_tls_version = kwargs.get('minimal_tls_version', None)
        self.infrastructure_encryption = kwargs.get('infrastructure_encryption', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.create_mode = None  # type: Optional[str]


class ServerPropertiesForDefaultCreate(ServerPropertiesForCreate):
    """The properties used to create a new server.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "9.5", "9.6", "10", "10.0", "10.2",
     "11".
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server. Possible values
     include: "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :type minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Possible values include: "Enabled", "Disabled".
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    :param administrator_login: Required. The administrator's login name of a server. Can only be
     specified when the server is being created (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: Required. The password of the administrator login.
    :type administrator_login_password: str
    """

    _validation = {
        'create_mode': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPropertiesForDefaultCreate, self).__init__(**kwargs)
        self.create_mode = 'Default'  # type: str
        self.administrator_login = kwargs['administrator_login']
        self.administrator_login_password = kwargs['administrator_login_password']


class ServerPropertiesForGeoRestore(ServerPropertiesForCreate):
    """The properties used to create a new server by restoring to a different region from a geo replicated backup.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "9.5", "9.6", "10", "10.0", "10.2",
     "11".
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server. Possible values
     include: "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :type minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Possible values include: "Enabled", "Disabled".
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    :param source_server_id: Required. The source server id to restore from.
    :type source_server_id: str
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPropertiesForGeoRestore, self).__init__(**kwargs)
        self.create_mode = 'GeoRestore'  # type: str
        self.source_server_id = kwargs['source_server_id']


class ServerPropertiesForReplica(ServerPropertiesForCreate):
    """The properties to create a new replica.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "9.5", "9.6", "10", "10.0", "10.2",
     "11".
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server. Possible values
     include: "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :type minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Possible values include: "Enabled", "Disabled".
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    :param source_server_id: Required. The master server id to create replica from.
    :type source_server_id: str
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPropertiesForReplica, self).__init__(**kwargs)
        self.create_mode = 'Replica'  # type: str
        self.source_server_id = kwargs['source_server_id']


class ServerPropertiesForRestore(ServerPropertiesForCreate):
    """The properties used to create a new server by restoring from a backup.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: "9.5", "9.6", "10", "10.0", "10.2",
     "11".
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server. Possible values
     include: "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :type minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Possible values include: "Enabled", "Disabled".
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. The mode to create a new server.Constant filled by server.
     Possible values include: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :type create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    :param source_server_id: Required. The source server id to restore from.
    :type source_server_id: str
    :param restore_point_in_time: Required. Restore point creation time (ISO8601 format),
     specifying the time to restore from.
    :type restore_point_in_time: ~datetime.datetime
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
        'restore_point_in_time': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
        'restore_point_in_time': {'key': 'restorePointInTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPropertiesForRestore, self).__init__(**kwargs)
        self.create_mode = 'PointInTimeRestore'  # type: str
        self.source_server_id = kwargs['source_server_id']
        self.restore_point_in_time = kwargs['restore_point_in_time']


class ServerSecurityAlertPolicy(ProxyResource):
    """A server security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param state: Specifies the state of the policy, whether it is enabled or disabled. Possible
     values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.rdbms.postgresql.models.ServerSecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly.
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :type retention_days: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.disabled_alerts = kwargs.get('disabled_alerts', None)
        self.email_addresses = kwargs.get('email_addresses', None)
        self.email_account_admins = kwargs.get('email_account_admins', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)


class ServerSecurityAlertPolicyListResult(msrest.serialization.Model):
    """A list of the server's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.ServerSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerSecurityAlertPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerSecurityAlertPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerUpdateParameters(msrest.serialization.Model):
    """Parameters allowed to update for a server.

    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :param tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param administrator_login_password: The password of the administrator login.
    :type administrator_login_password: str
    :param version: The version of a server. Possible values include: "9.5", "9.6", "10", "10.0",
     "10.2", "11".
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to server. Possible values
     include: "Enabled", "Disabled".
    :type ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server. Possible values
     include: "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :type minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param replication_role: The replication role of the server.
    :type replication_role: str
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerUpdateParameters, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.version = kwargs.get('version', None)
        self.ssl_enforcement = kwargs.get('ssl_enforcement', None)
        self.minimal_tls_version = kwargs.get('minimal_tls_version', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.replication_role = kwargs.get('replication_role', None)


class Sku(msrest.serialization.Model):
    """Billing information related properties of a server.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1,
     GP_Gen5_8.
    :type name: str
    :param tier: The tier of the particular SKU, e.g. Basic. Possible values include: "Basic",
     "GeneralPurpose", "MemoryOptimized".
    :type tier: str or ~azure.mgmt.rdbms.postgresql.models.SkuTier
    :param capacity: The scale up/out capacity, representing server's compute units.
    :type capacity: int
    :param size: The size code, to be interpreted by resource as appropriate.
    :type size: str
    :param family: The family of hardware.
    :type family: str
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)


class StorageProfile(msrest.serialization.Model):
    """Storage Profile properties of a server.

    :param backup_retention_days: Backup retention days for the server.
    :type backup_retention_days: int
    :param geo_redundant_backup: Enable Geo-redundant or not for server backup. Possible values
     include: "Enabled", "Disabled".
    :type geo_redundant_backup: str or ~azure.mgmt.rdbms.postgresql.models.GeoRedundantBackup
    :param storage_mb: Max storage allowed for a server.
    :type storage_mb: int
    :param storage_autogrow: Enable Storage Auto Grow. Possible values include: "Enabled",
     "Disabled".
    :type storage_autogrow: str or ~azure.mgmt.rdbms.postgresql.models.StorageAutogrow
    """

    _attribute_map = {
        'backup_retention_days': {'key': 'backupRetentionDays', 'type': 'int'},
        'geo_redundant_backup': {'key': 'geoRedundantBackup', 'type': 'str'},
        'storage_mb': {'key': 'storageMB', 'type': 'int'},
        'storage_autogrow': {'key': 'storageAutogrow', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.backup_retention_days = kwargs.get('backup_retention_days', None)
        self.geo_redundant_backup = kwargs.get('geo_redundant_backup', None)
        self.storage_mb = kwargs.get('storage_mb', None)
        self.storage_autogrow = kwargs.get('storage_autogrow', None)


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class VirtualNetworkRule(ProxyResource):
    """A virtual network rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param virtual_network_subnet_id: The ARM resource id of the virtual network subnet.
    :type virtual_network_subnet_id: str
    :param ignore_missing_vnet_service_endpoint: Create firewall rule before the virtual network
     has vnet service endpoint enabled.
    :type ignore_missing_vnet_service_endpoint: bool
    :ivar state: Virtual Network Rule State. Possible values include: "Initializing", "InProgress",
     "Ready", "Deleting", "Unknown".
    :vartype state: str or ~azure.mgmt.rdbms.postgresql.models.VirtualNetworkRuleState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
        'ignore_missing_vnet_service_endpoint': {'key': 'properties.ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_subnet_id = kwargs.get('virtual_network_subnet_id', None)
        self.ignore_missing_vnet_service_endpoint = kwargs.get('ignore_missing_vnet_service_endpoint', None)
        self.state = None


class VirtualNetworkRuleListResult(msrest.serialization.Model):
    """A list of virtual network rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.VirtualNetworkRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
