# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessRecommendationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The feature- generated recommendation shown to the reviewer.
    """

    APPROVE = "Approve"
    DENY = "Deny"
    NO_INFO_AVAILABLE = "NoInfoAvailable"

class AccessReviewActorIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type : user/servicePrincipal
    """

    USER = "user"
    SERVICE_PRINCIPAL = "servicePrincipal"

class AccessReviewApplyResult(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The outcome of applying the decision.
    """

    NEW = "New"
    APPLYING = "Applying"
    APPLIED_SUCCESSFULLY = "AppliedSuccessfully"
    APPLIED_WITH_UNKNOWN_FAILURE = "AppliedWithUnknownFailure"
    APPLIED_SUCCESSFULLY_BUT_OBJECT_NOT_FOUND = "AppliedSuccessfullyButObjectNotFound"
    APPLY_NOT_SUPPORTED = "ApplyNotSupported"

class AccessReviewInstanceStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """This read-only field specifies the status of an access review instance.
    """

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    APPLIED = "Applied"
    INITIALIZING = "Initializing"
    APPLYING = "Applying"
    COMPLETING = "Completing"
    SCHEDULED = "Scheduled"
    AUTO_REVIEWING = "AutoReviewing"
    AUTO_REVIEWED = "AutoReviewed"
    STARTING = "Starting"

class AccessReviewRecurrencePatternType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recurrence type : weekly, monthly, etc.
    """

    WEEKLY = "weekly"
    ABSOLUTE_MONTHLY = "absoluteMonthly"

class AccessReviewRecurrenceRangeType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recurrence range type. The possible values are: endDate, noEnd, numbered.
    """

    END_DATE = "endDate"
    NO_END = "noEnd"
    NUMBERED = "numbered"

class AccessReviewResult(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The decision on the approval step. This value is initially set to NotReviewed. Approvers can
    take action of Approve/Deny
    """

    APPROVE = "Approve"
    DENY = "Deny"
    NOT_REVIEWED = "NotReviewed"
    DONT_KNOW = "DontKnow"
    NOT_NOTIFIED = "NotNotified"

class AccessReviewReviewerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type : user/servicePrincipal
    """

    USER = "user"
    SERVICE_PRINCIPAL = "servicePrincipal"

class AccessReviewScheduleDefinitionReviewersType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """This field specifies the type of reviewers for a review. Usually for a review, reviewers are
    explicitly assigned. However, in some cases, the reviewers may not be assigned and instead be
    chosen dynamically. For example managers review or self review.
    """

    ASSIGNED = "Assigned"
    SELF = "Self"
    MANAGERS = "Managers"

class AccessReviewScheduleDefinitionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """This read-only field specifies the status of an accessReview.
    """

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    APPLIED = "Applied"
    INITIALIZING = "Initializing"
    APPLYING = "Applying"
    COMPLETING = "Completing"
    SCHEDULED = "Scheduled"
    AUTO_REVIEWING = "AutoReviewing"
    AUTO_REVIEWED = "AutoReviewed"
    STARTING = "Starting"

class AccessReviewScopeAssignmentState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The role assignment state eligible/active to review
    """

    ELIGIBLE = "eligible"
    ACTIVE = "active"

class AccessReviewScopePrincipalType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type user/servicePrincipal to review
    """

    USER = "user"
    GUEST_USER = "guestUser"
    SERVICE_PRINCIPAL = "servicePrincipal"

class DecisionResourceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of resource
    """

    AZURE_ROLE = "azureRole"

class DecisionTargetType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of decision target : User/ServicePrincipal
    """

    USER = "user"
    SERVICE_PRINCIPAL = "servicePrincipal"

class DefaultDecisionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """This specifies the behavior for the autoReview feature when an access review completes.
    """

    APPROVE = "Approve"
    DENY = "Deny"
    RECOMMENDATION = "Recommendation"
