/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.debug;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.interpreter.Tracer;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicate_spy
extends ExecuteOnlyCode {
    public static EnumSet<Tracer.TraceLevel> getTraceLevel(Term term) throws PrologException {
        if (term instanceof AtomTerm) {
            return Tracer.TraceLevel.fromString(((AtomTerm)term).value);
        }
        PrologException.typeError(TermConstants.atomAtom, term);
        return EnumSet.noneOf(Tracer.TraceLevel.class);
    }

    public static CompoundTermTag getTag(Term term) throws PrologException {
        String functor = "";
        int arity = -1;
        if (term instanceof AtomTerm) {
            functor = ((AtomTerm)term).value;
            int idx = functor.indexOf(47);
            if (idx > -1) {
                try {
                    arity = Integer.parseInt(functor.substring(idx + 1));
                    functor = functor.substring(0, idx);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            if (!ct.tag.toString().equals("//2")) {
                PrologException.typeError(TermConstants.compoundAtom, term);
            }
            if (ct.args[0] instanceof AtomTerm) {
                functor = ((AtomTerm)ct.args[0]).value;
            } else {
                PrologException.typeError(TermConstants.atomAtom, ct.args[0]);
            }
            if (ct.args[1] instanceof IntegerTerm) {
                arity = ((IntegerTerm)ct.args[1]).value;
            } else {
                PrologException.typeError(TermConstants.atomAtom, ct.args[1]);
            }
        } else {
            PrologException.typeError(TermConstants.compoundAtom, term);
        }
        return CompoundTermTag.get(functor, arity);
    }

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        CompoundTermTag tag = Predicate_spy.getTag(args[0]);
        if (tag.arity == -1) {
            for (CompoundTermTag ptag : interpreter.getEnvironment().getModule().getPredicateTags()) {
                if (!ptag.functor.equals(tag.functor)) continue;
                this.setSpyPoint(interpreter, ptag, args[1]);
            }
        } else {
            this.setSpyPoint(interpreter, tag, args[1]);
        }
        return 1;
    }

    protected void setSpyPoint(Interpreter interpreter, CompoundTermTag tag, Term arg) throws PrologException {
        if (arg instanceof AtomTerm) {
            EnumSet<Tracer.TraceLevel> lvl = Predicate_spy.getTraceLevel(arg);
            interpreter.getTracer().setTrace(tag, lvl);
        } else if (arg instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)arg;
            EnumSet<Tracer.TraceLevel> lvl = Predicate_spy.getTraceLevel(ct.args[0]);
            if (ct.tag.toString().equals("+/1")) {
                interpreter.getTracer().addTrace(tag, lvl);
            } else if (ct.tag.toString().equals("-/1")) {
                interpreter.getTracer().removeTrace(tag, lvl);
            } else {
                PrologException.representationError(arg);
            }
        }
    }
}

