/* Copyright (C) 2001-2006 artofcode LLC.
   All Rights Reserved.
  
  This file is part of GNU ghostscript

  GNU ghostscript is free software; you can redistribute it and/or
  modify it under the terms of the version 2 of the GNU General Public
  License as published by the Free Software Foundation.

  GNU ghostscript is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  ghostscript; see the file COPYING. If not, write to the Free Software Foundation,
  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

*/

/* $Id: gxdhtres.h,v 1.6 2007/08/01 14:26:21 jemarch Exp $ */
/* Definitions for precompiled halftone resources */

#ifndef gxdhtres_INCLUDED
#  define gxdhtres_INCLUDED

#include "stdpre.h"

/*
 * Precompiled halftones generated by genht #include this file.
 */
#ifndef gx_device_halftone_resource_DEFINED
#  define gx_device_halftone_resource_DEFINED
typedef struct gx_device_halftone_resource_s gx_device_halftone_resource_t;
#endif

struct gx_device_halftone_resource_s {
    const char *rname;
    int HalftoneType;
    int Width;
    int Height;
    int num_levels;
    const unsigned int *levels;
    const void *bit_data;
    int elt_size;
};

#define DEVICE_HALFTONE_RESOURCE_PROC(proc)\
  const gx_device_halftone_resource_t *const *proc(void)

#endif /* gxdhtres_INCLUDED */
