/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.EventSetDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.TclRuntimeError;

class AdaptorGen {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_FieldRef = 9;
    private static final int CONSTANT_MethodRef = 10;
    private static final int CONSTANT_InterfaceMethodRef = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private static final int ALOAD = 25;
    private static final int ALOAD_0 = 42;
    private static final int ALOAD_1 = 43;
    private static final int ICONST_0 = 3;
    private static final int ICONST_1 = 4;
    private static final int ANEWARRAY = 189;
    private static final int DUP = 89;
    private static final int AASTORE = 83;
    private static final int RETURN = 177;
    private static final int ARETURN = 176;
    private static final int DRETURN = 175;
    private static final int FRETURN = 174;
    private static final int IRETURN = 172;
    private static final int LRETURN = 173;
    private static final int SIPUSH = 17;
    private static final int ASTORE = 58;
    private static final int NEW = 187;
    private static final int ILOAD = 21;
    private static final int LLOAD = 22;
    private static final int FLOAD = 23;
    private static final int DLOAD = 24;
    private static final int INVOKESP = 183;
    private static final int INVOKEVT = 182;
    private static final int WIDE = 196;
    private static final int LDC_W = 19;
    private static final int INSTNCOF = 193;
    private static final int CHKCAST = 192;
    private static final int IFEQ = 153;
    private static final int ATHROW = 191;
    private static final int GOTO_W = 200;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_SUPER = 32;
    private DataOutputStream ostream;
    private Class listenerCls;
    private Method[] methods;
    private String clsName;
    private Class superCls;
    int cpSize;
    Vector constPool;
    Hashtable utf8Tab;
    Hashtable allClasses;
    Hashtable primClasses;
    Hashtable returnTypes;
    Hashtable returnMethodRef;
    Hashtable wrapperConsRef;
    Hashtable clsRef;
    Hashtable stringRef;
    short cp_this_class;
    short cp_super_class;
    short cp_listener_interface;
    short cp_code;
    short cp_super_cons;
    short cp_processEvent;
    short cp_wrongException;
    MethodDesc[] cp_methodDesc;
    MethodDesc cp_consDesc;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    byte[] generate(EventSetDescriptor eventSetDescriptor, Class clazz, String string) {
        this.superCls = clazz;
        this.clsName = string;
        this.listenerCls = eventSetDescriptor.getListenerType();
        this.methods = this.listenerCls.getMethods();
        this.allClasses = new Hashtable();
        this.primClasses = new Hashtable();
        this.returnTypes = new Hashtable();
        this.returnMethodRef = new Hashtable();
        this.wrapperConsRef = new Hashtable();
        this.clsRef = new Hashtable();
        this.stringRef = new Hashtable();
        this.utf8Tab = new Hashtable();
        this.cp_methodDesc = new MethodDesc[this.methods.length];
        this.analyzeListener();
        this.cpSize = 1;
        try {
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.ostream = dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.generateByteCode();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new TclRuntimeError("Unexcepted IOException " + iOException);
        }
    }

    private void analyzeListener() {
        boolean bl = false;
        int n = 0;
        while (n < this.methods.length) {
            Object object;
            Class<?>[] classArray = this.methods[n].getParameterTypes();
            int n2 = 0;
            while (n2 < classArray.length) {
                if (classArray[n2].isPrimitive()) {
                    if (classArray[n2] == Void.TYPE) {
                        throw new ClassFormatError("Parameter type cannot be void");
                    }
                    object = AdaptorGen.getWrapperClass(classArray[n2]);
                    this.allClasses.put(object, object);
                    this.primClasses.put(classArray[n2], classArray[n2]);
                } else {
                    this.allClasses.put(classArray[n2], classArray[n2]);
                }
                bl = true;
                ++n2;
            }
            object = this.methods[n].getExceptionTypes();
            n2 = 0;
            while (n2 < ((Class<?>[])object).length) {
                this.allClasses.put(object[n2], object[n2]);
                ++n2;
            }
            Class<?> clazz = this.methods[n].getReturnType();
            if (clazz != Void.TYPE) {
                if (!clazz.isPrimitive()) {
                    this.allClasses.put(clazz, clazz);
                }
                this.returnTypes.put(clazz, clazz);
            }
            ++n;
        }
        if (bl) {
            this.allClasses.put(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = AdaptorGen.class$("java.lang.Object")), class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = AdaptorGen.class$("java.lang.Object")));
        }
        this.allClasses.put(class$java$lang$Throwable != null ? class$java$lang$Throwable : (class$java$lang$Throwable = AdaptorGen.class$("java.lang.Throwable")), class$java$lang$Throwable != null ? class$java$lang$Throwable : (class$java$lang$Throwable = AdaptorGen.class$("java.lang.Throwable")));
    }

    private void generateByteCode() throws IOException {
        this.ostream.writeInt(-889275714);
        this.ostream.writeShort(3);
        this.ostream.writeShort(45);
        this.generateConstantPool();
        this.ostream.writeShort(33);
        this.ostream.writeShort(this.cp_this_class);
        this.ostream.writeShort(this.cp_super_class);
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_listener_interface);
        this.ostream.writeShort(0);
        this.ostream.writeShort(1 + this.methods.length);
        this.generateConstructor();
        int n = 0;
        while (n < this.methods.length) {
            this.generateMethod(n);
            ++n;
        }
        this.ostream.writeShort(0);
    }

    private void generateConstantPool() throws IOException {
        Object object;
        this.constPool = new Vector();
        this.cp_this_class = this.cp_putClass(this.clsName);
        this.cp_super_class = this.cp_putClass(this.superCls.getName());
        this.cp_listener_interface = this.cp_putClass(this.listenerCls.getName());
        this.cp_code = this.cp_putUtf8("Code");
        this.cp_super_cons = this.cp_putMethodRef(this.cp_super_class, "<init>", "()V");
        this.cp_processEvent = this.cp_putMethodRef(this.cp_super_class, "_processEvent", "([Ljava/lang/Object;Ljava/lang/String;)V");
        this.cp_wrongException = this.cp_putMethodRef(this.cp_super_class, "_wrongException", "()V");
        Enumeration enumeration = this.returnTypes.keys();
        while (enumeration.hasMoreElements()) {
            short s;
            Class clazz = (Class)enumeration.nextElement();
            if (clazz.isPrimitive()) {
                s = this.cp_putMethodRef(this.cp_super_class, "_return_" + clazz.getName(), "()" + AdaptorGen.getTypeDesc(clazz));
            } else {
                this.cp_putString(clazz.getName());
                s = this.cp_putMethodRef(this.cp_super_class, "_return_Object", "(Ljava/lang/String;)" + AdaptorGen.getTypeDesc(clazz));
            }
            AdaptorGen.hashPutShort(this.returnMethodRef, clazz, s);
        }
        this.cp_consDesc = this.cp_putMethodDesc("<init>", "()V", false);
        int n = 0;
        while (n < this.methods.length) {
            this.cp_methodDesc[n] = this.cp_putMethodDesc(this.methods[n].getName(), AdaptorGen.getMethodDescriptor(this.methods[n]), true);
            ++n;
        }
        Enumeration enumeration2 = this.allClasses.keys();
        while (enumeration2.hasMoreElements()) {
            object = (Class)enumeration2.nextElement();
            short s = this.cp_putClass(((Class)object).getName());
            AdaptorGen.hashPutShort(this.clsRef, object, s);
        }
        object = this.primClasses.keys();
        while (object.hasMoreElements()) {
            object.nextElement();
        }
        Enumeration enumeration3 = this.primClasses.keys();
        while (enumeration3.hasMoreElements()) {
            Class clazz = (Class)enumeration3.nextElement();
            short s = this.cp_getClass(AdaptorGen.getWrapperClass(clazz));
            short s2 = this.cp_putMethodRef(s, "<init>", "(" + AdaptorGen.getTypeDesc(clazz) + ")V");
            AdaptorGen.hashPutShort(this.wrapperConsRef, clazz, s2);
        }
        this.ostream.writeShort(this.constPool.size() + 1);
        int n2 = 0;
        while (n2 < this.constPool.size()) {
            Object object2;
            Object e = this.constPool.elementAt(n2);
            if (e instanceof ConstUtf) {
                object2 = (ConstUtf)e;
                this.ostream.writeByte(1);
                this.ostream.writeUTF(((ConstUtf)object2).string);
            } else if (e instanceof ConstString) {
                object2 = (ConstString)e;
                this.ostream.writeByte(8);
                this.ostream.writeShort(((ConstString)object2).string_index);
            } else if (e instanceof ConstClass) {
                object2 = (ConstClass)e;
                this.ostream.writeByte(7);
                this.ostream.writeShort(((ConstClass)object2).name_index);
            } else if (e instanceof ConstMethodRef) {
                object2 = (ConstMethodRef)e;
                this.ostream.writeByte(10);
                this.ostream.writeShort(((ConstMethodRef)object2).class_index);
                this.ostream.writeShort(((ConstMethodRef)object2).name_and_type_index);
            } else {
                object2 = (ConstNameAndType)e;
                this.ostream.writeByte(12);
                this.ostream.writeShort(((ConstNameAndType)object2).name_index);
                this.ostream.writeShort(((ConstNameAndType)object2).desc_index);
            }
            ++n2;
        }
    }

    void generateConstructor() throws IOException {
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_consDesc.name_index);
        this.ostream.writeShort(this.cp_consDesc.descriptor_index);
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_code);
        this.ostream.writeInt(17);
        this.ostream.writeShort(2);
        this.ostream.writeShort(1);
        this.ostream.writeInt(5);
        this.ostream.writeByte(42);
        this.ostream.writeByte(183);
        this.ostream.writeShort(this.cp_super_cons);
        this.ostream.writeByte(177);
        this.ostream.writeShort(0);
        this.ostream.writeShort(0);
    }

    void generateMethod(int n) throws IOException {
        int n2;
        Class<?>[] classArray;
        int n3 = 0;
        int n4 = 6;
        Class<?>[] classArray2 = this.methods[n].getParameterTypes();
        int n5 = classArray2.length;
        int n6 = 1;
        int n7 = 0;
        while (n7 < n5) {
            n6 = classArray2[n7] == Double.TYPE || classArray2[n7] == Long.TYPE ? (n6 += 2) : ++n6;
            ++n7;
        }
        int n8 = (n6 += 2) - 2;
        int n9 = n6 - 1;
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_methodDesc[n].name_index);
        this.ostream.writeShort(this.cp_methodDesc[n].descriptor_index);
        this.ostream.writeShort(1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(17);
        dataOutputStream.writeShort(n5);
        dataOutputStream.writeByte(189);
        dataOutputStream.writeShort(this.cp_getClass(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = AdaptorGen.class$("java.lang.Object"))));
        this.writeLoadStore(dataOutputStream, 58, n8);
        int n10 = 1;
        int n11 = 0;
        while (n11 < n5) {
            this.writeLoadStore(dataOutputStream, 25, n8);
            dataOutputStream.writeByte(17);
            dataOutputStream.writeShort(n11);
            if (classArray2[n11].isPrimitive()) {
                int n12;
                classArray = classArray2[n11];
                Class clazz = AdaptorGen.getWrapperClass(classArray2[n11]);
                if (classArray == Double.TYPE) {
                    n2 = 24;
                    n12 = 2;
                } else if (classArray == Float.TYPE) {
                    n2 = 23;
                    n12 = 1;
                } else if (classArray == Long.TYPE) {
                    n2 = 22;
                    n12 = 2;
                } else {
                    n2 = 21;
                    n12 = 1;
                }
                dataOutputStream.writeByte(187);
                dataOutputStream.writeShort(this.cp_getClass(clazz));
                dataOutputStream.writeByte(89);
                this.writeLoadStore(dataOutputStream, n2, n10);
                dataOutputStream.writeByte(183);
                dataOutputStream.writeShort(this.cp_getWrapperConstructor((Class)classArray));
                n10 += n12;
            } else {
                this.writeLoadStore(dataOutputStream, 25, n10);
                ++n10;
            }
            dataOutputStream.writeByte(83);
            ++n11;
        }
        int n13 = dataOutputStream.size();
        dataOutputStream.writeByte(42);
        this.writeLoadStore(dataOutputStream, 25, n8);
        dataOutputStream.writeByte(19);
        dataOutputStream.writeShort(this.cp_getString(this.methods[n].getName()));
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp_processEvent);
        int n14 = dataOutputStream.size();
        classArray = this.methods[n].getExceptionTypes();
        int n15 = 9 + classArray.length * 18 + 4;
        dataOutputStream.writeByte(200);
        dataOutputStream.writeInt(n15);
        n3 = dataOutputStream.size();
        dataOutputStream.writeByte(196);
        dataOutputStream.writeByte(58);
        dataOutputStream.writeShort(n9);
        n2 = 0;
        while (n2 < classArray.length) {
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(25);
            dataOutputStream.writeShort(n9);
            dataOutputStream.writeByte(193);
            dataOutputStream.writeShort(this.cp_getClass(classArray[n2]));
            dataOutputStream.writeByte(153);
            dataOutputStream.writeShort(11);
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(25);
            dataOutputStream.writeShort(n9);
            dataOutputStream.writeByte(192);
            dataOutputStream.writeShort(this.cp_getClass(classArray[n2]));
            dataOutputStream.writeByte(191);
            ++n2;
        }
        dataOutputStream.writeByte(42);
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp_wrongException);
        Class<?> clazz = this.methods[n].getReturnType();
        if (clazz == Void.TYPE) {
            dataOutputStream.writeByte(177);
        } else if (clazz.isPrimitive()) {
            dataOutputStream.writeByte(42);
            dataOutputStream.writeByte(182);
            dataOutputStream.writeShort(this.cp_getReturnMethodRef(clazz));
            if (clazz == Double.TYPE) {
                dataOutputStream.writeByte(175);
            } else if (clazz == Float.TYPE) {
                dataOutputStream.writeByte(174);
            } else if (clazz == Long.TYPE) {
                dataOutputStream.writeByte(173);
            } else {
                dataOutputStream.writeByte(172);
            }
        } else {
            dataOutputStream.writeByte(42);
            dataOutputStream.writeByte(19);
            dataOutputStream.writeShort(this.cp_getString(clazz.getName()));
            dataOutputStream.writeByte(182);
            dataOutputStream.writeShort(this.cp_getReturnMethodRef(clazz));
            dataOutputStream.writeByte(192);
            dataOutputStream.writeShort(this.cp_getClass(clazz));
            dataOutputStream.writeByte(176);
        }
        int n16 = dataOutputStream.size();
        dataOutputStream.writeShort(1);
        dataOutputStream.writeShort(n13);
        dataOutputStream.writeShort(n14);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(this.cp_getClass(class$java$lang$Throwable != null ? class$java$lang$Throwable : (class$java$lang$Throwable = AdaptorGen.class$("java.lang.Throwable"))));
        dataOutputStream.writeShort(0);
        dataOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.ostream.writeShort(this.cp_code);
        this.ostream.writeInt(byArray.length + 8);
        this.ostream.writeShort(n4);
        this.ostream.writeShort(n6);
        this.ostream.writeInt(n16);
        this.ostream.write(byArray);
    }

    private static final String internalClassName(String string) {
        return string.replace('.', '/');
    }

    private static final void hashPutShort(Hashtable hashtable, Object object, short s) {
        Short s2 = new Short(s);
        hashtable.put(object, s2);
    }

    private static final short hashGetShort(Hashtable hashtable, Object object) {
        return (Short)hashtable.get(object);
    }

    private static final Class getWrapperClass(Class clazz) {
        if (clazz == Boolean.TYPE) {
            if (class$java$lang$Boolean != null) {
                return class$java$lang$Boolean;
            }
            class$java$lang$Boolean = AdaptorGen.class$("java.lang.Boolean");
            return class$java$lang$Boolean;
        }
        if (clazz == Byte.TYPE) {
            if (class$java$lang$Byte != null) {
                return class$java$lang$Byte;
            }
            class$java$lang$Byte = AdaptorGen.class$("java.lang.Byte");
            return class$java$lang$Byte;
        }
        if (clazz == Character.TYPE) {
            if (class$java$lang$Character != null) {
                return class$java$lang$Character;
            }
            class$java$lang$Character = AdaptorGen.class$("java.lang.Character");
            return class$java$lang$Character;
        }
        if (clazz == Double.TYPE) {
            if (class$java$lang$Double != null) {
                return class$java$lang$Double;
            }
            class$java$lang$Double = AdaptorGen.class$("java.lang.Double");
            return class$java$lang$Double;
        }
        if (clazz == Float.TYPE) {
            if (class$java$lang$Float != null) {
                return class$java$lang$Float;
            }
            class$java$lang$Float = AdaptorGen.class$("java.lang.Float");
            return class$java$lang$Float;
        }
        if (clazz == Integer.TYPE) {
            if (class$java$lang$Integer != null) {
                return class$java$lang$Integer;
            }
            class$java$lang$Integer = AdaptorGen.class$("java.lang.Integer");
            return class$java$lang$Integer;
        }
        if (clazz == Long.TYPE) {
            if (class$java$lang$Long != null) {
                return class$java$lang$Long;
            }
            class$java$lang$Long = AdaptorGen.class$("java.lang.Long");
            return class$java$lang$Long;
        }
        if (class$java$lang$Short != null) {
            return class$java$lang$Short;
        }
        class$java$lang$Short = AdaptorGen.class$("java.lang.Short");
        return class$java$lang$Short;
    }

    private static final String getTypeDesc(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            return "V";
        }
        if (clazz.isArray()) {
            return "[" + AdaptorGen.getTypeDesc(clazz.getComponentType());
        }
        String string = "L" + clazz.getName() + ";";
        return string.replace('.', '/');
    }

    private static final String getMethodDescriptor(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(AdaptorGen.getTypeDesc(classArray[n]));
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append(AdaptorGen.getTypeDesc(method.getReturnType()));
        return stringBuffer.toString();
    }

    void writeLoadStore(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        if (n2 > 255) {
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(n);
            dataOutputStream.writeShort(n2);
            return;
        }
        dataOutputStream.writeByte(n);
        dataOutputStream.writeByte(n2);
    }

    short cp_putUtf8(String string) {
        Short s = (Short)this.utf8Tab.get(string);
        if (s != null) {
            return s;
        }
        ConstUtf constUtf = new ConstUtf();
        constUtf.string = string;
        this.constPool.addElement(constUtf);
        short s2 = (short)this.cpSize++;
        AdaptorGen.hashPutShort(this.utf8Tab, string, s2);
        return s2;
    }

    private short cp_putString(String string) {
        ConstString constString = new ConstString();
        constString.string_index = this.cp_putUtf8(string);
        this.constPool.addElement(constString);
        short s = (short)this.cpSize++;
        AdaptorGen.hashPutShort(this.stringRef, string, s);
        return s;
    }

    private short cp_putClass(String string) {
        ConstClass constClass = new ConstClass();
        constClass.name_index = this.cp_putUtf8(string.replace('.', '/'));
        this.constPool.addElement(constClass);
        return (short)this.cpSize++;
    }

    short cp_putNameAndType(String string, String string2) {
        ConstNameAndType constNameAndType = new ConstNameAndType();
        constNameAndType.name_index = this.cp_putUtf8(string);
        constNameAndType.desc_index = this.cp_putUtf8(string2);
        this.constPool.addElement(constNameAndType);
        return (short)this.cpSize++;
    }

    short cp_putMethodRef(short s, String string, String string2) {
        ConstMethodRef constMethodRef = new ConstMethodRef();
        constMethodRef.class_index = s;
        constMethodRef.name_and_type_index = this.cp_putNameAndType(string, string2);
        this.constPool.addElement(constMethodRef);
        return (short)this.cpSize++;
    }

    MethodDesc cp_putMethodDesc(String string, String string2, boolean bl) {
        MethodDesc methodDesc = new MethodDesc();
        methodDesc.name_index = this.cp_putUtf8(string);
        methodDesc.descriptor_index = this.cp_putUtf8(string2);
        if (bl) {
            this.cp_putString(string);
        }
        return methodDesc;
    }

    short cp_getClass(Class clazz) {
        Hashtable hashtable = this.clsRef;
        Class clazz2 = clazz;
        return (Short)hashtable.get(clazz2);
    }

    short cp_getString(String string) {
        Hashtable hashtable = this.stringRef;
        String string2 = string;
        return (Short)hashtable.get(string2);
    }

    short cp_getWrapperConstructor(Class clazz) {
        Hashtable hashtable = this.wrapperConsRef;
        Class clazz2 = clazz;
        return (Short)hashtable.get(clazz2);
    }

    short cp_getReturnMethodRef(Class clazz) {
        if (clazz.isPrimitive()) {
            Hashtable hashtable = this.returnMethodRef;
            Class clazz2 = clazz;
            return (Short)hashtable.get(clazz2);
        }
        Hashtable hashtable = this.returnMethodRef;
        Class clazz3 = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = AdaptorGen.class$("java.lang.Object"));
        return (Short)hashtable.get(clazz3);
    }

    AdaptorGen() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConstUtf {
        String string;

        ConstUtf() {
            AdaptorGen.this = AdaptorGen.this;
        }
    }

    class ConstString {
        short string_index;

        ConstString() {
            AdaptorGen.this = AdaptorGen.this;
        }
    }

    class ConstClass {
        short name_index;

        ConstClass() {
            AdaptorGen.this = AdaptorGen.this;
        }
    }

    class ConstNameAndType {
        short name_index;
        short desc_index;

        ConstNameAndType() {
            AdaptorGen.this = AdaptorGen.this;
        }
    }

    class ConstMethodRef {
        short class_index;
        short name_and_type_index;

        ConstMethodRef() {
            AdaptorGen.this = AdaptorGen.this;
        }
    }

    class MethodDesc {
        short name_index;
        short descriptor_index;

        MethodDesc() {
            AdaptorGen.this = AdaptorGen.this;
        }
    }
}

