/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import tcl.lang.Channel;
import tcl.lang.ConsoleEvent;
import tcl.lang.Interp;
import tcl.lang.StdChannel;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class ConsoleThread
extends Thread {
    Interp interp;
    Vector historyObjs;
    StringBuffer sbuf;
    private Channel in;
    private Channel out;
    private Channel err;

    ConsoleThread(Interp i) {
        this.interp = i;
        this.sbuf = new StringBuffer();
        this.historyObjs = new Vector();
        this.out = new StdChannel("stdout");
        this.err = new StdChannel("stderr");
    }

    public synchronized void run() {
        this.put(this.out, "% ");
        while (true) {
            TclObject prompt;
            this.sbuf.append(this.getLine());
            if (Interp.commandComplete(this.sbuf.toString())) {
                ConsoleEvent evt = new ConsoleEvent(this.interp, this.sbuf.toString());
                this.interp.getNotifier().queueEvent(evt, 0);
                evt.sync();
                if (evt.evalResult != null) {
                    String s = evt.evalResult.toString();
                    if (s.length() > 0) {
                        this.putLine(this.out, s);
                    }
                    int limit = 0;
                    try {
                        TclObject histLimit = this.interp.getVar("historyLimit", 2049);
                        if (histLimit != null) {
                            limit = TclInteger.get((Interp)this.interp, (TclObject)histLimit);
                        }
                    }
                    catch (TclException tclException) {}
                    if (limit > 0) {
                        this.historyObjs.addElement(evt.evalResult);
                    } else {
                        evt.evalResult.release();
                    }
                    if (this.historyObjs.size() > limit && this.historyObjs.size() > 0) {
                        TclObject cobj = (TclObject)this.historyObjs.elementAt(0);
                        this.historyObjs.removeElementAt(0);
                        cobj.release();
                    }
                } else {
                    TclException e = evt.evalException;
                    int code = e.getCompletionCode();
                    if (code != 2 || (code = this.interp.updateReturnInfo()) != 0) {
                        switch (code) {
                            case 1: {
                                this.putLine(this.err, this.interp.getResult().toString());
                                break;
                            }
                            case 3: {
                                this.putLine(this.err, "invoked \"break\" outside of a loop");
                                break;
                            }
                            case 4: {
                                this.putLine(this.err, "invoked \"continue\" outside of a loop");
                                break;
                            }
                            default: {
                                this.putLine(this.err, "command returned bad code: " + code);
                            }
                        }
                    }
                }
                this.sbuf.setLength(0);
                try {
                    prompt = this.interp.getVar("tcl_prompt1", 1);
                }
                catch (TclException tclException) {
                    prompt = null;
                }
                if (prompt != null) {
                    try {
                        this.interp.eval(prompt.toString(), 1);
                    }
                    catch (TclException tclException) {
                        this.put(this.out, "% ");
                    }
                    continue;
                }
                this.put(this.out, "% ");
                continue;
            }
            try {
                prompt = this.interp.getVar("tcl_prompt2", 1);
            }
            catch (TclException tclException) {
                prompt = null;
            }
            if (prompt != null) {
                try {
                    this.interp.eval(prompt.toString(), 1);
                }
                catch (TclException tclException) {
                    this.put(this.out, "> ");
                }
                continue;
            }
            this.put(this.out, "> ");
        }
    }

    private String getLine() {
        char c;
        StringBuffer sbuf = new StringBuffer();
        boolean sysInBlocks = false;
        try {
            System.in.available();
            sysInBlocks = true;
        }
        catch (Exception exception) {
            sysInBlocks = false;
        }
        if (sysInBlocks) {
            try {
                while (System.in.available() == 0) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                System.exit(0);
            }
            catch (EOFException eOFException) {
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        char c2 = ' ';
        do {
            c = ' ';
            try {
                int i = System.in.read();
                if (i == -1) {
                    if (sbuf.length() == 0) {
                        System.exit(0);
                    } else {
                        return sbuf.toString();
                    }
                }
                if ((c = (char)((char)i)) == '\r') {
                    i = System.in.read();
                    if (i == -1) {
                        if (sbuf.length() == 0) {
                            System.exit(0);
                        } else {
                            return sbuf.toString();
                        }
                    }
                    if ((c2 = (char)((char)i)) == '\n') {
                        c = c2;
                    } else {
                        sbuf.append(c);
                        c = c2;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
            sbuf.append(c);
        } while (c != 10);
        return sbuf.toString();
    }

    private void putLine(Channel chan, String s) {
        this.put(chan, s);
        this.put(chan, "\n");
    }

    private void put(Channel chan, String s) {
        try {
            this.out.write(this.interp, s);
        }
        catch (Exception e) {
            throw new TclRuntimeError("unexpected Exception " + e);
        }
    }
}

