/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class LsearchCmd
implements Command {
    private static final String[] validCmds = new String[]{"-exact", "-glob", "-regexp"};
    static final int EXACT = 0;
    static final int GLOB = 1;
    static final int REGEXP = 2;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n = 1;
        TclObject tclObject = null;
        TclObject tclObject2 = null;
        if (tclObjectArray.length == 4) {
            n = TclIndex.get(interp, tclObjectArray[1], validCmds, "search mode", 0);
            tclObject2 = tclObjectArray[2];
            tclObject = tclObjectArray[3];
        } else if (tclObjectArray.length == 3) {
            tclObject2 = tclObjectArray[1];
            tclObject = tclObjectArray[2];
        } else {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?mode? list pattern");
        }
        boolean bl = false;
        int n2 = TclList.getLength(interp, tclObject2);
        int n3 = 0;
        while (n3 < n2) {
            TclObject tclObject3 = TclList.index(interp, tclObject2, n3);
            if (tclObject3 == tclObject || tclObject3.equals(tclObject)) {
                bl = true;
            } else {
                switch (n) {
                    case 0: {
                        if (tclObject3.stringRep == null) {
                            tclObject3.stringRep = tclObject3.internalRep.toString();
                        }
                        String string = tclObject3.stringRep;
                        if (tclObject.stringRep == null) {
                            tclObject.stringRep = tclObject.internalRep.toString();
                        }
                        bl = string.compareTo(tclObject.stringRep) == 0;
                        break;
                    }
                    case 1: {
                        if (tclObject3.stringRep == null) {
                            tclObject3.stringRep = tclObject3.internalRep.toString();
                        }
                        String string = tclObject3.stringRep;
                        if (tclObject.stringRep == null) {
                            tclObject.stringRep = tclObject.internalRep.toString();
                        }
                        bl = Util.stringMatch(string, tclObject.stringRep);
                        break;
                    }
                    case 2: {
                        boolean bl2;
                        if (tclObject3.stringRep == null) {
                            tclObject3.stringRep = tclObject3.internalRep.toString();
                        }
                        String string = tclObject3.stringRep;
                        if (Util.regexMatcher != null) {
                            if (tclObject.stringRep == null) {
                                tclObject.stringRep = tclObject.internalRep.toString();
                            }
                            bl2 = Util.regexMatcher.match(interp, string, tclObject.stringRep);
                            break;
                        }
                        bl2 = bl = false;
                    }
                }
            }
            if (bl) {
                interp.setResult(TclInteger.newInstance(n3));
                return;
            }
            ++n3;
        }
        interp.setResult(TclInteger.newInstance(-1));
    }

    LsearchCmd() {
    }
}

