#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <potpourri.h>
#include "ncs.h"



int PLen=sizeof(struct Packet);	/* packet size in bytes */
int PCount = 100; 	/* how many packets */
int SCount = 3;		/* how many stop packets to send */
int PDelay = 0;		/* delay between packets in milliseconds */
struct Packet *PBuff;	/* the packet being xmitted */

char *PHostname;		/* pointer to remote hostname */
struct sockaddr_in PSAddr;	/* resolved remote host address */
struct sockaddr_in PCAddr;	/* resolved local host address */
short PSPort = SERVERPORT;	/* Remote Internet port number */
short PCPort = CLIENTPORT;	/* My Internet port number */
int PSock;	/* socket */


main(argc, argv)
    int argc;
    char *argv[];
    {
    register int i;
    struct timeval t1, t2;
    
    for (i = 1; i < argc; i++)
	{
	if (strcmp(argv[i], "-n") == 0 && ++i < argc)
	    {
	    PCount = atoi(argv[i]);
	    continue;
	    }

	if (strcmp(argv[i], "-s") == 0 && ++i < argc)
	    {
	    SCount = atoi(argv[i]);
	    continue;
	    }

	if (strcmp(argv[i], "-l") == 0 && ++i < argc)
	    {
	    PLen = atoi(argv[i]);
	    continue;
	    }

	if (strcmp(argv[i], "-t") == 0 && ++i < argc)
	    {
	    PDelay = atoi(argv[i]);
	    continue;
	    }

	if (strcmp(argv[i], "-p") == 0 && ++i < argc)
	    {
	    PSPort = atoi(argv[i]);
	    continue;
	    }

	if (strcmp(argv[i], "-b") == 0 && ++i < argc)
	    {
	    PCPort = atoi(argv[i]);
	    continue;
	    }
    
	if (argv[i][0] == '-') BadArgs();
	    
	/* we have a host name */
	PHostname = argv[i];
	break;
	}

    if (PHostname == NULL) BadArgs();

    if (PLen < sizeof(struct Packet) || PLen > MAXLENGTH)
	{
	printf("Packet size can only be in the range %d to %d bytes\n", sizeof(struct Packet), MAXLENGTH);
	exit(-1);
	}
    else PBuff = (struct Packet *)malloc(PLen);

    InitNet();
    gettimeofday(&t1, 0);
    SendPackets();
    gettimeofday(&t2, 0);

    printf("%d + %d packets sent in %d milliseconds\n", PCount-1, SCount,
		(t2.tv_sec-t1.tv_sec)*1000 + (t2.tv_usec-t1.tv_usec)/1000);
    }


InitNet()
    {
    struct hostent *hentry;

    /* Construct server socket address */
    if ((hentry = gethostbyname (PHostname)) == NULL) 
	{
	printf("Unknown remote host %s\n", PHostname);
	exit(-1);
	}
    bcopy (hentry->h_addr, &PSAddr.sin_addr.s_addr, hentry->h_length);	/* already in network order */
    PSAddr.sin_port = htons(PSPort);
    PSAddr.sin_family = AF_INET;
    
    /* Allocate client socket */
    if ((PSock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0)
	{
	perror("PSock");
	exit(-1);
	}

    /* set massive buffer size for this socket */
#ifdef SO_GREEDY
    if (setsockopt(PSock, SOL_SOCKET, SO_GREEDY, 0, 0) != 0)
	perror("WARNING: SO_GREEDY");
#else
	fprintf(stderr, "WARNING: SO_GREEDY undefined\n");
#endif

    /*	Now bind to specified client port.
	We could have used an anonymous binding.  But insisting on a known local port
	makes it easier to monitor packets on the network if we choose to.
    */
    PCAddr.sin_addr.s_addr = INADDR_ANY;
    PCAddr.sin_port = htons(PCPort);
    if (bind (PSock, &PCAddr, sizeof(PCAddr)) != 0)
	{
	perror("PSock");
	exit(-1);
	}
    }

SendPackets()
    {
    register int i;
    struct timeval st;
    
    st.tv_sec = PDelay/1000;
    st.tv_usec = (PDelay*1000)%1000000;

    PBuff->Uniquefier = TrueRandom();
    PBuff->Uniquefier = htonl(PBuff->Uniquefier);
    
    for (i = 0; i < PCount-1; i++)
	{
	PBuff->SeqNo = htonl(i);
	if (PDelay > 0) XmitAndDelay(&st);
	else XmitAndDelay(NULL);
	}

    /* Send a few  stop packets to end sequence */
    PBuff->SeqNo = htonl(STOP);
    for (i = 0; i < SCount; i++)
	{
	XmitAndDelay(NULL);
	}
    }



TrueRandom()
    /*
    Returns a non-zero random number which may be used as the seed of a pseudo-random number generator.
    Obtained by looking at the microseconds part of the time of day.
    How truly random this is depends on the hardware.  On the VAX and SUNs, it seems reasonable when the lowest
    byte of gettimeofday is thrown away.
    */
    {
    struct timeval tp;
    struct timezone tz;

    register long x=0;

    while (x == 0)
	{
	gettimeofday(&tp, &tz);
	x = tp.tv_usec >> 8;	/* No sign problems 'cause tv_usec never has high bit set */
	}    
    return(x);
    }


XmitAndDelay(t)
    struct timeval *t;
    {
    if (sendto(PSock, PBuff, PLen, 0, &PSAddr, sizeof(struct sockaddr_in)) != PLen)
	{
	perror("PSock");
	exit(-1);
	}
    if (t != NULL)
	if (select(0, 0, 0, 0, t) < 0)
	    {
	    perror("select");
	    exit(-1);
	    }

    }



BadArgs()
    {
    printf("Usage: nc [-n count] [-s stopcount] [-l length] [-t delay] [-p serverport] [-b bindport] remotehost\n");
    exit(-1);
    }
