#include	<std.h>
#include	<rt11.h>
#include	<polygn.h>

#define ESC	033

#define	COMMA	'l'	/* , */
#define	DASH	'm'	/* - */
#define	POINT	'n'	/* . */
#define ZERO	'p'	/* 0 */
#define SW	'q'	/* 1 */
#define SOUTH	'r'	/* 2 */
#define SE	's'	/* 3 */
#define WEST	't'	/* 4 */
#define FIVE	'u'	/* 5 */
#define EAST	'v'	/* 6 */
#define NW	'w'	/* 7 */
#define NORTH	'x'	/* 8 */
#define NE	'y'	/* 9 */
#define UP	'A'
#define DOWN	'B'
#define RIGHT	'C'
#define LEFT	'D'
#define ENTER	'M'
#define PF1	'P'
#define PF2	'Q'
#define PF3	'R'
#define PF4	'S'

int	a = 0 ;		/* start with cg1 */
int	curx = 0 ;	/* current x of cursor */
int	cury = 0 ;	/* current y of cursor */
int	savx = 0 ;	/* save an x,y pair */
int	savy = 0 ;
int	dist = 32 ;	/* start with dist of 32 pixels */
int	height = 0 ;	/* of the current characters */
int	width = 0 ;	/* of the current characters */
BOOL	iseras = NO ;	/* erase is off */
BOOL	isdraw = NO ;	/* the pen is up */
BOOL	ison = YES ;	/* cursor is on */
BOOL	ispnt = NO ;	/* no point saved */
BYTES	*jsw = 044 ;

_main()

{
int	j, k, l, m, n, o, p, x, y ;
char	c ;
TEXT	nbuf[10] ;
TEXT	*s ;
GLOBAL	BYTES	*jsw ;
GLOBAL	int	a ;
GLOBAL	int	curx, cury ;
GLOBAL	int	savx, savy ;
GLOBAL	int	dist ;
GLOBAL	int	width, height ;
GLOBAL	BOOL	iseras ;
GLOBAL	BOOL	isdraw ;
GLOBAL	BOOL	ison ;
GLOBAL	BOOL	ispnt ;

s = nbuf ;

chrsel(0) ;
cmap( 0,0,0,0) ;
cmap( 1,2,2,2) ;
cmap( 2,4,4,4) ;
cmap( 3,6,6,6) ;
cmap( 4,8,8,8) ;
cmap( 5,10,10,10) ;
cmap( 6,12,12,12) ;
cmap( 7,14,14,14) ;

move( 0, 0) ;
drawrl( 0, 512) ;
drawrl( 640, 0) ;
drawrl( 0, -512) ;
drawrl( -640, 0 ) ;

chseti( &width, &height, &n, &p) ;

x = 320 ;
y = 256 ;
move( x, y) ;

keymod( 0) ;

FOREVER{
	lights( 0 ) ;
	if( isdraw)
		lights( 1 ) ;
	if( iseras)
		lights( 2 ) ;
	if( a == 1)
		lights( 3 ) ;
	*jsw |= 010000 ;
	while(( c = emt( 0340, 0)) < 0) ;
	switch(c){
		case 'D':
		case 'd':{
			putstr( STDOUT, "Decrement distance to ", NULL) ;
			--dist ;
			putint( STDOUT, dist ) ;
			putstr( STDOUT, " pixels\n", NULL) ;
			break ;
			}
		case 'H':
		case 'h':{
			putstr( STDOUT, "Halve the distance to ",NULL);
			dist = dist / 2 ;
			if( dist < 1)
				dist = 1 ;
			putint(STDOUT, dist) ;
			putstr( STDOUT, " pixels\n", 1) ;
			break ;
			}
		case 'I':
		case 'i':{
			putstr( STDOUT,"Increment distance to ",NULL) ;
			++dist ;
			putint(STDOUT, dist) ;
			putstr( STDOUT, " pixels\n", 1) ;
			break ;
			}
		case 'M':
		case 'm':{
			putstr( STDOUT, "Double distance to ", NULL) ;
			dist = dist * 2 ;
			if( dist > 512)
				dist = 512 ;
			putint(STDOUT, dist) ;
			write( STDOUT, " pixels\n", 1) ;
			break ;
			}
		case 'R':
		case 'r':{
			break ;
			}
		case 'S':
		case 's':{
			break ;
			}
		case 'T':
		case 't':{
			putstr(STDOUT, "Type to the screen\n", NULL) ;
			while(( c = emt( 0340, 0)) != CTRLZ)
				if( c == ESC )
					spechr() ;
				   else{
					rdxy( &x, &y) ;
					if( c == 0177){
						chrout( 010) ;
						setpv( 0, 0) ;
						chrout( 0177) ;
						setpv( 0, 7) ;
						c = 010 ;
						}
					if(( x + width + 1 ) > 639 ){
						chrout( 015) ;
						chrout(	012) ;
						}
					chrout( c) ;
					} /* end of else */
			putstr(STDOUT, "Exit typing routine\n", NULL) ;
			break ;
			} /* end of type case */
		case 'U':
		case 'u':{
			putstr( STDOUT, "Unsave last point\n", NULL) ;
			if( ispnt){
				rdxy( &curx, &cury) ;
				setpv( 0, 0) ;
				pnt( savx, savy) ;
				move( curx, cury) ;
				}
			ispnt = NO ;
			break ;
			}
		case ESC: {
			spechr() ;
			break ;
			} /* end ESC case */
		case '?':{
			putstr(STDOUT, "H - Halve the distance\n", NULL) ;
			putstr(STDOUT, "I - Increment the distance\n", NULL) ;
			putstr(STDOUT, "M - Multiply distance by 2\n", NULL) ;
			putstr(STDOUT, "R - Read an image file\n", NULL) ;
			putstr(STDOUT, "S - Save an image file\n", NULL) ;
			putstr(STDOUT, "T - Type to the screen\n", NULL) ;
			putstr(STDOUT, "U - Unsave the last point\n", NULL) ;
			putstr(STDOUT, "PF1 - Enable/Disable drawing\n",NULL);
			putstr(STDOUT, "PF2 - Enable/Disable erasing\n",NULL);
			putstr(STDOUT, "PF3 - Change character sets\n", NULL);
			putstr(STDOUT, "PF4 - Change char multiplier\n",NULL);
			putstr(STDOUT, "Dash - Erase screen\n", NULL) ;
			putstr(STDOUT, "Comma - Draw a line to last point saved\n", NULL) ;
			putstr(STDOUT, "Enter - Fill with color\n",NULL);
			putstr(STDOUT, "Point - Save a point\n",NULL) ;
			putstr(STDOUT, "Zero - \n",NULL);
			putstr(STDOUT, "Five - Turn on/off cursor\n",NULL);
			break ;
			} /* end of ? case */
		default:{
			break;
			}
		}			/* end outer switch */
	}			/* end of forever */
}			/* end of main */
/* .PAGE */
spechr()
{
char	c ;
int	n, p, x, y ;
TEXT	nbuf[10] ;
TEXT	*s ;
BOOL	ismove = NO ;
GLOBAL	BYTES	*jsw ;
GLOBAL	int	a ;
GLOBAL	int	curx, cury ;
GLOBAL	int	savx, savy ;
GLOBAL	int	dist ;
GLOBAL	int	width, height ;
GLOBAL	BOOL	iseras ;
GLOBAL	BOOL	isdraw ;
GLOBAL	BOOL	ison ;
GLOBAL	BOOL	ispnt ;

s = nbuf ;

	read(STDIN, &c, 1) ;
	read(STDIN, &c, 1) ;
	switch(c){
		case UP:{
			x = 0 ;
			y = height ;
			ismove = YES ;
			break;
			}
		case NORTH:{
			x = 0 ;
			y = dist ;
			ismove = YES ;
			break;
			}
		case NE: {
			x = dist ;
			y = dist ;
			ismove = YES ;
			break ;
			}
		case RIGHT:{
			x = width ;
			y = 0 ;
			ismove = YES ;
			break;
			}
		case EAST: {
			x = dist ;
			y = 0 ;
			ismove = YES ;
			break ;
			}
		case SE: {
			x = dist ;
			y = -dist ;
			ismove = YES ;
			break ;
			}
		case DOWN:{
			x = 0 ;
			y = -height ;
			ismove = YES ;
			break;
			}
		case SOUTH:{
			x = 0 ;
			y = -dist ;
			ismove = YES ;
			break;
			}
		case SW: {
			x = -dist ;
			y = -dist ;
			ismove = YES ;
			break ;
			}
		case LEFT:{
			x = -width ;
			y = 0 ;
			ismove = YES ;
			break;
			}
		case WEST: {
			x = -dist ;
			y = 0 ;
			ismove = YES ;
			break ;
			}
		case NW: {
			x = -dist ;
			y = dist ;
			ismove = YES ;
			break ;
			}
		case PF1:{
			if( isdraw){
				putstr( STDOUT, "Drawing OFF\n", NULL) ;
				isdraw = NO ;
				}
			   else{
				putstr( STDOUT, "Drawing ON\n", NULL) ;
				isdraw = YES ;
				iseras = NO ;
				setpv( 0, 7) ;
				}
			break ;
			}
		case PF2:{
			if( iseras){
				putstr( STDOUT, "Erasing OFF\n", NULL) ;
				iseras = NO ;
				}
			   else{
				putstr( STDOUT, "Erasing ON\n", NULL) ;
				setpv( 0, 0) ;
				iseras = YES ;
				isdraw = NO ;
				}
			break ;
			}
		case PF3:{
			putstr(STDOUT, "Change character set:", NULL) ;
			if( a == 0){
				putstr(STDOUT, " use cg2\n", NULL) ;
				a = 1 ;
				}
			   else{
				putstr(STDOUT, " use cg1\n", NULL) ;
				a = 0 ;
				}
			chrsel( a) ;
			break ;
			}
		case PF4:{
			*jsw ^= 010000 ;
			putstr( STDOUT, "Change the character size\n", NULL);
			putstr( STDOUT, "X Multiplier ", NULL) ;
			c = getch() ;
			if( !isdigit( c))
				break ;
			x = c - '0' ;
			getlin( s, 10) ;
			putstr( STDOUT, "Y Multiplier ", NULL) ;
			c = getch() ;
			if( !isdigit( c))
				break ;
			getlin( s, 10) ;
			y = c - '0' ;
			chgmag( x, y) ;
			chseti( &width, &height, &n, &p) ;
			width *= x ;
			height *= y ;
			*jsw |= 010000 ;
			break ;
			}
		case DASH:{
			putstr( STDOUT, "Clear the screen\n", NULL) ;
			rdxy( &curx, &cury) ;
			clrgr(0) ;
			move( 0, 0) ;
			drawrl( 0, 512) ;
			drawrl( 640, 0) ;
			drawrl( 0, -512) ;
			drawrl( -640, 0 ) ;
			move( curx, cury) ;
			break ;
			}
		case COMMA:{
			putstr(STDOUT,"Draw line to last point saved\n",NULL);
			if( !ispnt)
				break ;
			setpv( 0, 7) ;
			rdxy( &curx, &cury) ;
			move( savx, savy) ;
			draw( curx, cury) ;
			break ;
			}
		case ENTER:{
			*jsw ^= 010000 ;
			rdxy( &curx, &cury) ;
			putstr( STDOUT, "What shade? ", NULL) ;
			c = getch() ;
			if( !isdigit( c))
				break ;
			getlin( s, 10) ;
			n = c - '0' ;
			setfpv( n) ;
			fpsel( 1, 0) ;
			bound( 0, 7) ;
			gfill( curx, cury) ;
			move( curx, cury) ;
			break ;
			}
		case POINT:{
			putstr( STDOUT, "Save a point\n", NULL) ;
			ispnt = YES ;
			rdxy( &savx, &savy) ;
			pnt( savx, savy) ;
			break ;
			}
		case FIVE:{
			if( ison) {
				putstr( STDOUT, "Turn ON cursor\n", NULL) ;
				ison = NO ;
				gcrs(-1) ;
				}
			   else {
				putstr( STDOUT, "Turn OFF cursor\n", NULL) ;
				ison = YES ;
				gcrs(5) ;
				}
			break ;
			}
		default:{
			putstr(STDOUT, "???\n", NULL) ;
			break ;
			}
		}/* end inner switch */
if( ismove )
	if( isdraw || iseras )
		drawrl( x, y ) ;
	   else
		moverl( x, y ) ;
return(0) ;
} /* end spechr routine */
                                                                                                                                                                                                                                                                                                                                                                                                                   